/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.PlotComponent;
import edu.mit.lcp.PlotPanel;
import edu.mit.lcp.Range;
import edu.mit.lcp.Trace;
import edu.mit.lcp.TraceListModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class yScaleComponent
extends JComponent {
    private TraceListModel traceList;
    private List<Scale> _scaleList;
    private int _padding;
    private int _numTicks;
    private PlotPanel _plotPanel;
    private PlotComponent _plot;
    private double min = 0.0;
    private double max = 0.0;
    public static final String PROP_MULTISCALES = "MULTISCALES";
    public PropertyChangeSupport _changes = new PropertyChangeSupport(this);

    public yScaleComponent(TraceListModel traceListModel, int n, int n2, PlotPanel plotPanel) {
        this._scaleList = new ArrayList<Scale>();
        this.traceList = traceListModel;
        this._padding = n;
        this._numTicks = n2;
        this._plotPanel = plotPanel;
        this._plot = plotPanel.getPlot();
        this.setLayout(new BoxLayout(this, 0));
        for (Trace trace : this.traceList) {
            Scale scale = new Scale(trace);
            this._scaleList.add(scale);
            scale.setBorder(new LineBorder(Color.RED, 1));
            this.add(scale);
        }
        this.traceList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                Object object = yScaleComponent.this.traceList.getElementAt(listDataEvent.getIndex0());
                double d = ((Number)((Trace)object).getYRange().lower).doubleValue();
                double d2 = ((Number)((Trace)object).getYRange().upper).doubleValue();
                if (d < yScaleComponent.this.min) {
                    yScaleComponent.this.min = d;
                }
                if (d2 > yScaleComponent.this.max) {
                    yScaleComponent.this.max = d2;
                }
                if (yScaleComponent.this._plotPanel.getMultipleYScales() || yScaleComponent.this._scaleList.size() == 0) {
                    Scale scale = new Scale((Trace)object);
                    yScaleComponent.this._scaleList.add(scale);
                    yScaleComponent.this.add(scale);
                } else {
                    ((Scale)yScaleComponent.this._scaleList.get(0)).setRange(new Range<Double>(yScaleComponent.this.min, yScaleComponent.this.max));
                    for (Trace trace : yScaleComponent.this.traceList) {
                        trace.setYRange(new Range<Double>(yScaleComponent.this.min, yScaleComponent.this.max));
                    }
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (yScaleComponent.this._plotPanel.getMultipleYScales() || !yScaleComponent.this._plotPanel.getMultipleYScales() && yScaleComponent.this.traceList.size() == 0) {
                    Scale scale = (Scale)yScaleComponent.this._scaleList.get(listDataEvent.getIndex0());
                    yScaleComponent.this._scaleList.remove(scale);
                    yScaleComponent.this.remove(scale);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.addPropertyChangeListener(PROP_MULTISCALES, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    Scale scale = (Scale)yScaleComponent.this._scaleList.get(0);
                    scale.setVisible(false);
                    yScaleComponent.this._scaleList.remove(scale);
                    for (Trace trace : yScaleComponent.this.traceList) {
                        Scale scale2 = new Scale(trace);
                        yScaleComponent.this._scaleList.add(scale2);
                        yScaleComponent.this.add(scale2);
                        scale2.repaint();
                    }
                } else {
                    Scale scale = (Scale)yScaleComponent.this._scaleList.get(0);
                    while (yScaleComponent.this._scaleList.size() > 1) {
                        Scale scale3 = (Scale)yScaleComponent.this._scaleList.get(yScaleComponent.this._scaleList.size() - 1);
                        double d = ((Number)scale3.getRange().lower).doubleValue();
                        double d2 = ((Number)scale3.getRange().upper).doubleValue();
                        if (d < yScaleComponent.this.min) {
                            yScaleComponent.this.min = d;
                        }
                        if (d2 > yScaleComponent.this.max) {
                            yScaleComponent.this.max = d2;
                        }
                        scale.setRange(new Range<Double>(yScaleComponent.this.min, yScaleComponent.this.max));
                        scale3.setVisible(false);
                        yScaleComponent.this._scaleList.remove(scale3);
                    }
                    scale.setColor(Color.BLACK);
                    for (Trace trace : yScaleComponent.this.traceList) {
                        trace.setYRange(new Range<Double>(yScaleComponent.this.min, yScaleComponent.this.max));
                    }
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        Insets insets = this.getInsets();
        for (Scale scale : this._scaleList) {
            n += scale.getPreferredSize().width;
        }
        return new Dimension(n += insets.left + insets.right, n2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._changes.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changes.removePropertyChangeListener(propertyChangeListener);
    }

    private class Scale
    extends JComponent {
        private int SCALE_WIDTH = 10;
        private int SCALE_LABEL_SPACING = 2;
        private int MAJOR_TICK_WIDTH = 10;
        private int MINOR_TICK_WIDTH = 5;
        private JLabel ylabel;
        private Font rangeFont = new Font("Serif", 0, 10);
        private Font labelFont = new Font("Serif", 0, 12);
        private JFormattedTextField minField;
        private JFormattedTextField maxField;
        private Color color;
        private List<JFormattedTextField> textfields;
        private int maxScaleLabelWidth;
        private Rectangle _bounds;
        private Trace trace;
        private double scaleMin;
        private double scaleMax;
        NumberFormat doubleFormat = NumberFormat.getNumberInstance();
        private PropertyChangeSupport _changes = new PropertyChangeSupport(this);
        public static final String VALUE = "value";

        Scale(Trace trace) {
            this.trace = trace;
            this.textfields = new ArrayList<JFormattedTextField>();
            this.color = yScaleComponent.this._plotPanel.getMultipleYScales() ? this.trace.getColor() : Color.BLACK;
            this.scaleMin = ((Number)this.trace.getYRange().lower).doubleValue();
            this.scaleMax = ((Number)this.trace.getYRange().upper).doubleValue();
            this.setRange(this.scaleMin, this.scaleMax);
            this.ylabel = new JLabel();
            Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.minField = new JFormattedTextField(this.doubleFormat);
            this.minField.setValue(this.scaleMin);
            this.minField.setColumns(2);
            this.minField.setFont(this.rangeFont);
            this.minField.setForeground(this.color);
            this.minField.setHorizontalAlignment(4);
            this.add(this.minField);
            this.textfields.add(this.minField);
            double d = this.scaleMax - this.scaleMin;
            double d2 = d / (double)yScaleComponent.this._numTicks;
            for (int i = 1; i < yScaleComponent.this._numTicks; ++i) {
                JFormattedTextField jFormattedTextField = new JFormattedTextField();
                jFormattedTextField.setFont(this.rangeFont);
                jFormattedTextField.setForeground(this.color);
                jFormattedTextField.setHorizontalAlignment(4);
                jFormattedTextField.setValue(this.scaleMin + d2 * (double)i);
                jFormattedTextField.setColumns(2);
                jFormattedTextField.setEditable(false);
                jFormattedTextField.setBorder(border);
                this.add(jFormattedTextField);
                this.textfields.add(jFormattedTextField);
            }
            this.maxField = new JFormattedTextField(this.doubleFormat);
            this.maxField.setValue(this.scaleMax);
            this.maxField.setColumns(2);
            this.maxField.setFont(this.rangeFont);
            this.maxField.setForeground(this.color);
            this.maxField.setHorizontalAlignment(4);
            this.add(this.maxField);
            this.textfields.add(this.maxField);
            this.minField.addPropertyChangeListener(VALUE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.scaleMin = ((Number)Scale.this.minField.getValue()).doubleValue();
                    yScaleComponent.this.min = Scale.this.scaleMin;
                    for (Object object : yScaleComponent.this._scaleList) {
                        if (!(((Number)((Scale)object).getRange().lower).doubleValue() < Scale.this.scaleMin)) continue;
                        yScaleComponent.this.min = ((Number)((Scale)object).getRange().lower).doubleValue();
                    }
                    if (yScaleComponent.this._plotPanel.getMultipleYScales()) {
                        Scale.this.trace.setYRange(new Range<Double>(Scale.this.scaleMin, Scale.this.scaleMax));
                    } else {
                        for (Object object : yScaleComponent.this.traceList) {
                            ((Trace)object).setYRange(new Range<Double>(Scale.this.scaleMin, ((Number)((Trace)object).getYRange().upper).doubleValue()));
                        }
                    }
                    Scale.this.updateComponent();
                }
            });
            this.maxField.addPropertyChangeListener(VALUE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.scaleMax = ((Number)Scale.this.maxField.getValue()).doubleValue();
                    yScaleComponent.this.max = Scale.this.scaleMax;
                    for (Object object : yScaleComponent.this._scaleList) {
                        if (!(((Number)((Scale)object).getRange().upper).doubleValue() > Scale.this.scaleMax)) continue;
                        yScaleComponent.this.max = ((Number)((Scale)object).getRange().upper).doubleValue();
                    }
                    if (yScaleComponent.this._plotPanel.getMultipleYScales()) {
                        Scale.this.trace.setYRange(new Range<Double>(Scale.this.scaleMin, Scale.this.scaleMax));
                    } else {
                        for (Object object : yScaleComponent.this.traceList) {
                            ((Trace)object).setYRange(new Range<Double>(((Number)((Trace)object).getYRange().lower).doubleValue(), Scale.this.scaleMax));
                        }
                    }
                    Scale.this.updateComponent();
                }
            });
            this.trace.addPropertyChangeListener("YRANGE", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Range range = (Range)propertyChangeEvent.getNewValue();
                    Scale.this.setRange(range);
                    Scale.this.scaleMin = ((Number)range.lower).doubleValue();
                    Scale.this.scaleMax = ((Number)range.upper).doubleValue();
                    if (Scale.this.scaleMin < yScaleComponent.this.min) {
                        yScaleComponent.this.min = Scale.this.scaleMin;
                    }
                    if (Scale.this.scaleMax > yScaleComponent.this.max) {
                        yScaleComponent.this.max = Scale.this.scaleMax;
                    }
                    Scale.this.updateComponent();
                }
            });
            this.trace.addPropertyChangeListener("COLOR", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.color = (Color)propertyChangeEvent.getNewValue();
                    for (int i = 0; i < yScaleComponent.this._numTicks + 1; ++i) {
                        JFormattedTextField jFormattedTextField = (JFormattedTextField)Scale.this.textfields.get(i);
                        jFormattedTextField.setForeground(Scale.this.color);
                    }
                    Scale.this.repaint();
                }
            });
            this.trace.addPropertyChangeListener("ENABLED", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.setVisible((Boolean)propertyChangeEvent.getNewValue());
                    Scale.this.updateComponent();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    Scale.this.updateComponent();
                }
            });
            this.updateComponent();
        }

        public void setRange(Range range) {
            this.setRange(((Number)range.lower).doubleValue(), ((Number)range.upper).doubleValue());
        }

        public void setRange(double d, double d2) {
            this.scaleMin = d;
            this.scaleMax = d2;
        }

        public Range getRange() {
            return new Range<Double>(this.scaleMin, this.scaleMax);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.updateComponent();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(this.color);
        }

        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension(0, 2 * this.ylabel.getPreferredSize().height);
            if (this.isVisible()) {
                dimension.width = this.SCALE_WIDTH + this.SCALE_LABEL_SPACING + this.maxScaleLabelWidth + this.ylabel.getPreferredSize().width + this.getInsets().left + this.getInsets().right;
            }
            return dimension;
        }

        public Dimension getMaximumSize() {
            return new Dimension(this.getMinimumSize().width, Integer.MAX_VALUE);
        }

        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        private void updateComponent() {
            this.updateBounds();
            this.updateLabels();
            this.positionScaleLabels();
        }

        private void updateMaxScaleLabelWidth() {
            int n = 0;
            int n2 = 0;
            for (JFormattedTextField jFormattedTextField : this.textfields) {
                n2 = jFormattedTextField.getPreferredSize().width;
                if (n2 <= n) continue;
                n = n2;
            }
            this.maxScaleLabelWidth = n;
        }

        private void updateLabels() {
            double d = this.scaleMax - this.scaleMin;
            double d2 = d / (double)yScaleComponent.this._numTicks;
            for (int i = 0; i < yScaleComponent.this._numTicks + 1; ++i) {
                JFormattedTextField jFormattedTextField = this.textfields.get(i);
                jFormattedTextField.setValue(this.scaleMin + d2 * (double)i);
            }
            this.updateMaxScaleLabelWidth();
        }

        private void positionScaleLabels() {
            Insets insets = this.getInsets();
            double d = yScaleComponent.this._plot.getDeltaY();
            int n = 12;
            for (int i = 0; i < this.textfields.size(); ++i) {
                JFormattedTextField jFormattedTextField = this.textfields.get(i);
                Dimension dimension = jFormattedTextField.getPreferredSize();
                jFormattedTextField.setBounds(this._bounds.x, (int)((double)(this._bounds.y + this._bounds.height) - (double)dimension.height / 2.0 - (double)i * d) - n, this.maxScaleLabelWidth, dimension.height);
            }
        }

        private void updateBounds() {
            Insets insets = this.getInsets();
            this._bounds = this.getBounds();
            this._bounds.x = insets.left;
            this._bounds.y = insets.top;
            this._bounds.width -= insets.left + insets.right + 1;
            this._bounds.height -= insets.top + insets.bottom + 1;
        }

        public void setColor(Color color) {
            this.color = color;
            this.minField.setForeground(this.color);
            this.maxField.setForeground(this.color);
            for (JFormattedTextField jFormattedTextField : this.textfields) {
                jFormattedTextField.setForeground(this.color);
            }
            this.repaint();
        }
    }
}

