/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.PlotPanelStripChart;
import edu.mit.lcp.SimulationOutputVariable;
import edu.mit.lcp.SimulationOutputVariableListModel;
import edu.mit.lcp.Trace;
import edu.mit.lcp.TraceListModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PlotLegendPanel
extends JPanel {
    private Graphics2D g2d;
    private TraceListModel traceList;
    private JPanel tracePanel;
    private Trace dynamicTrace;
    private PlotPanelStripChart plotPanel;
    private PlotAddElement addPlotTraceElement;

    PlotLegendPanel(TraceListModel traceListModel, PlotPanelStripChart plotPanelStripChart) {
        this.traceList = traceListModel;
        this.plotPanel = plotPanelStripChart;
        this.setLayout(new BoxLayout(this, 1));
        this.tracePanel = new JPanel();
        this.tracePanel.setLayout(new BoxLayout(this.tracePanel, 1));
        this.addPlotTraceElement = new PlotAddElement(CVSim.sim.getOutputVariables());
        this.add(this.addPlotTraceElement);
        this.add(new JSeparator());
        this.add(this.tracePanel);
        this.add(new Box.Filler(new Dimension(1, 1), new Dimension(1, Integer.MAX_VALUE), new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE)));
        this.traceList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                PlotLegendPanel.this.rePopulateLegend();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                PlotLegendPanel.this.rePopulateLegend();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                PlotLegendPanel.this.rePopulateLegend();
            }
        });
        this.populateLegend();
    }

    private void populateLegend() {
        this.dynamicTrace = this.addPlotTraceElement.getTrace();
        for (Trace trace : this.traceList) {
            if (this.dynamicTrace == trace) continue;
            this.tracePanel.add(new PlotLegendElement(trace));
        }
    }

    private void rePopulateLegend() {
        this.tracePanel.removeAll();
        this.populateLegend();
        this.tracePanel.revalidate();
    }

    private class PlotLegendElement
    extends JComponent {
        public Trace myTrace;
        private JMenuBar settingsMenuBar;
        private ColorChooserMenu colorMenu;
        private StrokeChooserMenu strokeMenu;

        PlotLegendElement(Trace trace) {
            this.myTrace = trace;
            this.setLayout(new FlowLayout(3, 0, 0));
            this.settingsMenuBar = new JMenuBar();
            this.settingsMenuBar.setMargin(new Insets(0, 0, 0, 0));
            this.colorMenu = new ColorChooserMenu(this.myTrace.getColor());
            this.settingsMenuBar.add(this.colorMenu);
            this.myTrace.addPropertyChangeListener("COLOR", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PlotLegendElement.this.colorMenu.setSelectedColor((Color)propertyChangeEvent.getNewValue());
                }
            });
            JLabel jLabel = new JLabel(trace.toString());
            JCheckBox jCheckBox = new JCheckBox(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlotLegendElement.this.myTrace.setEnabled(((JCheckBox)actionEvent.getSource()).isSelected());
                }
            });
            jCheckBox.setSelected(this.myTrace.isEnabled());
            JButton jButton = new JButton(new AbstractAction("X"){

                public void actionPerformed(ActionEvent actionEvent) {
                    CVSim.sim.removeVariableRecorder(PlotLegendElement.this.myTrace.getXVar());
                    CVSim.sim.removeVariableRecorder(PlotLegendElement.this.myTrace.getYVar());
                    PlotLegendPanel.this.traceList.remove(PlotLegendElement.this.myTrace);
                }
            });
            jButton.setMargin(new Insets(1, 1, 1, 1));
            jButton.setContentAreaFilled(false);
            this.add(jCheckBox);
            this.add(jButton);
            this.add(this.settingsMenuBar);
            this.add(jLabel);
        }

        private class TraceStrokeMenuAction
        extends AbstractAction {
            private Trace trace;
            private Stroke stroke;

            public TraceStrokeMenuAction(Trace trace, Stroke stroke) {
                this.trace = trace;
                this.stroke = stroke;
                this.putValue("SmallIcon", new StrokeSquareIcon(stroke));
                this.putValue("ShortDescription", stroke.toString());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.trace.setStroke(this.stroke);
            }
        }

        class StrokeSquareIcon
        implements Icon {
            private Stroke stroke;
            private int _size;

            public StrokeSquareIcon(Stroke stroke) {
                this(stroke, 12);
            }

            public StrokeSquareIcon(Stroke stroke, int n) {
                this.stroke = stroke;
                this._size = n;
            }

            public Stroke getStroke() {
                return this.stroke;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics.getColor();
                graphics2D.setColor(Color.WHITE);
                graphics2D.fill3DRect(n, n2, this.getIconWidth(), this.getIconHeight(), true);
                graphics2D.setColor(Color.BLACK);
                graphics2D.setStroke(this.stroke);
                graphics2D.drawLine(n, n2 + this.getIconHeight() / 2, n + this.getIconWidth() - 1, n2 + this.getIconHeight() / 2);
                graphics2D.setColor(color);
            }

            public int getIconWidth() {
                return this._size;
            }

            public int getIconHeight() {
                return this._size;
            }
        }

        class StrokeChooserMenu
        extends JMenu {
            StrokeChooserMenu() {
                this(new BasicStroke());
            }

            StrokeChooserMenu(Stroke stroke) {
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setIcon(new StrokeSquareIcon(stroke));
                this.add(new TraceStrokeMenuAction(PlotLegendElement.this.myTrace, new BasicStroke()));
                this.add(new TraceStrokeMenuAction(PlotLegendElement.this.myTrace, new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{1.0f, 1.0f}, 0.0f)));
            }

            public void setSelectedStroke(Stroke stroke) {
                this.setIcon(new StrokeSquareIcon(stroke));
            }

            public Stroke getSelectedStroke() {
                return ((StrokeSquareIcon)this.getIcon()).getStroke();
            }
        }

        private class TraceColorMenuAction
        extends AbstractAction {
            private Trace trace;
            private Color color;

            public TraceColorMenuAction(Trace trace, Color color) {
                this.trace = trace;
                this.color = color;
                this.putValue("SmallIcon", new ColoredSquareIcon(color));
                this.putValue("ShortDescription", color.toString());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.trace.setColor(this.color);
            }
        }

        class ColoredSquareIcon
        implements Icon {
            private Color color;
            private int _size;

            public ColoredSquareIcon(Color color) {
                this(color, 12);
            }

            public ColoredSquareIcon(Color color, int n) {
                this.color = color;
                this._size = n;
            }

            public Color getColor() {
                return this.color;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                graphics.fill3DRect(n, n2, this.getIconWidth(), this.getIconHeight(), true);
                graphics.setColor(color);
            }

            public int getIconWidth() {
                return this._size;
            }

            public int getIconHeight() {
                return this._size;
            }
        }

        class ColorChooserMenu
        extends JMenu {
            ColorChooserMenu() {
                this(Color.BLACK);
            }

            ColorChooserMenu(Color color) {
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setIcon(new ColoredSquareIcon(color));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.BLACK));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.BLUE));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.CYAN));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.GREEN));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.LIGHT_GRAY));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.MAGENTA));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.ORANGE));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.PINK));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.RED));
                this.add(new TraceColorMenuAction(PlotLegendElement.this.myTrace, Color.YELLOW));
            }

            public void setSelectedColor(Color color) {
                this.setIcon(new ColoredSquareIcon(color));
            }

            public Color getSelectedColor() {
                return ((ColoredSquareIcon)this.getIcon()).getColor();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlotAddElement
    extends JComponent {
        private JComboBox xTraceBox;
        private JComboBox yTraceBox;
        private Trace tempTrace;
        private ActionListener xTraceBoxActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        private ActionListener yTraceBoxActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        private ActionListener addButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotLegendPanel.this.plotPanel.createNewTrace((SimulationOutputVariable)PlotAddElement.this.yTraceBox.getSelectedItem());
            }
        };

        PlotAddElement(List<SimulationOutputVariable> list) {
            this.setLayout(new FlowLayout(3, 0, 0));
            this.xTraceBox = new JComboBox(new SimulationOutputVariableListModel(list));
            this.xTraceBox.addActionListener(this.xTraceBoxActionListener);
            this.yTraceBox = new JComboBox(new SimulationOutputVariableListModel(list));
            this.yTraceBox.addActionListener(this.yTraceBoxActionListener);
            JButton jButton = new JButton("+");
            jButton.setMargin(new Insets(1, 1, 1, 1));
            jButton.addActionListener(this.addButtonActionListener);
            this.add(new JLabel("X:"));
            this.add(this.xTraceBox);
            this.add(new JLabel("Y:"));
            this.add(this.yTraceBox);
            this.add(jButton);
        }

        public Trace getTrace() {
            return this.tempTrace;
        }
    }
}

