/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.PlotPoints;
import edu.mit.lcp.Trace;
import edu.mit.lcp.TraceListModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class PlotComponent
extends JComponent {
    public static final int PARAMETRIC = 1;
    public static final int STRIPCHART = 2;
    public static final int SCALE_X_DPI = 1;
    public static final int SCALE_Y_DPI = 2;
    private static final int NUM_TICKS = 5;
    private TraceListModel traceList;
    private Rectangle bounds;
    private AffineTransform plotTransform;
    private double _deltaY;
    private double _deltaX;
    private boolean showXGridlines = false;
    private boolean showYGridlines = false;
    private int _flags;
    private int DPI;
    private Rectangle2D.Double scaledBounds;
    public List<PlotPoints> pointList = new ArrayList<PlotPoints>();
    private int _plotType;

    public PlotComponent(TraceListModel traceListModel, int n) {
        this(traceListModel, 0, n);
    }

    public PlotComponent(TraceListModel traceListModel, int n, int n2) {
        this.traceList = traceListModel;
        this._flags = n;
        this._plotType = n2;
        this.DPI = Toolkit.getDefaultToolkit().getScreenResolution();
        this.plotTransform = new AffineTransform();
        this.scaledBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PlotComponent.this.updateBounds();
                PlotComponent.this.repaint();
            }
        });
        this.setOpaque(true);
    }

    public TraceListModel getListModel() {
        return this.traceList;
    }

    public void setListModel(TraceListModel traceListModel) {
        this.traceList = traceListModel;
    }

    public AffineTransform getPlotTransform() {
        return this.plotTransform;
    }

    public void setShowXGridlines(boolean bl) {
        this.showXGridlines = bl;
    }

    public void setShowYGridlines(boolean bl) {
        this.showYGridlines = bl;
    }

    public double getDeltaX() {
        return this._deltaX;
    }

    public double getDeltaY() {
        return this._deltaY;
    }

    private void updatePlotWindowTransform() {
        switch (this._plotType) {
            case 1: {
                this.plotTransform.setToIdentity();
                this.plotTransform.translate(this.bounds.x, this.bounds.height + this.bounds.y);
                this.plotTransform.scale(1.0, -1.0);
                this.plotTransform.scale((double)this.bounds.width / this.scaledBounds.getWidth(), (double)this.bounds.height / this.scaledBounds.getHeight());
                break;
            }
            case 2: {
                this.plotTransform.setToIdentity();
                this.plotTransform.translate(this.bounds.width + this.bounds.x, this.bounds.height + this.bounds.y);
                this.plotTransform.scale(-1.0, -1.0);
                this.plotTransform.scale((double)this.bounds.width / this.scaledBounds.getWidth(), (double)this.bounds.height / this.scaledBounds.getHeight());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        this.updateBounds();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.clipRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        this.drawBackground(graphics2D);
        this.drawGridlines(graphics2D);
        this.drawTraces(graphics2D);
        this.drawPoints(graphics2D);
    }

    private void drawBackground(Graphics2D graphics2D) {
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    private void drawTraces(Graphics2D graphics2D) {
        for (Trace trace : this.traceList) {
            if (!trace.isEnabled()) continue;
            graphics2D.setColor(trace.getColor());
            graphics2D.setStroke(trace.getStroke());
            graphics2D.draw(trace);
        }
    }

    private void drawPoints(Graphics2D graphics2D) {
        if (CVSim.simThread.isRunning()) {
            this.pointList.clear();
        } else {
            int n = 15;
            int n2 = 10;
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHints(renderingHints);
            for (PlotPoints plotPoints : this.pointList) {
                if (!plotPoints.isEnabled()) continue;
                graphics2D.setColor(Color.BLACK);
                Ellipse2D.Float float_ = new Ellipse2D.Float(plotPoints.getX(), plotPoints.getY(), 5.0f, 5.0f);
                graphics2D.draw(float_);
                graphics2D.fill(float_);
                for (int i = 0; i < plotPoints.getSize(); ++i) {
                    graphics2D.setColor(plotPoints.getColor(i));
                    graphics2D.drawString(plotPoints.getString(i), plotPoints.getX() + n2, plotPoints.getY() - i * n);
                }
            }
        }
    }

    private void drawGridlines(Graphics2D graphics2D) {
        AffineTransform affineTransform = new AffineTransform();
        this._deltaX = this.bounds.getWidth() / 5.0;
        this._deltaY = this.bounds.getHeight() / 5.0;
        affineTransform.setToIdentity();
        affineTransform.translate(this.bounds.x, this.bounds.height + this.bounds.y);
        affineTransform.scale(1.0, -1.0);
        affineTransform.scale(this._deltaX, this._deltaY);
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        GeneralPath generalPath3 = new GeneralPath();
        for (int i = 1; i < 5; ++i) {
            generalPath.moveTo(0.0f, i);
            generalPath.lineTo(5.0f, i);
            generalPath2.moveTo(0.0f, i);
            generalPath2.lineTo(0.1f, i);
            generalPath3.moveTo(i, 0.0f);
            generalPath3.lineTo(i, 0.1f);
        }
        graphics2D.setPaint(Color.LIGHT_GRAY);
        graphics2D.draw(affineTransform.createTransformedShape(generalPath));
        graphics2D.draw(affineTransform.createTransformedShape(generalPath3));
    }

    private void updateBounds() {
        Insets insets = this.getInsets();
        this.bounds = this.getBounds();
        this.bounds.x = insets.left;
        this.bounds.y = insets.top;
        this.bounds.width -= insets.left + insets.right;
        this.bounds.height -= insets.top + insets.bottom;
        if ((this._flags & 1) == 1) {
            this.scaledBounds.width = this.bounds.getWidth() / (double)this.DPI;
        }
        if ((this._flags & 2) == 2) {
            this.scaledBounds.height = this.bounds.getHeight() / (double)this.DPI;
        }
        this.updatePlotWindowTransform();
    }

    public Rectangle getPlotBounds() {
        return this.bounds;
    }

    public Rectangle2D getScaledPlotBounds() {
        return this.scaledBounds;
    }
}

