/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.Parameter;
import edu.mit.lcp.ParameterTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterPanel
extends JPanel {
    private static final String CHOICE_ALL = "ALL";
    public static final String DEFAULT = "Default";
    public static final String PATIENT = "Patient";
    public static String displayMode = "Default";
    public ParameterTableModel model;
    public JTable table;
    private boolean highlightingOff = false;
    private JScrollPane scrollPane;
    private JMenu actionsMenu;
    private JLabel categoryComboBoxLabel;
    public JComboBox categoryComboBox;
    private JLabel typeComboBoxLabel;
    public JComboBox typeComboBox;
    private JButton selectButton;
    private JMenu selectButtonMenu;
    private JMenu selectMenu;
    private JButton loadButton;
    private JMenuItem loadMenuItem;
    private JButton saveButton;
    private JMenuItem saveMenuItem;
    private JButton resetButton;
    private JMenuItem resetMenuItem;
    private JButton clearHighlightingButton;
    private JMenuItem clearHighlightingMenuItem;
    private JCheckBox highlightingOffCheckBox;
    private JCheckBoxMenuItem highlightingOffCheckBoxMenuItem;
    private JButton exitPatientModeButton;
    private JMenuItem exitPatientModeMenuItem;
    private ItemListener HighlightingOffListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ParameterPanel.this.highlightingOffCheckBox) {
                if (((JCheckBox)itemEvent.getSource()).isSelected()) {
                    ParameterPanel.this.highlightingOff = true;
                    ParameterPanel.this.highlightingOffCheckBoxMenuItem.setSelected(true);
                    ParameterPanel.this.model.updateHighlightList(null);
                } else {
                    ParameterPanel.this.highlightingOff = false;
                    ParameterPanel.this.highlightingOffCheckBoxMenuItem.setSelected(false);
                }
            } else if (itemEvent.getSource() == ParameterPanel.this.highlightingOffCheckBoxMenuItem) {
                if (((JCheckBoxMenuItem)itemEvent.getSource()).isSelected()) {
                    ParameterPanel.this.highlightingOff = true;
                    ParameterPanel.this.highlightingOffCheckBox.setSelected(true);
                    ParameterPanel.this.model.updateHighlightList(null);
                } else {
                    ParameterPanel.this.highlightingOff = false;
                    ParameterPanel.this.highlightingOffCheckBox.setSelected(false);
                }
            }
        }
    };
    private ActionListener ClearHighlightingListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ParameterPanel.this.model.updateHighlightList(null);
        }
    };
    private ActionListener CategoryComboBoxListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
            ParameterPanel.this.setCategoryComboBoxSelection(string);
        }
    };
    private ActionListener TypeComboBoxListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
            ParameterPanel.this.setTypeComboBoxSelection(string);
        }
    };

    public ParameterPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.model = new ParameterTableModel(CVSim.sim.getParameterList(), this);
        this.actionsMenu = new JMenu("Parameters");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        JLabel jLabel = new JLabel("Show Location:");
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 7));
        jToolBar.add(jLabel);
        this.categoryComboBox = new JComboBox<String>(this.getModelCategoryChoices());
        this.categoryComboBox.addActionListener(this.CategoryComboBoxListener);
        jToolBar.add(this.categoryComboBox);
        JLabel jLabel2 = new JLabel("Show Type:");
        jLabel2.setBorder(new EmptyBorder(0, 7, 0, 7));
        jToolBar.add(jLabel2);
        this.typeComboBox = new JComboBox<String>(this.getModelParameterTypeChoices());
        this.typeComboBox.addActionListener(this.TypeComboBoxListener);
        jToolBar.add(this.typeComboBox);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.setRollover(true);
        this.selectButtonMenu = new JMenu("Select");
        JMenuItem jMenuItem = new JMenuItem("Select All");
        jMenuItem.addActionListener(new SelectAllParametersAction(this));
        JMenuItem jMenuItem2 = new JMenuItem("Select Visible");
        jMenuItem2.addActionListener(new SelectVisibleParametersAction(this));
        JMenuItem jMenuItem3 = new JMenuItem("Select None");
        jMenuItem3.addActionListener(new SelectNoneParametersAction(this));
        this.selectButtonMenu.add(jMenuItem);
        this.selectButtonMenu.add(jMenuItem2);
        this.selectButtonMenu.add(jMenuItem3);
        this.selectButton = new DropDownToolbarButton(this.selectButtonMenu);
        jToolBar2.add(this.selectButton);
        this.selectMenu = new JMenu("Select");
        JMenuItem jMenuItem4 = new JMenuItem("Select All");
        jMenuItem4.addActionListener(new SelectAllParametersAction(this));
        JMenuItem jMenuItem5 = new JMenuItem("Select Visible");
        jMenuItem5.addActionListener(new SelectVisibleParametersAction(this));
        JMenuItem jMenuItem6 = new JMenuItem("Select None");
        jMenuItem6.addActionListener(new SelectNoneParametersAction(this));
        this.selectMenu.add(jMenuItem4);
        this.selectMenu.add(jMenuItem5);
        this.selectMenu.add(jMenuItem6);
        this.actionsMenu.add(this.selectMenu);
        this.loadButton = new JButton(new LoadParametersFromFileAction(this, "Selected"));
        jToolBar2.add(this.loadButton);
        this.loadMenuItem = new JMenuItem("Load");
        this.loadMenuItem.addActionListener(new LoadParametersFromFileAction(this, "Selected"));
        this.actionsMenu.add(this.loadMenuItem);
        this.saveButton = new JButton(new SaveParametersToFileAction(this, "Selected"));
        jToolBar2.add(this.saveButton);
        this.saveMenuItem = new JMenuItem("Snapshot");
        this.saveMenuItem.addActionListener(new SaveParametersToFileAction(this, "Selected"));
        this.actionsMenu.add(this.saveMenuItem);
        this.resetButton = new JButton(new ResetParametersAction(this.resetMenuItem, "Selected"));
        jToolBar2.add(this.resetButton);
        this.resetMenuItem = new JMenuItem("Restore Default Values");
        this.resetMenuItem.addActionListener(new ResetParametersAction(this.resetMenuItem, "Selected"));
        this.actionsMenu.add(this.resetMenuItem);
        JToolBar jToolBar3 = new JToolBar();
        jToolBar3.setFloatable(false);
        jToolBar3.setRollover(true);
        this.clearHighlightingButton = new JButton("Clear Highlighting");
        this.clearHighlightingButton.addActionListener(this.ClearHighlightingListener);
        jToolBar3.add(this.clearHighlightingButton);
        this.clearHighlightingMenuItem = new JMenuItem("Clear Highlighting");
        this.clearHighlightingMenuItem.addActionListener(this.ClearHighlightingListener);
        this.actionsMenu.add(this.clearHighlightingMenuItem);
        this.highlightingOffCheckBox = new JCheckBox("Highlighting Off");
        this.highlightingOffCheckBox.addItemListener(this.HighlightingOffListener);
        jToolBar3.add(this.highlightingOffCheckBox);
        this.highlightingOffCheckBoxMenuItem = new JCheckBoxMenuItem("Highlighting Off");
        this.highlightingOffCheckBoxMenuItem.addItemListener(this.HighlightingOffListener);
        this.actionsMenu.add(this.highlightingOffCheckBoxMenuItem);
        this.exitPatientModeButton = new JButton("Exit Patient Mode");
        this.exitPatientModeButton.addActionListener(new ExitPatientModeAction(this));
        this.exitPatientModeButton.setEnabled(false);
        jToolBar3.add(this.exitPatientModeButton);
        this.exitPatientModeMenuItem = new JMenuItem("Exit Patient Mode");
        this.exitPatientModeMenuItem.addActionListener(new ExitPatientModeAction(this));
        this.exitPatientModeMenuItem.setEnabled(false);
        this.actionsMenu.add(this.exitPatientModeMenuItem);
        CVSim.sim.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ParameterPanel.this.model.fireTableDataChanged();
            }
        });
        this.table = new JTable(this.model){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                Parameter parameter = ParameterPanel.this.model.getFilteredParameterList().get(n);
                if (ParameterPanel.this.model.highlightList.contains(parameter)) {
                    component.setBackground(new Color(250, 250, 126));
                } else {
                    component.setBackground(Color.WHITE);
                }
                return component;
            }
        };
        this.table.setCellSelectionEnabled(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(10);
        ParameterValueCellRenderer parameterValueCellRenderer = new ParameterValueCellRenderer();
        this.table.setDefaultRenderer(String.class, parameterValueCellRenderer);
        this.table.getColumnModel().getColumn(1).setCellEditor(new ParameterValueCellEditor(new JTextField()));
        this.scrollPane = new JScrollPane(this.table);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)jToolBar2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)jToolBar3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    public String getDisplayMode() {
        return displayMode;
    }

    public void setDisplayMode(String string) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (string.equals(DEFAULT)) {
            this.saveButton.setEnabled(true);
            this.selectButton.setEnabled(true);
            this.loadButton.setEnabled(true);
            this.resetButton.setEnabled(true);
            this.exitPatientModeButton.setEnabled(false);
            this.exitPatientModeMenuItem.setEnabled(false);
            this.saveMenuItem.setEnabled(true);
            this.selectMenu.setEnabled(true);
            this.loadMenuItem.setEnabled(true);
            this.resetMenuItem.setEnabled(true);
            CVSim.gui.toolbar._abReflexOnButton.setEnabled(true);
            CVSim.gui.toolbar._abReflexOffButton.setEnabled(true);
            CVSim.gui.toolbar._cpReflexOnButton.setEnabled(true);
            CVSim.gui.toolbar._cpReflexOffButton.setEnabled(true);
        } else if (string.equals(PATIENT)) {
            this.saveButton.setEnabled(false);
            this.selectButton.setEnabled(false);
            this.loadButton.setEnabled(false);
            this.resetButton.setEnabled(false);
            this.exitPatientModeButton.setEnabled(true);
            this.exitPatientModeMenuItem.setEnabled(true);
            this.saveMenuItem.setEnabled(false);
            this.selectMenu.setEnabled(false);
            this.loadMenuItem.setEnabled(false);
            this.resetMenuItem.setEnabled(false);
            CVSim.gui.toolbar._abReflexOnButton.setEnabled(false);
            CVSim.gui.toolbar._abReflexOffButton.setEnabled(false);
            CVSim.gui.toolbar._cpReflexOnButton.setEnabled(false);
            CVSim.gui.toolbar._cpReflexOffButton.setEnabled(false);
        }
        displayMode = string;
    }

    public JMenu getMenuOfActions() {
        return this.actionsMenu;
    }

    public boolean getHighlightingOff() {
        return this.highlightingOff;
    }

    public void resetParameters(List<Parameter> list) {
        for (Parameter parameter : list) {
            Double d = parameter.getDefaultValue();
            Double d2 = parameter.getValue();
            if (!d2.equals(d)) {
                parameter.setValue(parameter.getDefaultValue());
                parameter.setPercent(100.0);
                System.out.println(parameter.getName() + " reset to " + d + " (was " + d2 + ")");
            }
            this.model.fireTableDataChanged();
        }
        this.deselectAllParameters();
    }

    private void selectAllParameters() {
        for (Parameter parameter : this.model.getParameterList()) {
            this.model.setParameterSelected(parameter, true);
        }
    }

    private void deselectAllParameters() {
        for (Parameter parameter : this.model.getParameterList()) {
            this.model.setParameterSelected(parameter, false);
        }
    }

    private void WriteParameterFile(List<Parameter> list, File file) throws Exception {
        Properties properties = new Properties();
        for (Parameter parameter : list) {
            properties.setProperty(parameter.getName(), parameter.getValue().toString());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.storeToXML(fileOutputStream, "CVSIM Simulation Parameter File. (Written by Version: " + CVSim.versionNumber + ", Model: " + CVSim.simulationModelName + ")");
        fileOutputStream.close();
    }

    private void ReadParameterFile(List<Parameter> list, File file) throws Exception {
        boolean bl = false;
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.loadFromXML(fileInputStream);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (Parameter parameter : list) {
                double d;
                if (!parameter.getName().equals(string)) continue;
                bl = true;
                double d2 = parameter.getValue();
                if (d2 == (d = Double.valueOf(properties.getProperty(string)).doubleValue())) continue;
                parameter.setValue(d);
                System.out.println("Parameter \"" + parameter + "\" set to " + d + " (was " + d2 + ")");
            }
            if (bl) continue;
            System.out.println("\"" + string + "\" did not match parameter");
        }
    }

    private String[] getModelCategoryChoices() {
        List<String> list = this.model.getCategoryNames();
        list.add(0, CHOICE_ALL);
        Object[] objectArray = new String[list.size()];
        list.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[] getModelParameterTypeChoices() {
        List<String> list = this.model.getFilteredParameterTypeNames();
        list.add(0, CHOICE_ALL);
        Object[] objectArray = new String[list.size()];
        list.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void setCategoryComboBoxSelection(String string) {
        if (string.equals(CHOICE_ALL)) {
            string = null;
        }
        this.model.setCategoryFilter(string);
        String string2 = (String)this.typeComboBox.getSelectedItem();
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(this.getModelParameterTypeChoices()));
        this.typeComboBox.setSelectedItem(string2);
        if (!((String)this.typeComboBox.getSelectedItem()).equals(string2)) {
            this.typeComboBox.setSelectedItem(CHOICE_ALL);
        }
    }

    public void setTypeComboBoxSelection(String string) {
        if (string.equals(CHOICE_ALL)) {
            string = null;
        }
        this.model.setTypeFilter(string);
    }

    public void recenterTable(int n) {
        JViewport jViewport = this.scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        int n2 = this.table.rowAtPoint(point);
        Dimension dimension = jViewport.getExtentSize();
        int n3 = (int)(dimension.getHeight() / (double)this.table.getRowHeight());
        int n4 = n - n3 / 2;
        if (n4 < 0) {
            n4 = 0;
        }
        int n5 = point.y + (n4 - n2) * this.table.getRowHeight();
        jViewport.setViewPosition(new Point(point.x, n5));
    }

    private class ParameterValueCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        JTextField tf;

        public ParameterValueCellEditor(JTextField jTextField) {
            super(jTextField);
            this.tf = jTextField;
            jTextField.setHorizontalAlignment(4);
            jTextField.addFocusListener(this);
            this.clickCountToStart = 1;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tf.setText(object.toString());
            return this.tf;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.tf.selectAll();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    public class ParameterValueCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Parameter parameter = ParameterPanel.this.model.getFilteredParameterList().get(n);
            component.setForeground(Color.BLACK);
            component.setBackground(Color.WHITE);
            if (ParameterPanel.this.model.highlightList.contains(parameter)) {
                component.setBackground(new Color(250, 250, 126));
            }
            ParameterTableModel cfr_ignored_0 = ParameterPanel.this.model;
            if (n2 == 1) {
                this.setHorizontalAlignment(4);
                String string = String.format("Allowed range: %.2f to %.2f", parameter.getMin(), parameter.getMax());
                this.setToolTipText(string);
                Double d = parameter.getDefaultValue();
                Double d2 = Double.valueOf(object.toString());
                Double d3 = parameter.getPercent();
                if (displayMode.equals(ParameterPanel.DEFAULT)) {
                    if (!d2.equals(d)) {
                        component.setForeground(Color.RED);
                    }
                } else if (displayMode.equals(ParameterPanel.PATIENT) && d3 != 100.0) {
                    component.setForeground(Color.RED);
                }
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    private class DropDownToolbarButton
    extends JButton {
        private JPopupMenu buttonMenu;

        public DropDownToolbarButton(JMenu jMenu) {
            super(jMenu.getText());
            this.buttonMenu = jMenu.getPopupMenu();
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    DropDownToolbarButton.this.buttonMenu.show(component, 0, component.getHeight());
                }
            });
        }

        public void addMenuItem(JMenuItem jMenuItem) {
            this.buttonMenu.add(jMenuItem);
        }
    }

    private class LoadParametersFromFileAction
    extends AbstractAction {
        private JFileChooser fc;
        private File file;
        private Component pc;
        private String subAction;

        public LoadParametersFromFileAction(Component component, String string) {
            this.subAction = string;
            this.putValue("Name", "Load");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fc = new JFileChooser();
            if (this.subAction.equals("Selected") && ParameterPanel.this.model.getSelectedParameterList().size() == 0) {
                JOptionPane.showMessageDialog(this.pc, "You have not selected any parameters.", "Error", 0);
            } else if (this.fc.showOpenDialog(this.pc) == 0) {
                File file = this.fc.getSelectedFile();
                System.out.println("Loading Parameters From: " + file);
                try {
                    if (this.subAction.equals("All")) {
                        ParameterPanel.this.ReadParameterFile(ParameterPanel.this.model.getParameterList(), file);
                    } else if (this.subAction.equals("Selected")) {
                        ParameterPanel.this.ReadParameterFile(ParameterPanel.this.model.getSelectedParameterList(), file);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    ParameterPanel.this.deselectAllParameters();
                }
                catch (Exception exception) {
                    System.out.println("Error loading parameters. Some parameter values may have changed." + exception);
                    JOptionPane.showMessageDialog(this.pc, "Error Loading Parameters from " + file.toString() + "\n-----\nException Says: " + exception, "File Error", 0);
                }
            }
        }
    }

    private class SaveParametersToFileAction
    extends AbstractAction {
        private JFileChooser fc;
        private File file;
        private Component pc;
        private String subAction;

        public SaveParametersToFileAction(Component component, String string) {
            this.subAction = string;
            this.putValue("Name", "Snapshot");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fc = new JFileChooser();
            if (this.subAction.equals("Selected") && ParameterPanel.this.model.getSelectedParameterList().size() == 0) {
                JOptionPane.showMessageDialog(this.pc, "You have not selected any parameters.", "Error", 0);
            } else if (this.fc.showSaveDialog(this.pc) == 0) {
                File file = this.fc.getSelectedFile();
                System.out.println("Saving parameters to: " + file);
                try {
                    if (this.subAction.equals("All")) {
                        ParameterPanel.this.WriteParameterFile(ParameterPanel.this.model.getParameterList(), file);
                    } else if (this.subAction.equals("Selected")) {
                        ParameterPanel.this.WriteParameterFile(ParameterPanel.this.model.getSelectedParameterList(), file);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    ParameterPanel.this.deselectAllParameters();
                }
                catch (Exception exception) {
                    System.out.println("Error saving parameters. " + exception);
                    JOptionPane.showMessageDialog(this.pc, "Error Saving Parameters to " + file.toString() + "\n-----\nException Says: " + exception, "File Error", 0);
                }
            }
        }
    }

    private class ResetParametersAction
    extends AbstractAction {
        private Component pc;
        private String subAction;

        public ResetParametersAction(Component component, String string) {
            this.subAction = string;
            this.putValue("Name", "Restore");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.subAction.equals("Selected") && ParameterPanel.this.model.getSelectedParameterList().size() == 0) {
                JOptionPane.showMessageDialog(this.pc, "You have not selected any parameters.", "Error", 0);
            } else {
                int n = JOptionPane.showConfirmDialog(this.pc, "Do you really want to restore the " + this.subAction.toLowerCase() + " parameters?", "Restore Parameters?", 0);
                if (n == 0) {
                    if (this.subAction.equals("All")) {
                        ParameterPanel.this.setDisplayMode(ParameterPanel.DEFAULT);
                        ParameterPanel.this.resetParameters(ParameterPanel.this.model.getParameterList());
                    } else if (this.subAction.equals("Selected")) {
                        ParameterPanel.this.resetParameters(ParameterPanel.this.model.getSelectedParameterList());
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
    }

    private class SelectNoneParametersAction
    extends AbstractAction {
        private Component pc;

        public SelectNoneParametersAction(Component component) {
            super("Select None");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (Parameter parameter : ParameterPanel.this.model.getParameterList()) {
                ParameterPanel.this.model.setParameterSelected(parameter, false);
            }
        }
    }

    private class SelectVisibleParametersAction
    extends AbstractAction {
        private Component pc;

        public SelectVisibleParametersAction(Component component) {
            super("Select Visible");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (Parameter parameter : ParameterPanel.this.model.getFilteredParameterList()) {
                ParameterPanel.this.model.setParameterSelected(parameter, true);
            }
        }
    }

    private class SelectAllParametersAction
    extends AbstractAction {
        private Component pc;

        public SelectAllParametersAction(Component component) {
            super("Select All");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParameterPanel.this.selectAllParameters();
        }
    }

    private class ExitPatientModeAction
    extends AbstractAction {
        private Component pc;

        public ExitPatientModeAction(Component component) {
            super("Exit Patient Mode");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParameterPanel.this.setDisplayMode(ParameterPanel.DEFAULT);
            ParameterPanel.this.resetParameters(ParameterPanel.this.model.getParameterList());
        }
    }
}

