/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.ParameterPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class Parameter {
    private PropertyChangeSupport _propChangeListeners = new PropertyChangeSupport(this);
    private String _category;
    private String _type;
    private String _name;
    private String _units;
    private int _index;
    private Double _defaultValue;
    private Double _ptModeDefaultValue;
    private double _percent;
    private double _max = Double.POSITIVE_INFINITY;
    private double _min = Double.NEGATIVE_INFINITY;

    public Parameter(int n, String string, String string2, String string3, String string4) {
        this._index = n;
        this._category = string;
        this._type = string2;
        this._name = string3;
        this._units = string4;
        this._defaultValue = new Double(0.0);
        this._ptModeDefaultValue = new Double(0.0);
        this._percent = 100.0;
    }

    public Parameter(int n, String string, String string2, String string3, String string4, double d, double d2) {
        this._index = n;
        this._category = string;
        this._type = string2;
        this._name = string3;
        this._units = string4;
        this._defaultValue = new Double(0.0);
        this._ptModeDefaultValue = new Double(0.0);
        this._percent = 100.0;
        this._min = d;
        this._max = d2;
    }

    public int getIndex() {
        return this._index;
    }

    public String getCategory() {
        return this._category;
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public abstract void setValue(Double var1);

    public abstract Double getValue();

    public void setPercent(Double d) {
        Double d2 = this.getPercent();
        this._percent = d;
        ParameterPanel cfr_ignored_0 = CVSim.gui.parameterPanel;
        if (CVSim.gui.parameterPanel.getDisplayMode().equals("Default")) {
            this.setValue(d / 100.0 * this.getDefaultValue());
        } else {
            ParameterPanel cfr_ignored_1 = CVSim.gui.parameterPanel;
            if (CVSim.gui.parameterPanel.getDisplayMode().equals("Patient")) {
                this.setValue(d / 100.0 * this.getPtModeDefaultValue());
            }
        }
        String string = String.format(this.getName() + ": Changing percent from " + d2.toString() + " to " + d.toString() + "\n" + this.getName() + ": Changing value from default of " + this.getDefaultValue().toString() + " to " + this.getValue().toString(), new Object[0]);
        System.out.println(string);
    }

    public Double getPercent() {
        return this._percent;
    }

    public Double getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(Double d) {
        this._defaultValue = d;
    }

    public void setDefaultValue() {
        this.setDefaultValue(this.getValue());
    }

    public Double getPtModeDefaultValue() {
        return this._ptModeDefaultValue;
    }

    public void setPtModeDefaultValue(Double d) {
        this._ptModeDefaultValue = d;
    }

    public String getUnits() {
        return this._units;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public String toString() {
        return this.getName();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propChangeListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._propChangeListeners.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propChangeListeners.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this._propChangeListeners.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this._propChangeListeners.firePropertyChange(propertyChangeEvent);
    }
}

