/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.Parameter;
import edu.mit.lcp.SimulationOutputVariable;
import edu.mit.lcp.SimulationOutputVariableBuffer;
import edu.mit.lcp.VariableRecorderInterface;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFile {
    File dataFile;
    List<SimulationOutputVariable> outputList;
    List<Parameter> parameterList;
    List<VariableRecorderInterface> recList;
    PrintStream dataPrintStream;
    private ChangeListener sourceDataChanged;

    public OutputFile(List<Parameter> list, List<SimulationOutputVariable> list2, File file) {
        this.parameterList = new ArrayList<Parameter>(list);
        this.outputList = new ArrayList<SimulationOutputVariable>(list2);
        this.dataFile = file;
        this.recList = new ArrayList<VariableRecorderInterface>(this.outputList.size());
        this.sourceDataChanged = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                OutputFile.this.writeData();
            }
        };
    }

    public void startLogging() {
        for (SimulationOutputVariable object : this.outputList) {
            this.recList.add(new SimulationOutputVariableBuffer<Double>(object, new Double(0.0)));
        }
        for (VariableRecorderInterface variableRecorderInterface : this.recList) {
            CVSim.sim.addVariableRecorder(variableRecorderInterface);
        }
        this.openFile();
        this.writeHeader();
        CVSim.sim.addChangeListener(this.sourceDataChanged);
    }

    public void stopLogging() {
        CVSim.sim.removeChangeListener(this.sourceDataChanged);
        for (VariableRecorderInterface variableRecorderInterface : this.recList) {
            CVSim.sim.removeVariableRecorder(variableRecorderInterface);
        }
        this.closeFile();
    }

    private void openFile() {
        try {
            this.dataPrintStream = new PrintStream(this.dataFile);
        }
        catch (Exception exception) {
            System.err.println("Error opening file " + this.dataFile);
            System.err.println(exception);
        }
    }

    private void closeFile() {
        try {
            this.dataPrintStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error closing file " + this.dataFile);
            System.err.println(exception);
        }
    }

    private void writeData() {
        for (VariableRecorderInterface object : this.recList) {
            this.dataPrintStream.printf("%f\t", object.getLastDatum());
        }
        for (Parameter parameter : this.parameterList) {
            this.dataPrintStream.printf("%f\t", parameter.getValue());
        }
        this.dataPrintStream.printf("\n", new Object[0]);
    }

    public void writeHeader() {
        String string = this.dataFile.getName();
        String string2 = string.substring(0, string.indexOf(".")) + ".hea";
        File file = new File(this.dataFile.getParent(), string2);
        try {
            PrintStream printStream = new PrintStream(file);
            printStream.printf("MIT Cardiovascular Simulator Output Header File\n", new Object[0]);
            printStream.printf("This file describes the data in " + this.dataFile.getName() + ".\n\n", new Object[0]);
            int n = 1;
            for (VariableRecorderInterface object : this.recList) {
                printStream.printf("Column %d:\t" + object.getDescription() + " (" + object.getUnits() + ")\n", n);
                ++n;
            }
            for (Parameter parameter : this.parameterList) {
                printStream.printf("Column %d:\t" + parameter.getName() + " (" + parameter.getUnits() + ")\n", n);
                ++n;
            }
            printStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error writing file header to " + file);
            System.err.println(exception);
        }
    }
}

