/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MouseSpinnerLabel
extends JLabel
implements MouseListener,
MouseMotionListener,
ChangeListener {
    SpinnerNumberModel dataModel = new SpinnerNumberModel();
    double mousedownValue;
    Rectangle mouseenterDim;
    LineBorder highlight;

    public MouseSpinnerLabel(String string) {
        super(string);
        this.dataModel.addChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.highlight = new LineBorder(Color.BLACK, 1);
    }

    public SpinnerModel getModel() {
        return this.dataModel;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mousedownValue = (double)mouseEvent.getPoint().y + Double.parseDouble(this.getText());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mousedownValue = Double.parseDouble(this.getText());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseenterDim = this.getBounds();
        this.setBounds(this.mouseenterDim.x - 1, this.mouseenterDim.y - 1, this.mouseenterDim.width + 2, this.mouseenterDim.height + 2);
        this.setBorder(this.highlight);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setBorder(null);
        this.setBounds(this.mouseenterDim);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dataModel.setValue(this.mousedownValue - (double)mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)changeEvent.getSource();
        this.setText(spinnerNumberModel.getNumber().toString());
    }
}

