/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.Parameter;
import edu.mit.lcp.SimulationOutputVariable;
import edu.mit.lcp.VariableRecorderInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSimulation {
    public static final String COMPRESSION = "COMPRESSION";
    public static final String ABREFLEX = "ABREFLEX";
    public static final String CPREFLEX = "CPREFLEX";
    protected long steps;
    private int _dataCompressionFactor = 10;
    private boolean _ABReflex;
    private boolean _CPReflex;
    private PropertyChangeSupport _propChangeListeners = new PropertyChangeSupport(this);
    PropertyChangeListener SimulationParameterChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CSimulation.this.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName() + ((Parameter)propertyChangeEvent.getSource()).getName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
        }
    };
    private EventListenerList _changeListeners = new EventListenerList();
    private List<VariableRecorderInterface> varRecorders = new CopyOnWriteArrayList<VariableRecorderInterface>();
    protected List<SimulationOutputVariable> varList;

    public abstract void reset();

    public abstract void step();

    public abstract double getOutput(int var1);

    public abstract void updatePressure(int var1, double var2);

    public abstract List<Parameter> getParameterList();

    public abstract Parameter getParameterByName(String var1);

    public void setDataCompressionFactor(int n) {
        int n2 = this.getDataCompressionFactor();
        this._dataCompressionFactor = n;
        this.firePropertyChange(COMPRESSION, n2, n);
        System.out.println("DataCompressionFactor = " + n);
    }

    public int getDataCompressionFactor() {
        return this._dataCompressionFactor;
    }

    public void setABReflex(boolean bl) {
        boolean bl2 = this.getABReflex();
        this._ABReflex = bl;
        this.firePropertyChange(ABREFLEX, bl2, bl);
    }

    public boolean getABReflex() {
        return this._ABReflex;
    }

    protected int getABReflex_C() {
        return this.getABReflex() ? 1 : 0;
    }

    public void setCPReflex(boolean bl) {
        boolean bl2 = this.getCPReflex();
        this._CPReflex = bl;
        this.firePropertyChange(CPREFLEX, bl2, bl);
    }

    public boolean getCPReflex() {
        return this._CPReflex;
    }

    protected int getCPReflex_C() {
        return this.getCPReflex() ? 1 : 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propChangeListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._propChangeListeners.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propChangeListeners.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this._propChangeListeners.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this._propChangeListeners.firePropertyChange(propertyChangeEvent);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.remove(ChangeListener.class, changeListener);
    }

    public void dataChanged() {
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this._changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public void addVariableRecorder(VariableRecorderInterface variableRecorderInterface) {
        this.varRecorders.add(variableRecorderInterface);
    }

    public void removeVariableRecorder(VariableRecorderInterface variableRecorderInterface) {
        this.varRecorders.remove(variableRecorderInterface);
    }

    protected List<VariableRecorderInterface> getVariableRecorders() {
        return this.varRecorders;
    }

    public void updateRecorders() {
        for (VariableRecorderInterface variableRecorderInterface : this.getVariableRecorders()) {
            variableRecorderInterface.addMarkedDatum(new Double(this.getOutput(variableRecorderInterface.getOutputIndex())), Math.round(this.getOutput(0) * 100.0));
        }
    }

    protected List<SimulationOutputVariable> getOutputVariables() {
        return this.varList;
    }

    protected SimulationOutputVariable getOutputVariable(String string) {
        for (SimulationOutputVariable simulationOutputVariable : this.varList) {
            if (!simulationOutputVariable.getName().equals(string)) continue;
            return simulationOutputVariable;
        }
        return null;
    }

    public class ComparatorX
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((Parameter)object).getName().compareTo(((Parameter)object2).getName());
        }
    }
}

