/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme.internal.laftheme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.draggable.DraggableComponentBox;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanel;
import net.infonode.tabbedpanel.theme.internal.laftheme.ComponentCache;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneHandler;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneHandlerListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.PanePainter;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneUIListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.SizeIcon;
import net.infonode.tabbedpanel.theme.internal.laftheme.TabData;
import net.infonode.util.Direction;

public class PaneUI {
    private static final boolean PAINT_TAB_AREA = true;
    private static final boolean PAINT_CONTENT_AREA = true;
    private static final boolean PAINT_TAB = true;
    private static final boolean TEXT_ICON_GAP_COMPENSATE = true;
    private static final int DEFAULT_SELECTED_INDEX = 3;
    private static final int DEFAULT_TAB_COUNT = 7;
    private static final int EXTRA_SIZE = 2;
    private static final String EMPTY_STRING = "";
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.UP, Direction.LEFT, Direction.DOWN, Direction.RIGHT};
    private Insets[] areaInsets = new Insets[DIRECTIONS.length];
    private Insets[] normalInsets = new Insets[DIRECTIONS.length];
    private Insets[] selectedInsets = new Insets[DIRECTIONS.length];
    private Insets[] adjustedContentInsets = new Insets[DIRECTIONS.length];
    private Insets[] adjustedContentInsetsTabAreaHidden = new Insets[DIRECTIONS.length];
    private Insets[] contentInsets = new Insets[DIRECTIONS.length];
    private Dimension[] minimumSizes = new Dimension[DIRECTIONS.length];
    private Dimension[] tabMinimumSizes = new Dimension[DIRECTIONS.length];
    private int[] spacings = new int[DIRECTIONS.length];
    private int[] raiseds = new int[DIRECTIONS.length];
    private Insets[] tabInsets = new Insets[DIRECTIONS.length];
    private Color[] contentTabAreaBorderColors = new Color[DIRECTIONS.length];
    private boolean[] swapWidthHeights = new boolean[DIRECTIONS.length];
    private boolean tabAreaNotVisibleFix = false;
    private int scrollOffset = 0;
    private int textIconGap;
    private PaneUIListener listener;
    private static ComponentCache componentCache = new ComponentCache();
    private PaneHandler paneHandler = new PaneHandler(new PaneHandlerListener(){

        public void updating() {
            PaneUI.this.setEnabled(false);
            PaneUI.this.listener.updating();
        }

        public void updated() {
            PaneUI.this.doInit();
            PaneUI.this.setEnabled(true);
            PaneUI.this.listener.updated();
        }
    });
    private Tab hoveredTab;
    private TabData tabData = new TabData();
    private boolean tabAreaOpaque;
    private boolean contentOpaque;
    private boolean opaque;
    private boolean tabAreaComponentsOpaque;
    private boolean enabled = true;

    public PaneUI(PaneUIListener paneUIListener) {
        this.listener = paneUIListener;
    }

    public void init() {
        this.paneHandler.update();
    }

    private void doInit() {
        this.initPreCommonValues();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            PanePainter panePainter = this.paneHandler.getPainter(DIRECTIONS[i]);
            this.initValues(panePainter, i, DIRECTIONS[i]);
            this.reset(panePainter);
        }
        this.initPostCommonValues();
    }

    public void dispose() {
        this.enabled = false;
        this.paneHandler.dispose();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private void initPreCommonValues() {
        this.tabAreaNotVisibleFix = UIManager.getLookAndFeel().getClass().getName().indexOf(".WindowsLookAndFeel") > -1;
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        if (this.textIconGap <= 0) {
            this.textIconGap = 4;
        }
        this.opaque = this.paneHandler.getPainter(Direction.UP).isOpaque();
        Boolean bl = (Boolean)UIManager.get("TabbedPane.contentOpaque");
        this.contentOpaque = bl == null ? this.opaque : bl;
        this.tabAreaOpaque = this.opaque;
        this.tabAreaComponentsOpaque = false;
    }

    private void initPostCommonValues() {
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            this.scrollOffset = Math.max(this.scrollOffset, Math.max(this.minimumSizes[i].width, this.minimumSizes[i].height));
        }
    }

    private void initValues(PanePainter panePainter, int n, Direction direction) {
        Insets insets;
        this.estimateSwappedTabDirection(panePainter, n, direction);
        this.reset(panePainter);
        panePainter.setSize(1000, 1000);
        boolean bl = !direction.isHorizontal();
        for (int i = 0; i < 7; ++i) {
            panePainter.addTab(EMPTY_STRING, this.getComponent());
        }
        panePainter.setSelectedIndex(3);
        panePainter.doValidation();
        Serializable serializable = UIManager.getInsets("TabbedPane.tabInsets");
        if (serializable == null) {
            serializable = new Insets(0, 0, 0, 0);
        }
        this.tabInsets[n] = !bl ? new Insets(0, ((Insets)serializable).left, 0, ((Insets)serializable).right) : InsetsUtil.EMPTY_INSETS;
        serializable = panePainter.getBoundsAt(0);
        Cloneable cloneable = panePainter.getBoundsAt(panePainter.getSelectedIndex());
        this.raiseds[n] = direction == Direction.UP ? Math.max(0, ((Rectangle)serializable).y - cloneable.y) : (direction == Direction.LEFT ? Math.max(0, ((Rectangle)serializable).x - cloneable.x) : (direction == Direction.DOWN ? this.raiseds[this.getDirectionIndex(Direction.UP)] : this.raiseds[this.getDirectionIndex(Direction.LEFT)]));
        serializable = this.getCalculatedInsets(panePainter, 0, false, direction);
        cloneable = this.getCalculatedInsets(panePainter, 0, true, direction);
        this.spacings[n] = bl ? ((Insets)serializable).left + ((Insets)serializable).right - ((Insets)cloneable).left - ((Insets)cloneable).right : ((Insets)serializable).top + ((Insets)serializable).bottom - ((Insets)cloneable).top - ((Insets)cloneable).bottom;
        this.normalInsets[n] = this.getCalculatedInsets(panePainter, 0, false, direction);
        serializable = this.getCalculatedInsets(panePainter, 0, true, direction);
        int n2 = this.spacings[n];
        int n3 = n2 / 2;
        int n4 = n2 / 2 + n2 % 2;
        if (direction == Direction.UP) {
            ((Insets)serializable).bottom = this.normalInsets[n].bottom;
            ((Insets)serializable).top = this.normalInsets[n].top;
            ((Insets)serializable).left += n3;
            ((Insets)serializable).right += n4;
        } else if (direction == Direction.LEFT) {
            ((Insets)serializable).right = this.normalInsets[n].right;
            ((Insets)serializable).left = this.normalInsets[n].left;
            ((Insets)serializable).top += n3;
            ((Insets)serializable).bottom += n4;
        } else if (direction == Direction.RIGHT) {
            ((Insets)serializable).right = this.normalInsets[n].right;
            ((Insets)serializable).left = this.normalInsets[n].left;
            ((Insets)serializable).top += n3;
            ((Insets)serializable).bottom += n4;
        } else {
            ((Insets)serializable).bottom = this.normalInsets[n].bottom;
            ((Insets)serializable).top = this.normalInsets[n].top;
            ((Insets)serializable).left += n3;
            ((Insets)serializable).right += n4;
        }
        this.selectedInsets[n] = serializable;
        serializable = new JPanel();
        panePainter.addTab(EMPTY_STRING, (Component)serializable);
        panePainter.setSelectedIndex(panePainter.getTabCount() - 1);
        panePainter.doValidation();
        Point point = SwingUtilities.convertPoint(((Component)serializable).getParent(), ((Component)serializable).getLocation(), panePainter);
        Rectangle rectangle = panePainter.getBoundsAt(0);
        n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (direction == Direction.UP) {
            n4 = point.y - rectangle.height - rectangle.y;
            n5 = point.x;
            n6 = panePainter.getHeight() - point.y - ((JComponent)serializable).getHeight();
            n7 = panePainter.getWidth() - point.x - ((JComponent)serializable).getWidth();
        } else if (direction == Direction.DOWN) {
            n4 = point.y;
            n5 = point.x;
            n6 = panePainter.getHeight() - ((JComponent)serializable).getHeight() - point.y - (panePainter.getHeight() - rectangle.y);
            n7 = panePainter.getWidth() - point.x - ((JComponent)serializable).getWidth();
        } else if (direction == Direction.LEFT) {
            n4 = point.y;
            n5 = point.x - rectangle.width - rectangle.x;
            n6 = panePainter.getHeight() - point.y - ((JComponent)serializable).getHeight();
            n7 = panePainter.getWidth() - point.x - ((JComponent)serializable).getWidth();
        } else {
            n4 = point.y;
            n5 = point.x;
            n6 = panePainter.getHeight() - point.y - ((JComponent)serializable).getHeight();
            n7 = panePainter.getWidth() - ((JComponent)serializable).getWidth() - point.x - (panePainter.getWidth() - rectangle.x);
        }
        this.contentInsets[n] = new Insets(n4, n5, n6, n7);
        Insets insets2 = this.contentInsets[0];
        Insets insets3 = InsetsUtil.rotate(direction.getNextCW(), insets2);
        this.adjustedContentInsets[n] = insets = InsetsUtil.max(insets2, insets3);
        this.adjustedContentInsetsTabAreaHidden[n] = new Insets(direction == Direction.UP ? insets.left : insets.top, direction == Direction.LEFT ? insets.top : insets.left, direction == Direction.DOWN ? insets.right : insets.bottom, direction == Direction.RIGHT ? insets.bottom : insets.right);
        panePainter.removeTabAt(panePainter.getTabCount() - 1);
        panePainter.setSelectedIndex(3);
        panePainter.doValidation();
        serializable = panePainter.getBoundsAt(3);
        this.tabMinimumSizes[n] = new Dimension(((Rectangle)serializable).width, ((Rectangle)serializable).height);
        this.minimumSizes[n] = new Dimension(((Rectangle)serializable).width - this.tabInsets[n].left - this.tabInsets[n].right, ((Rectangle)serializable).height - this.tabInsets[n].top - this.tabInsets[n].bottom);
        this.calculateAreaInsets(panePainter, n, direction);
        this.estimateContentTabAreaBorderColor(panePainter, n, direction);
    }

    private void calculateAreaInsets(PanePainter panePainter, int n, Direction direction) {
        int n2;
        panePainter.setSelectedIndex(0);
        Rectangle rectangle = panePainter.getBoundsAt(0);
        panePainter.setSelectedIndex(3);
        Rectangle rectangle2 = panePainter.getBoundsAt(0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (direction == Direction.UP) {
            n3 = Math.min(rectangle.x, rectangle2.x);
            n4 = Math.min(rectangle.y, rectangle2.y);
            n5 = 0;
        } else if (direction == Direction.DOWN) {
            n3 = Math.min(rectangle.x, rectangle2.x);
            n4 = 0;
            n5 = panePainter.getHeight() - Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        } else if (direction == Direction.LEFT) {
            n4 = Math.min(rectangle.y, rectangle2.y);
            n3 = Math.min(rectangle.x, rectangle2.x);
            n6 = 0;
        } else {
            n4 = Math.min(rectangle.y, rectangle2.y);
            n3 = 0;
            n6 = panePainter.getWidth() - Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        }
        Dimension dimension = panePainter.getSize();
        this.reset(panePainter);
        for (n2 = 0; n2 < 4; ++n2) {
            panePainter.addTab(EMPTY_STRING, SizeIcon.EMPTY, this.getComponent());
        }
        panePainter.setSelectedIndex(-1);
        panePainter.setSize(panePainter.getMinimumSize());
        panePainter.doValidation();
        if (!direction.isHorizontal()) {
            n2 = panePainter.getWidth() - 1;
            boolean bl = false;
            while (!bl) {
                panePainter.setSize(++n2, panePainter.getHeight());
                panePainter.doValidation();
                bl = panePainter.getBoundsAt((int)0).y == panePainter.getBoundsAt((int)3).y;
            }
            Rectangle rectangle3 = panePainter.getBoundsAt(3);
            n6 = panePainter.getWidth() - rectangle3.x - rectangle3.width - this.spacings[n];
        } else {
            n2 = panePainter.getHeight() - 1;
            boolean bl = false;
            while (!bl) {
                panePainter.setSize(panePainter.getWidth(), ++n2);
                panePainter.doValidation();
                bl = panePainter.getBoundsAt((int)0).x == panePainter.getBoundsAt((int)3).x;
            }
            Rectangle rectangle4 = panePainter.getBoundsAt(3);
            n5 = panePainter.getHeight() - rectangle4.y - rectangle4.height - this.spacings[n];
        }
        this.areaInsets[n] = new Insets(n4, n3, n5, n6);
        panePainter.setSize(dimension);
        panePainter.doValidation();
    }

    private void estimateContentTabAreaBorderColor(PanePainter panePainter, int n, final Direction direction) {
        Dimension dimension = panePainter.getSize();
        this.reset(panePainter);
        panePainter.addTab(EMPTY_STRING, SizeIcon.EMPTY, this.getComponent());
        panePainter.setSelectedIndex(-1);
        Dimension dimension2 = panePainter.getMinimumSize();
        if (direction.isHorizontal()) {
            panePainter.setSize(dimension2.width, dimension2.height * 2);
        } else {
            panePainter.setSize(dimension2.width * 2, dimension2.height);
        }
        panePainter.doValidation();
        Rectangle rectangle = panePainter.getBoundsAt(0);
        BufferedImage bufferedImage = new BufferedImage(panePainter.getWidth(), panePainter.getHeight(), 2);
        int n2 = 0;
        int n3 = 0;
        if (direction == Direction.UP) {
            n2 = rectangle.x + rectangle.width / 2;
            n3 = panePainter.getHeight() - this.contentInsets[n].top - this.contentInsets[n].bottom - 1;
        } else if (direction == Direction.DOWN) {
            n2 = rectangle.x + rectangle.width / 2;
            n3 = this.contentInsets[n].top + this.contentInsets[n].bottom;
        } else if (direction == Direction.LEFT) {
            n2 = panePainter.getWidth() - this.contentInsets[n].left - this.contentInsets[n].right - 1;
            n3 = rectangle.y + rectangle.height / 2;
        } else {
            n2 += this.contentInsets[n].left + this.contentInsets[n].right;
            n3 = rectangle.y + rectangle.height / 2;
        }
        final int n4 = n2;
        final int n5 = n3;
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){

            public int filterRGB(int n, int n2, int n3) {
                if (n4 == n && n5 == n2) {
                    int n42 = n3 >> 16 & 0xFF;
                    int n52 = n3 >> 8 & 0xFF;
                    int n6 = n3 & 0xFF;
                    int n7 = n3 >> 24 & 0xFF;
                    ((PaneUI)PaneUI.this).contentTabAreaBorderColors[((PaneUI)PaneUI.this).getDirectionIndex((Direction)direction.getOpposite())] = new Color(n42, n52, n6, n7);
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        panePainter.paint(bufferedImage.getGraphics());
        BufferedImage bufferedImage2 = new BufferedImage(panePainter.getWidth(), panePainter.getHeight(), 2);
        bufferedImage2.getGraphics().drawImage(Toolkit.getDefaultToolkit().createImage(filteredImageSource), 0, 0, null);
        panePainter.setSize(dimension);
        panePainter.doValidation();
    }

    private void estimateSwappedTabDirection(PanePainter panePainter, int n, Direction direction) {
        this.reset(panePainter);
        SizeIcon sizeIcon = new SizeIcon(80, 80);
        SizeIcon sizeIcon2 = new SizeIcon(160, 80);
        panePainter.addTab(EMPTY_STRING, sizeIcon, this.getComponent());
        panePainter.doValidation();
        Rectangle rectangle = panePainter.getBoundsAt(0);
        panePainter.setIconAt(0, sizeIcon2);
        panePainter.doValidation();
        Rectangle rectangle2 = panePainter.getBoundsAt(0);
        this.swapWidthHeights[n] = (double)rectangle2.height > 1.5 * (double)rectangle.height;
    }

    public boolean isContentOpaque() {
        return this.contentOpaque;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isTabAreaComponentsOpaque() {
        return this.tabAreaComponentsOpaque;
    }

    public boolean isTabAreaOpaque() {
        return this.tabAreaOpaque;
    }

    public Font getFont() {
        return this.paneHandler.getPainter(Direction.UP).getFont();
    }

    public boolean isSwapWidthHeight(Direction direction) {
        return this.swapWidthHeights[this.getDirectionIndex(direction)];
    }

    public Insets getNormalInsets(Direction direction) {
        return this.normalInsets[this.getDirectionIndex(direction)];
    }

    public Insets getSelectedInsets(Direction direction) {
        return this.selectedInsets[this.getDirectionIndex(direction)];
    }

    public Insets getNormalTabInsets(Direction direction, Direction direction2) {
        return this.getRealTabInsets(direction, direction2, this.getNormalInsets(direction));
    }

    public Insets getSelectedTabInsets(Direction direction, Direction direction2) {
        return this.getRealTabInsets(direction, direction2, this.getSelectedInsets(direction));
    }

    private Insets getRealTabInsets(Direction direction, Direction direction2, Insets insets) {
        insets = InsetsUtil.rotate(direction2, insets);
        if (this.swapWidthHeights[this.getDirectionIndex(direction)]) {
            insets = InsetsUtil.rotate(direction.getNextCCW(), insets);
        }
        return insets;
    }

    public Insets getContentInsets(Direction direction, boolean bl) {
        return bl ? this.adjustedContentInsets[this.getDirectionIndex(direction)] : this.adjustedContentInsetsTabAreaHidden[this.getDirectionIndex(direction)];
    }

    public Insets getTabAreaInsets(Direction direction) {
        return this.areaInsets[this.getDirectionIndex(direction)];
    }

    public Dimension getTabExternalMinSize(Direction direction) {
        return this.minimumSizes[this.getDirectionIndex(direction)];
    }

    public Insets getTabInsets(Direction direction) {
        return this.tabInsets[this.getDirectionIndex(direction)];
    }

    public int getTabSpacing(Direction direction) {
        return this.spacings[this.getDirectionIndex(direction)];
    }

    public int getSelectedRaised(Direction direction) {
        return this.raiseds[this.getDirectionIndex(direction)];
    }

    public Color getContentTabAreaBorderColor(Direction direction) {
        return this.contentTabAreaBorderColors[this.getDirectionIndex(direction)];
    }

    public int getTabSpacing() {
        return 0;
    }

    public int getTextIconGap() {
        return this.textIconGap;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    private int getWidthCompensate(Direction direction) {
        if (this.swapWidthHeights[this.getDirectionIndex(direction)]) {
            return 0;
        }
        return this.getTextIconGap();
    }

    private int getHeightCompensate(Direction direction) {
        if (!this.swapWidthHeights[this.getDirectionIndex(direction)]) {
            return 0;
        }
        return this.getTextIconGap();
    }

    private int getDirectionIndex(Direction direction) {
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (DIRECTIONS[i] != direction) continue;
            return i;
        }
        return 0;
    }

    private Insets getCalculatedInsets(PanePainter panePainter, int n, boolean bl, Direction direction) {
        Rectangle rectangle = panePainter.getBoundsAt(n);
        int n2 = rectangle.height + rectangle.width;
        Icon icon = panePainter.getIconAt(n);
        panePainter.setIconAt(n, new SizeIcon(n2, n2));
        if (bl) {
            panePainter.setSelectedIndex(n);
        }
        Rectangle rectangle2 = panePainter.getBoundsAt(n);
        panePainter.setIconAt(n, icon);
        panePainter.setSelectedIndex(3);
        int n3 = rectangle2.height - n2 - this.getHeightCompensate(direction);
        int n4 = rectangle2.width - n2 - this.getWidthCompensate(direction);
        int n5 = n3 / 2;
        int n6 = n4 / 2 + n4 % 2;
        int n7 = n3 / 2 + n3 % 2;
        int n8 = n4 / 2;
        return new Insets(n5, n6, n7, n8);
    }

    public void setHoveredTab(Tab tab) {
        if (this.enabled && tab != this.hoveredTab) {
            if (this.hoveredTab != null && this.hoveredTab.getTabbedPanel() != null) {
                this.findDraggableComponentBox(this.hoveredTab).getParent().repaint();
            }
            this.hoveredTab = tab;
            if (this.hoveredTab != null && this.hoveredTab.getTabbedPanel() != null) {
                this.findDraggableComponentBox(this.hoveredTab).getParent().repaint();
            }
        }
    }

    public void paintTabArea(TabbedPanel tabbedPanel, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.enabled && tabbedPanel.isTabAreaVisible()) {
            this.tabData.initialize(tabbedPanel);
            PanePainter panePainter = this.paneHandler.getPainter(this.tabData.getAreaOrientation());
            this.initTabLocations(panePainter);
            Insets insets = this.getTabAreaInsets(this.tabData.getAreaOrientation());
            if (tabbedPanel.getTabCount() > 0) {
                if (this.tabData.getAreaOrientation() == Direction.DOWN) {
                    n2 += this.tabData.getTabbedPanelHeight() - n4;
                } else if (this.tabData.getAreaOrientation() == Direction.RIGHT) {
                    n += this.tabData.getTabbedPanelWidth() - n3;
                }
                n3 = n < 0 ? n3 + n : n3;
                n4 = n2 < 0 ? n4 + n2 : n4;
                n = Math.max(0, n);
                n2 = Math.max(0, n2);
                if (this.tabData.isHorizontalLayout()) {
                    panePainter.setSize(this.tabData.getTabbedPanelSize().width, this.getTabbedPanelExtraSize());
                } else {
                    panePainter.setSize(this.getTabbedPanelExtraSize(), this.tabData.getTabbedPanelHeight());
                }
                if (panePainter.getTabCount() != 0 || this.tabData.getTabCount() <= 0) {
                    Shape shape = graphics.getClip();
                    int n5 = -n - (this.tabData.getAreaOrientation() == Direction.RIGHT ? -this.tabData.getTabbedPanelWidth() + this.getTabbedPanelExtraSize() : 0);
                    int n6 = -n2 - (this.tabData.getAreaOrientation() == Direction.DOWN ? -this.tabData.getTabbedPanelHeight() + this.getTabbedPanelExtraSize() : 0);
                    Rectangle rectangle = (Rectangle)this.tabData.getVisibleTabRects().get(0);
                    Rectangle rectangle2 = (Rectangle)this.tabData.getVisibleTabRects().get(this.tabData.getTabCount() - 1);
                    Tab tab = (Tab)this.tabData.getTabList().get(this.tabData.getTabCount() - 1);
                    if (this.tabData.isHorizontalLayout()) {
                        int n7 = tab.getWidth() == rectangle2.width ? 0 : 2 * this.tabData.getTabbedPanelSize().width - this.tabData.getTabAreaWidth();
                        panePainter.setSize(panePainter.getWidth() + n7, panePainter.getHeight());
                        panePainter.doValidation();
                        graphics.clipRect(0, 0, insets.left + (rectangle.width > 0 && rectangle.x == 0 ? 1 : 0), n4);
                        panePainter.paint(graphics, n5, n6);
                        graphics.setClip(shape);
                        int n8 = n7 == 0 ? 1 : 0;
                        graphics.clipRect(insets.left + this.tabData.getTabAreaWidth() - n8, 0, n3 - insets.left - this.tabData.getTabAreaWidth() + n8, n4);
                        panePainter.paint(graphics, n5 -= n7, n6);
                        graphics.setClip(shape);
                    } else {
                        int n9 = tab.getHeight() == rectangle2.height ? 0 : 2 * this.tabData.getTabbedPanelSize().height - this.tabData.getTabAreaHeight();
                        panePainter.setSize(panePainter.getWidth(), panePainter.getHeight() + n9);
                        panePainter.doValidation();
                        graphics.clipRect(0, 0, n3, insets.top + (rectangle.height > 0 && rectangle.y == 0 ? 1 : 0));
                        panePainter.paint(graphics, n5, n6);
                        graphics.setClip(shape);
                        int n10 = n9 == 0 ? 1 : 0;
                        graphics.clipRect(0, insets.top + this.tabData.getTabAreaHeight() - n10, n3, n4 - insets.top - this.tabData.getTabAreaHeight() + n10);
                        panePainter.paint(graphics, n5, n6 -= n9);
                        graphics.setClip(shape);
                    }
                }
                this.paintTabs(panePainter, this.tabData, graphics, n, n2, n3, n4, true);
                this.tabData.reset();
                this.reset(panePainter);
            }
        }
    }

    private void paintTabs(PanePainter panePainter, TabData tabData, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (this.enabled) {
            int n5;
            int n6;
            Tab tab = (Tab)tabData.getTabList().get(tabData.getTabList().size() - 1);
            Rectangle rectangle = (Rectangle)tabData.getVisibleTabRects().get(tabData.getTabCount() - 1);
            this.initPaintableTabLocations(panePainter);
            Insets insets = this.getTabAreaInsets(tabData.getAreaOrientation());
            Point point = this.getLocationInTabbedPanel(tab, tabData.getTabbedPanel());
            if (tabData.isHorizontalLayout()) {
                n6 = insets.left + insets.right + Math.max(0, tabData.getTabAreaWidth() - point.x - rectangle.width) + 2;
                for (n5 = 0; n5 < tabData.getTabList().size(); ++n5) {
                    n6 += ((Tab)tabData.getTabList().get(n5)).getWidth();
                }
                panePainter.setSize(n6, this.getTabbedPanelExtraSize());
            } else {
                n6 = insets.top + insets.bottom + Math.max(0, tabData.getTabAreaHeight() - point.y - rectangle.height) + 2;
                for (n5 = 0; n5 < tabData.getTabList().size(); ++n5) {
                    n6 += ((Tab)tabData.getTabList().get(n5)).getHeight();
                }
                panePainter.setSize(this.getTabbedPanelExtraSize(), n6);
            }
            panePainter.doValidation();
            n6 = tabData.getPreTab() == null ? 0 : (tabData.getTabCount() > 1 ? 1 : 0);
            Shape shape = graphics.getClip();
            int n7 = -n - (tabData.getAreaOrientation() == Direction.RIGHT ? -tabData.getTabbedPanelWidth() + this.getTabbedPanelExtraSize() : 0);
            int n8 = -n2 - (tabData.getAreaOrientation() == Direction.DOWN ? -tabData.getTabbedPanelHeight() + this.getTabbedPanelExtraSize() : 0);
            Rectangle rectangle2 = (Rectangle)tabData.getVisibleTabRects().get(n6);
            Tab tab2 = (Tab)tabData.getTabList().get(n6);
            if (tabData.isHorizontalLayout()) {
                n7 -= tabData.getPreTab() != null ? tab2.getX() - tabData.getPreTab().getX() + rectangle2.x : rectangle2.x;
                graphics.clipRect(insets.left, 0, tabData.getTabAreaWidth(), n4);
            } else {
                n8 -= tabData.getPreTab() != null ? tab2.getY() - tabData.getPreTab().getY() + rectangle2.y : rectangle2.y;
                graphics.clipRect(0, insets.top, n3, tabData.getTabAreaHeight());
            }
            this.applyFocusAndHover(panePainter, true);
            panePainter.paint(graphics, n7, n8);
            this.applyFocusAndHover(panePainter, false);
            graphics.setClip(shape);
        }
    }

    private int getTabbedPanelExtraSize() {
        Insets insets = this.getContentInsets(this.tabData.getAreaOrientation(), this.tabData.getTabbedPanel().isTabAreaVisible());
        if (this.tabData.isHorizontalLayout()) {
            return this.tabData.getTabAreaHeight() + insets.top + insets.bottom + 2;
        }
        return this.tabData.getTabAreaWidth() + insets.left + insets.right + 2;
    }

    public void paintContentArea(TabbedPanelContentPanel tabbedPanelContentPanel, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.enabled) {
            this.tabData.initialize(tabbedPanelContentPanel.getTabbedPanel());
            PanePainter panePainter = this.paneHandler.getPainter(this.tabData.getAreaOrientation());
            this.initTabLocations(panePainter);
            int n5 = 0;
            int n6 = 0;
            if (this.tabData.getTabbedPanel().hasContentArea()) {
                Point point = this.getLocationInTabbedPanel(tabbedPanelContentPanel, this.tabData.getTabbedPanel());
                int n7 = 0;
                int n8 = 0;
                if (panePainter.getTabCount() == 0 && this.tabData.getTabCount() > 0) {
                    if (this.tabData.getAreaOrientation() == Direction.UP) {
                        n7 = this.tabData.getTabAreaHeight();
                    } else if (this.tabData.getAreaOrientation() == Direction.DOWN) {
                        n7 = -this.tabData.getTabAreaHeight();
                    } else {
                        n8 = this.tabData.getAreaOrientation() == Direction.LEFT ? this.tabData.getTabAreaWidth() : -this.tabData.getTabAreaWidth();
                    }
                }
                n5 = -point.x + (n8 > 0 ? n8 : 0);
                n6 = -point.y + (n7 > 0 ? n7 : 0);
                int n9 = 0;
                int n10 = 0;
                if (this.tabAreaNotVisibleFix && !this.tabData.getTabbedPanel().isTabAreaVisible()) {
                    int n11 = !this.tabData.isHorizontalLayout() ? this.tabMinimumSizes[this.getDirectionIndex((Direction)this.tabData.getAreaOrientation())].width - this.raiseds[this.getDirectionIndex(this.tabData.getAreaOrientation())] + (this.tabData.getAreaOrientation() == Direction.LEFT ? this.areaInsets[this.getDirectionIndex((Direction)Direction.LEFT)].left : this.areaInsets[this.getDirectionIndex((Direction)Direction.RIGHT)].right) : (n9 = 0);
                    n10 = this.tabData.isHorizontalLayout() ? this.tabMinimumSizes[this.getDirectionIndex((Direction)this.tabData.getAreaOrientation())].height - this.raiseds[this.getDirectionIndex(this.tabData.getAreaOrientation())] + (this.tabData.getAreaOrientation() == Direction.UP ? this.areaInsets[this.getDirectionIndex((Direction)Direction.UP)].top : this.areaInsets[this.getDirectionIndex((Direction)Direction.DOWN)].bottom) : 0;
                }
                n5 -= this.tabData.getAreaOrientation() == Direction.LEFT ? n9 : 0;
                n6 -= this.tabData.getAreaOrientation() == Direction.UP ? n10 : 0;
                panePainter.setSize(this.tabData.getTabbedPanelSize().width - Math.abs(n8) + n9, this.tabData.getTabbedPanelSize().height - Math.abs(n7) + n10);
                panePainter.doValidation();
            } else {
                if (this.tabData.isHorizontalLayout()) {
                    panePainter.setSize(tabbedPanelContentPanel.getWidth(), tabbedPanelContentPanel.getHeight() + this.tabData.getTabAreaHeight());
                } else {
                    panePainter.setSize(tabbedPanelContentPanel.getWidth() + this.tabData.getTabAreaWidth(), tabbedPanelContentPanel.getHeight());
                }
                panePainter.doValidation();
                if (this.tabData.getAreaOrientation() == Direction.UP) {
                    n6 -= this.tabData.getTabAreaHeight();
                } else if (this.tabData.getAreaOrientation() == Direction.LEFT) {
                    n5 -= this.tabData.getTabAreaWidth();
                }
            }
            panePainter.paint(graphics, n5, n6);
            this.tabData.reset();
            this.reset(panePainter);
        }
    }

    private Component getComponent() {
        return componentCache.getComponent();
    }

    private void reset(PanePainter panePainter) {
        panePainter.removeAllTabs();
        componentCache.reset();
    }

    private Point getLocationInTabbedPanel(Component component, TabbedPanel tabbedPanel) {
        Point point = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), tabbedPanel);
        Insets insets = tabbedPanel.getInsets();
        point.x -= insets.left;
        point.y -= insets.top;
        return point;
    }

    private void initPaintableTabLocations(PanePainter panePainter) {
        this.reset(panePainter);
        if (this.tabData.getPreTab() != null) {
            this.tabData.getTabList().add(0, this.tabData.getPreTab());
            this.tabData.getVisibleTabRects().add(0, new Rectangle(0, 0, 0, 0));
        }
        if (this.tabData.getPostTab() != null) {
            this.tabData.getTabList().add(this.tabData.getPostTab());
            this.tabData.getVisibleTabRects().add(new Rectangle(0, 0, 0, 0));
        }
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < this.tabData.getTabCount(); ++i) {
            Tab tab = (Tab)this.tabData.getTabList().get(i);
            SizeIcon sizeIcon = new SizeIcon(this.getInternalTabWidth(tab) - this.getWidthCompensate(this.tabData.getAreaOrientation()), this.getInternalTabHeight(tab) - this.getHeightCompensate(this.tabData.getAreaOrientation()), this.isSwapWidthHeight(this.tabData.getAreaOrientation()));
            panePainter.addTab(EMPTY_STRING, sizeIcon, this.getComponent());
            if (tab.isHighlighted()) {
                n2 = panePainter.getTabCount() - 1;
            }
            if (!tab.isEnabled()) {
                panePainter.setEnabledAt(i, false);
                panePainter.setDisabledIconAt(i, sizeIcon);
            }
            n += this.tabData.isHorizontalLayout() ? tab.getWidth() : tab.getHeight();
        }
        panePainter.setSelectedIndex(n2);
        panePainter.doValidation();
    }

    private void applyFocusAndHover(PanePainter panePainter, boolean bl) {
        if (bl) {
            Tab tab;
            int n;
            for (n = 0; n < this.tabData.getTabCount(); ++n) {
                tab = (Tab)this.tabData.getTabList().get(n);
                if (tab.getFocusableComponent() == null || !tab.getFocusableComponent().hasFocus()) continue;
                panePainter.setMouseEntered(true);
                panePainter.setFocusActive(true);
                break;
            }
            if (this.hoveredTab != null) {
                for (n = 0; n < this.tabData.getTabCount(); ++n) {
                    tab = (Tab)this.tabData.getTabList().get(n);
                    if (tab != this.hoveredTab) continue;
                    panePainter.setMouseEntered(true);
                    panePainter.setHoveredTab(n);
                    break;
                }
            }
        } else {
            panePainter.setFocusActive(false);
            panePainter.setMouseEntered(false);
        }
    }

    private int getInternalTabWidth(Tab tab) {
        Direction direction = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
        Insets insets = tab.isHighlighted() ? this.getSelectedInsets(direction) : this.getNormalInsets(direction);
        int n = tab.getWidth();
        n -= insets.left + insets.right;
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            n -= this.getSelectedRaised(direction);
        }
        return n;
    }

    private int getInternalTabHeight(Tab tab) {
        Direction direction = tab.getTabbedPanel().getProperties().getTabAreaOrientation();
        Insets insets = tab.isHighlighted() ? this.getSelectedInsets(direction) : this.getNormalInsets(direction);
        int n = tab.getHeight();
        n -= insets.top + insets.bottom;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            n -= this.getSelectedRaised(direction);
        }
        return n;
    }

    private void initTabLocations(PanePainter panePainter) {
        this.findPaintableTabs();
        Dimension dimension = this.getTabExternalMinSize(this.tabData.getAreaOrientation());
        Insets insets = this.getTabAreaInsets(this.tabData.getAreaOrientation());
        int n = -1;
        if (this.tabData.getTabbedPanel().isTabAreaVisible()) {
            for (int i = 0; i < this.tabData.getTabCount(); ++i) {
                Tab tab = (Tab)this.tabData.getTabList().get(i);
                Rectangle rectangle = (Rectangle)this.tabData.getVisibleTabRects().get(i);
                Insets insets2 = this.getTabInsets(this.tabData.getAreaOrientation());
                int n2 = Math.max(-insets2.left - insets2.right, this.getInternalTabWidth(tab) - (tab.getWidth() - rectangle.width));
                int n3 = Math.max(-insets2.top - insets2.bottom, this.getInternalTabHeight(tab) - (tab.getHeight() - rectangle.height));
                Point point = this.getLocationInTabbedPanel(tab, this.tabData.getTabbedPanel());
                if ((!this.tabData.isHorizontalLayout() || rectangle.width < dimension.width && dimension.width >= this.tabData.getTabbedPanelWidth() - point.x - insets.right) && (this.tabData.isHorizontalLayout() || rectangle.height < dimension.height && dimension.height >= this.tabData.getTabbedPanelHeight() - point.y - insets.bottom)) continue;
                int n4 = n2;
                int n5 = n3;
                SizeIcon sizeIcon = new SizeIcon(n4 - this.getWidthCompensate(this.tabData.getAreaOrientation()), n5 - this.getHeightCompensate(this.tabData.getAreaOrientation()), this.isSwapWidthHeight(this.tabData.getAreaOrientation()));
                panePainter.addTab(EMPTY_STRING, sizeIcon, this.getComponent());
                if (i == this.tabData.getSelectedTabPainterIndex()) {
                    n = i;
                }
                if (tab.isEnabled()) continue;
                panePainter.setEnabledAt(i, false);
                panePainter.setDisabledIconAt(i, sizeIcon);
            }
        } else if (this.tabAreaNotVisibleFix) {
            panePainter.addTab(EMPTY_STRING, componentCache.getComponent());
        }
        if (panePainter.getTabCount() > 0) {
            panePainter.setSelectedIndex(n);
        }
        panePainter.doValidation();
    }

    private void findPaintableTabs() {
        Component component = null;
        Rectangle rectangle = null;
        Component component2 = null;
        int n = 0;
        boolean bl = false;
        if (this.tabData.getTabbedPanel().isTabAreaVisible()) {
            Component component3;
            while (n < this.tabData.getTabbedPanel().getTabCount()) {
                component3 = this.tabData.getTabbedPanel().getTabAt(n);
                Rectangle rectangle2 = ((JComponent)component3).getVisibleRect();
                if (n == 0) {
                    component = component3;
                    rectangle = rectangle2;
                }
                ++n;
                if (rectangle2.width > 0 && rectangle2.height > 0) {
                    bl = true;
                    this.tabData.getTabList().add(component3);
                    this.tabData.getVisibleTabRects().add(rectangle2);
                    if (this.tabData.getTabCount() == 1) {
                        this.tabData.setPreTab((Tab)component2);
                    }
                    if (((Tab)component3).isHighlighted()) {
                        this.tabData.setSelectedTabPainterIndex(this.tabData.getTabCount() - 1);
                    }
                } else if (this.tabData.getTabList().size() > 0 && (rectangle2.width == 0 || rectangle2.height == 0)) {
                    this.tabData.setPostTab((Tab)component3);
                }
                if (bl && rectangle2.x == 0 && rectangle2.y == 0 && (this.tabData.isHorizontalLayout() && rectangle2.width < ((JComponent)component3).getWidth() || !this.tabData.isHorizontalLayout() && rectangle2.height < ((JComponent)component3).getHeight())) break;
                component2 = component3;
            }
            if (component != null) {
                component3 = this.findDraggableComponentBox(component);
                if (component3 != null) {
                    if (this.tabData.isHorizontalLayout()) {
                        this.tabData.setTabAreaWidth(component3.getWidth());
                        this.tabData.setTabAreaHeight(component3.getParent().getHeight());
                    } else {
                        this.tabData.setTabAreaWidth(component3.getParent().getWidth());
                        this.tabData.setTabAreaHeight(component3.getHeight());
                    }
                }
                if (this.tabData.getTabCount() == 0) {
                    this.tabData.getTabList().add(component);
                    this.tabData.getVisibleTabRects().add(rectangle);
                }
            }
        }
    }

    private Component findDraggableComponentBox(Component component) {
        if (component == null || component instanceof DraggableComponentBox) {
            return component;
        }
        return this.findDraggableComponentBox(component.getParent());
    }
}

