/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.PlotComponent;
import edu.mit.lcp.Trace;
import edu.mit.lcp.yScaleComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlotPanel
extends JPanel {
    public boolean multipleYScales = false;
    public JCheckBox multipleYScalesCheckBox;
    public yScaleComponent yScale;
    ChangeListener sourceDataChanged;
    private ItemListener MultipleYScalesListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            if (((JCheckBox)itemEvent.getSource()).isSelected()) {
                PlotPanel.this.setMultipleYScales(true);
            } else {
                PlotPanel.this.setMultipleYScales(false);
            }
        }
    };

    PlotPanel() {
        this.setLayout(null);
        this.multipleYScalesCheckBox = new JCheckBox("Multiple Y Scales");
        this.multipleYScalesCheckBox.addItemListener(this.MultipleYScalesListener);
    }

    public boolean getMultipleYScales() {
        return this.multipleYScales;
    }

    public abstract void setMultipleYScales(boolean var1);

    public abstract PlotComponent getPlot();

    public Point2D getScaledPoint(AffineTransform affineTransform, Point2D point2D) throws NoninvertibleTransformException {
        AffineTransform affineTransform2 = affineTransform.createInverse();
        Point2D point2D2 = affineTransform2.transform(point2D, null);
        return point2D2;
    }

    public abstract void removeTrace(Trace<?, ?> var1);

    public abstract void removeAllTraces();

    public abstract void addTrace(Trace<?, ?> var1);
}

