/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CSimulation;
import edu.mit.lcp.CSimulation21C;
import edu.mit.lcp.CSimulation6C;
import edu.mit.lcp.SimulationThread;
import edu.mit.lcp.VersionNumber;
import edu.mit.lcp.gui;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CVSim {
    public static final VersionNumber versionNumber = new VersionNumber(1, 7);
    public static final String MODEL_21C = "21 Compartment";
    public static final String MODEL_6C = "6 Compartment";
    public static SimulationThread simThread;
    public static CSimulation sim;
    public static gui gui;
    public static String simulationModelName;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var4_8;
        boolean bl = false;
        System.out.println("CVSim.main(...)");
        simulationModelName = MODEL_6C;
        String[] objectArray = stringArray;
        int n = objectArray.length;
        boolean bl2 = false;
        while (var4_8 < n) {
            String string = objectArray[var4_8];
            if (string.equals("-m6")) {
                simulationModelName = MODEL_6C;
            }
            if (string.equals("-m21")) {
                simulationModelName = MODEL_21C;
            }
            if (string.equals("-speed")) {
                bl = true;
            }
            ++var4_8;
        }
        if (simulationModelName == null) {
            Object[] objectArray2 = new Object[]{MODEL_6C, MODEL_21C};
            simulationModelName = (String)JOptionPane.showInputDialog(null, "Please select a simulation model:", "Select Model", -1, null, objectArray2, MODEL_6C);
        }
        if (simulationModelName != null) {
            if (simulationModelName.equals(MODEL_6C)) {
                sim = new CSimulation6C();
            } else if (simulationModelName.equals(MODEL_21C)) {
                sim = new CSimulation21C();
            } else {
                System.exit(1);
            }
        } else {
            System.exit(1);
        }
        if (bl) {
            int[] nArray = new int[]{1, 1, 5, 10, 20, 50, 100, 1000};
            n = 500;
            System.out.println("Testing " + simulationModelName + " Model backend speed.");
            System.out.print("Simulating " + n + " seconds using DataCompressionFactors: ");
            for (int n2 : nArray) {
                System.out.print(n2 + " ");
            }
            System.out.print("\n");
            for (int n2 : nArray) {
                sim.setDataCompressionFactor(n2);
                long l = System.currentTimeMillis();
                for (int i = 0; i < n * 1000 / n2; ++i) {
                    sim.step();
                }
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                System.out.println("Wall Clock Time Elapsed: " + (double)l3 / 1000.0 + "sec -- (" + (double)n / ((double)l3 / 1000.0) + "x realtime)");
                sim.reset();
            }
        } else {
            simThread = new SimulationThread(sim);
            gui = new gui();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    gui.createAndShowGUI();
                }
            });
        }
    }
}

