/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.RootWindow;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.internalutil.DropAction;

class WindowDragger
implements DockingWindowDragger {
    private DockingWindow dragWindow;
    private DropAction dropAction;
    private RootWindow rootWindow;

    WindowDragger(DockingWindow dockingWindow) {
        this(dockingWindow, dockingWindow.getRootWindow());
    }

    WindowDragger(DockingWindow dockingWindow, RootWindow rootWindow) {
        this.dragWindow = dockingWindow;
        this.rootWindow = rootWindow;
        rootWindow.internalStartDrag(dockingWindow);
    }

    public DockingWindow getDragWindow() {
        return this.dragWindow;
    }

    public RootWindow getDropTarget() {
        return this.rootWindow;
    }

    void undoDrag(DropAction dropAction) {
        if (this.dropAction != null) {
            this.dropAction.clear(this.dragWindow, dropAction);
            this.dropAction = null;
        }
    }

    private void stopDrag() {
        this.rootWindow.stopDrag();
    }

    public void abortDrag() {
        this.stopDrag();
        this.undoDrag(null);
    }

    public void dropWindow(MouseEvent mouseEvent) {
        this.stopDrag();
        if (this.dropAction == null) {
            this.dropAction = this.dragWindow.getDefaultDropAction();
        }
        if (this.dragWindow != null && this.dropAction != null) {
            this.dropAction.execute(this.dragWindow, mouseEvent);
            Container container = this.dragWindow.getTopLevelAncestor();
            if (container != null && container instanceof Window) {
                ((Window)container).toFront();
            }
            FocusManager.focusWindow(this.dragWindow);
        }
    }

    public void dragWindow(MouseEvent mouseEvent) {
        JRootPane jRootPane = this.rootWindow.getCurrentDragRootPane();
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), jRootPane);
        if (jRootPane != this.rootWindow.getRootPane() && !jRootPane.contains(point)) {
            this.rootWindow.setCurrentDragRootPane(null);
            jRootPane = this.rootWindow.getCurrentDragRootPane();
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), jRootPane);
        }
        if (jRootPane != this.rootWindow.getRootPane() || !this.rootWindow.floatingWindowsContainPoint(point)) {
            Object object;
            DockingWindow dockingWindow;
            for (dockingWindow = this.getDeepestWindowAt(jRootPane, point.x, point.y); dockingWindow != null && dockingWindow.getWindowParent() != null && !(dockingWindow instanceof FloatingWindow); dockingWindow = dockingWindow.getWindowParent()) {
                object = SwingUtilities.convertPoint(jRootPane, point, dockingWindow.getWindowParent());
                if (!dockingWindow.getWindowParent().contains((Point)object)) break;
            }
            object = dockingWindow != null ? dockingWindow.acceptDrop(SwingUtilities.convertPoint(jRootPane, point, dockingWindow), this.dragWindow) : null;
            this.undoDrag((DropAction)object);
            Cursor cursor = DragSource.DefaultMoveDrop;
            if (object == null) {
                cursor = DragSource.DefaultMoveNoDrop;
            }
            if (dockingWindow == null && this.dragWindow.getWindowProperties().getUndockOnDropEnabled()) {
                cursor = DragSource.DefaultMoveDrop;
            }
            this.rootWindow.setDragCursor(cursor);
            this.rootWindow.setDragText(object == null || ((DropAction)object).showTitle() ? point : null, this.dragWindow.getTitle());
            this.dropAction = object;
        } else {
            this.undoDrag(null);
            this.rootWindow.setDragText(null, null);
        }
        if (this.dropAction == null) {
            this.rootWindow.setDragRectangle(null);
        }
    }

    private DockingWindow getDeepestWindowAt(Component component, int n, int n2) {
        Object object;
        if (component == null || !component.isVisible() || !component.contains(n, n2)) {
            return null;
        }
        if (component instanceof Container) {
            object = ((Container)component).getComponents();
            for (int i = 0; i < ((Object)object).length; ++i) {
                DockingWindow dockingWindow = this.getDeepestWindowAt((Component)object[i], n - ((Component)object[i]).getX(), n2 - ((Component)object[i]).getY());
                if (dockingWindow == null) continue;
                return dockingWindow;
            }
        }
        if (component instanceof DockingWindow) {
            object = (DockingWindow)component;
            return ((DockingWindow)object).getRootWindow() == this.rootWindow ? object : null;
        }
        return null;
    }
}

