/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.PlotComponent;
import edu.mit.lcp.PlotPanelXYChart;
import edu.mit.lcp.Range;
import edu.mit.lcp.Trace;
import edu.mit.lcp.TraceListModel;
import edu.mit.lcp.yScaleComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class xScaleComponent
extends JComponent {
    private TraceListModel traceList;
    private List<Scale> _scaleList;
    private int _padding;
    private int _numTicks;
    private PlotPanelXYChart _plotPanel;
    private PlotComponent _plot;
    private yScaleComponent _yScale;
    private double min = 0.0;
    private double max = 0.0;
    public PropertyChangeSupport _changes = new PropertyChangeSupport(this);
    private int width = 600;
    private int height = 50;
    public static final String PROP_MULTISCALES = "MULTISCALES";

    public xScaleComponent(TraceListModel traceListModel, int n, int n2, PlotPanelXYChart plotPanelXYChart) {
        this._scaleList = new ArrayList<Scale>();
        this.traceList = traceListModel;
        this._padding = n;
        this._numTicks = n2;
        this._plotPanel = plotPanelXYChart;
        this._plot = plotPanelXYChart.getPlot();
        this._yScale = plotPanelXYChart.getYScale();
        this.setLayout(new BoxLayout(this, 1));
        this.traceList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                Object object = xScaleComponent.this.traceList.getElementAt(listDataEvent.getIndex0());
                double d = ((Number)((Trace)object).getXRange().lower).doubleValue();
                double d2 = ((Number)((Trace)object).getXRange().upper).doubleValue();
                if (d < xScaleComponent.this.min) {
                    xScaleComponent.this.min = d;
                }
                if (d2 > xScaleComponent.this.max) {
                    xScaleComponent.this.max = d2;
                }
                if (xScaleComponent.this._plotPanel.getMultipleXScales() || xScaleComponent.this._scaleList.size() == 0) {
                    Scale scale = new Scale((Trace)object);
                    xScaleComponent.this._scaleList.add(scale);
                    xScaleComponent.this.add(scale);
                } else {
                    for (Trace trace : xScaleComponent.this.traceList) {
                        trace.setXRange(new Range<Double>(xScaleComponent.this.min, xScaleComponent.this.max));
                    }
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (xScaleComponent.this._plotPanel.getMultipleXScales() || !xScaleComponent.this._plotPanel.getMultipleXScales() && xScaleComponent.this.traceList.size() == 0) {
                    Scale scale = (Scale)xScaleComponent.this._scaleList.get(listDataEvent.getIndex0());
                    xScaleComponent.this._scaleList.remove(scale);
                    xScaleComponent.this.remove(scale);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.addPropertyChangeListener(PROP_MULTISCALES, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    Scale scale = (Scale)xScaleComponent.this._scaleList.get(0);
                    scale.setVisible(false);
                    xScaleComponent.this._scaleList.remove(scale);
                    for (Trace trace : xScaleComponent.this.traceList) {
                        Scale scale2 = new Scale(trace);
                        xScaleComponent.this._scaleList.add(scale2);
                        xScaleComponent.this.add(scale2);
                        scale2.repaint();
                    }
                } else {
                    Scale scale = (Scale)xScaleComponent.this._scaleList.get(0);
                    while (xScaleComponent.this._scaleList.size() > 1) {
                        Scale scale3 = (Scale)xScaleComponent.this._scaleList.get(xScaleComponent.this._scaleList.size() - 1);
                        double d = ((Number)scale3.getRange().lower).doubleValue();
                        double d2 = ((Number)scale3.getRange().upper).doubleValue();
                        if (d < xScaleComponent.this.min) {
                            xScaleComponent.this.min = d;
                        }
                        if (d2 > xScaleComponent.this.max) {
                            xScaleComponent.this.max = d2;
                        }
                        scale.setRange(new Range<Double>(xScaleComponent.this.min, xScaleComponent.this.max));
                        scale3.setVisible(false);
                        xScaleComponent.this._scaleList.remove(scale3);
                    }
                    scale.setColor(Color.BLACK);
                    for (Trace trace : xScaleComponent.this.traceList) {
                        trace.setXRange(new Range<Double>(xScaleComponent.this.min, xScaleComponent.this.max));
                    }
                }
            }
        });
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = this.width;
        Insets insets = this.getInsets();
        for (Scale scale : this._scaleList) {
            n += scale.getPreferredSize().height;
        }
        return new Dimension(n2, n += insets.bottom);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._changes.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changes.removePropertyChangeListener(propertyChangeListener);
    }

    private class Scale
    extends JComponent {
        private Trace trace;
        private Color color;
        private List<JFormattedTextField> textfields;
        private JFormattedTextField minField;
        private JFormattedTextField maxField;
        private int maxScaleLabelWidth;
        private int maxScaleLabelHeight;
        private Rectangle _bounds;
        private double scaleMin;
        private double scaleMax;
        private NumberFormat doubleFormat = NumberFormat.getNumberInstance();
        private Font rangeFont = new Font("Serif", 0, 10);
        public static final String VALUE = "value";
        private int width = 600;
        private int height = 10;

        public Scale(Trace trace) {
            this.trace = trace;
            this.textfields = new ArrayList<JFormattedTextField>();
            this.color = xScaleComponent.this._plotPanel.getMultipleXScales() ? this.trace.getColor() : Color.BLACK;
            this.scaleMin = ((Number)this.trace.getXRange().lower).doubleValue();
            this.scaleMax = ((Number)this.trace.getXRange().upper).doubleValue();
            this.setRange(this.scaleMin, this.scaleMax);
            this.minField = new JFormattedTextField(this.doubleFormat);
            this.minField.setValue(this.scaleMin);
            this.minField.setColumns(3);
            this.minField.setFont(this.rangeFont);
            this.minField.setForeground(this.color);
            this.minField.setHorizontalAlignment(4);
            this.add(this.minField);
            this.textfields.add(this.minField);
            double d = this.scaleMax - this.scaleMin;
            double d2 = d / (double)xScaleComponent.this._numTicks;
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            for (int i = 1; i < xScaleComponent.this._numTicks; ++i) {
                JFormattedTextField jFormattedTextField = new JFormattedTextField();
                jFormattedTextField.setFont(this.rangeFont);
                jFormattedTextField.setForeground(this.color);
                jFormattedTextField.setHorizontalAlignment(4);
                jFormattedTextField.setValue(this.scaleMin + d2 * (double)i);
                jFormattedTextField.setColumns(3);
                jFormattedTextField.setEditable(false);
                jFormattedTextField.setBorder(border);
                this.add(jFormattedTextField);
                this.textfields.add(jFormattedTextField);
            }
            this.maxField = new JFormattedTextField(this.doubleFormat);
            this.maxField.setValue(this.scaleMax);
            this.maxField.setColumns(3);
            this.maxField.setFont(this.rangeFont);
            this.maxField.setForeground(this.color);
            this.maxField.setHorizontalAlignment(4);
            this.add(this.maxField);
            this.textfields.add(this.maxField);
            this.minField.addPropertyChangeListener(VALUE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.scaleMin = ((Number)Scale.this.minField.getValue()).doubleValue();
                    xScaleComponent.this.min = Scale.this.scaleMin;
                    for (Object object : xScaleComponent.this._scaleList) {
                        if (!(((Number)((Scale)object).getRange().lower).doubleValue() < Scale.this.scaleMin)) continue;
                        xScaleComponent.this.min = ((Number)((Scale)object).getRange().lower).doubleValue();
                    }
                    if (xScaleComponent.this._plotPanel.getMultipleXScales()) {
                        Scale.this.trace.setXRange(new Range<Double>(Scale.this.scaleMin, Scale.this.scaleMax));
                    } else {
                        for (Object object : xScaleComponent.this.traceList) {
                            ((Trace)object).setXRange(new Range<Double>(Scale.this.scaleMin, ((Number)((Trace)object).getXRange().upper).doubleValue()));
                        }
                    }
                    Scale.this.updateComponent();
                }
            });
            this.maxField.addPropertyChangeListener(VALUE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.scaleMax = ((Number)Scale.this.maxField.getValue()).doubleValue();
                    xScaleComponent.this.max = Scale.this.scaleMax;
                    for (Object object : xScaleComponent.this._scaleList) {
                        if (!(((Number)((Scale)object).getRange().upper).doubleValue() > Scale.this.scaleMax)) continue;
                        xScaleComponent.this.max = ((Number)((Scale)object).getRange().upper).doubleValue();
                    }
                    if (xScaleComponent.this._plotPanel.getMultipleXScales()) {
                        Scale.this.trace.setXRange(new Range<Double>(Scale.this.scaleMin, Scale.this.scaleMax));
                    } else {
                        for (Object object : xScaleComponent.this.traceList) {
                            ((Trace)object).setXRange(new Range<Double>(((Number)((Trace)object).getXRange().lower).doubleValue(), Scale.this.scaleMax));
                        }
                    }
                    Scale.this.updateComponent();
                }
            });
            this.trace.addPropertyChangeListener("XRANGE", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Range range = (Range)propertyChangeEvent.getNewValue();
                    Scale.this.setRange(range);
                    Scale.this.scaleMin = ((Number)range.lower).doubleValue();
                    Scale.this.scaleMax = ((Number)range.upper).doubleValue();
                    if (Scale.this.scaleMin < xScaleComponent.this.min) {
                        xScaleComponent.this.min = Scale.this.scaleMin;
                    }
                    if (Scale.this.scaleMax > xScaleComponent.this.max) {
                        xScaleComponent.this.max = Scale.this.scaleMax;
                    }
                    Scale.this.updateComponent();
                }
            });
            this.trace.addPropertyChangeListener("COLOR", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.color = (Color)propertyChangeEvent.getNewValue();
                    for (int i = 0; i < xScaleComponent.this._numTicks + 1; ++i) {
                        JFormattedTextField jFormattedTextField = (JFormattedTextField)Scale.this.textfields.get(i);
                        jFormattedTextField.setForeground(Scale.this.color);
                    }
                    Scale.this.repaint();
                }
            });
            this.trace.addPropertyChangeListener("ENABLED", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Scale.this.setVisible((Boolean)propertyChangeEvent.getNewValue());
                    Scale.this.updateComponent();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    Scale.this.updateComponent();
                }
            });
            this.updateComponent();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.updateComponent();
        }

        public Dimension getMinimumSize() {
            JLabel jLabel = new JLabel();
            int n = 2;
            Dimension dimension = new Dimension(2 * jLabel.getPreferredSize().width, 0);
            if (this.isVisible()) {
                dimension.height = n + this.maxScaleLabelHeight + this.getInsets().top + this.getInsets().bottom;
            }
            return dimension;
        }

        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, this.getMinimumSize().height);
        }

        private void updateComponent() {
            this.updateBounds();
            this.updateLabels();
            this.positionScaleLabels();
        }

        private void updateMaxScaleLabelWidth() {
            int n = 0;
            int n2 = 0;
            for (JFormattedTextField jFormattedTextField : this.textfields) {
                n2 = jFormattedTextField.getPreferredSize().width;
                if (n2 <= n) continue;
                n = n2;
            }
            this.maxScaleLabelWidth = n;
        }

        private void updateMaxScaleLabelHeight() {
            int n = 0;
            int n2 = 0;
            for (JFormattedTextField jFormattedTextField : this.textfields) {
                n2 = jFormattedTextField.getPreferredSize().height;
                if (n2 <= n) continue;
                n = n2;
            }
            this.maxScaleLabelHeight = n;
        }

        private void updateLabels() {
            double d = this.scaleMax - this.scaleMin;
            double d2 = d / (double)xScaleComponent.this._numTicks;
            for (int i = 0; i < xScaleComponent.this._numTicks + 1; ++i) {
                JFormattedTextField jFormattedTextField = this.textfields.get(i);
                jFormattedTextField.setValue(this.scaleMin + d2 * (double)i);
            }
            this.updateMaxScaleLabelWidth();
            this.updateMaxScaleLabelHeight();
        }

        private void positionScaleLabels() {
            Insets insets = this.getInsets();
            double d = xScaleComponent.this._plot.getDeltaX();
            int n = 15;
            for (int i = 0; i < this.textfields.size(); ++i) {
                JFormattedTextField jFormattedTextField = this.textfields.get(i);
                Dimension dimension = jFormattedTextField.getPreferredSize();
                if (i == this.textfields.size() - 1) {
                    n += 10;
                }
                jFormattedTextField.setBounds(this._bounds.x + ((xScaleComponent)xScaleComponent.this)._yScale.getPreferredSize().width + (int)((double)i * d) - n, this._bounds.y, dimension.width, this.maxScaleLabelHeight);
            }
        }

        private void updateBounds() {
            Insets insets = this.getInsets();
            this._bounds = this.getBounds();
            this._bounds.x = insets.left;
            this._bounds.y = insets.top;
            this._bounds.width -= insets.left + insets.right + 1;
            this._bounds.height -= insets.top + insets.bottom + 1;
        }

        public void setRange(Range range) {
            this.setRange(((Number)range.lower).doubleValue(), ((Number)range.upper).doubleValue());
        }

        public void setRange(double d, double d2) {
            this.scaleMin = d;
            this.scaleMax = d2;
        }

        public Range getRange() {
            return new Range<Double>(this.scaleMin, this.scaleMax);
        }

        public void setColor(Color color) {
            this.color = color;
            this.minField.setForeground(this.color);
            this.maxField.setForeground(this.color);
            for (JFormattedTextField jFormattedTextField : this.textfields) {
                jFormattedTextField.setForeground(this.color);
            }
            this.repaint();
        }

        public void setScaleMin(double d) {
            this.scaleMin = d;
        }

        public void setScaleMax(double d) {
            this.scaleMax = d;
        }
    }
}

