/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.ControlToolBar;
import edu.mit.lcp.ImagePanel;
import edu.mit.lcp.OutputPanel;
import edu.mit.lcp.ParameterPanel;
import edu.mit.lcp.Patient;
import edu.mit.lcp.PlotPanel;
import edu.mit.lcp.PlotPanelStripChart;
import edu.mit.lcp.PlotPanelXYChart;
import edu.mit.lcp.PlotWindow;
import edu.mit.lcp.TraceListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewMap;

public class gui {
    static JFrame frame;
    public ParameterPanel parameterPanel;
    public OutputPanel outputPanel;
    public List<PlotWindow> plotWindows = new ArrayList<PlotWindow>();
    public List<View> stripChartViews = new ArrayList<View>();
    public List<View> XYPlotViews = new ArrayList<View>();
    private List<Patient> patientList;
    public ControlToolBar toolbar;
    ViewMap viewMap;
    TabWindow stripChartTabWindow;
    TabWindow XYPlotTabWindow;

    public gui() {
        frame = new JFrame("CVSim Version " + CVSim.versionNumber.toString() + " -- Model: " + CVSim.simulationModelName);
    }

    public void createAndShowGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 50;
        frame.setDefaultCloseOperation(3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width - n * 2, dimension.height - n * 2);
        frame.setBounds(n, n, dimension2.width, dimension2.height);
        frame.setSize(dimension2);
        frame.addWindowListener(new FrameSynchListener());
        this.viewMap = new ViewMap();
        PlotWindow plotWindow = new PlotWindow(new TraceListModel(), 2);
        View view = new View("Strip Chart 1", null, plotWindow);
        view.getWindowProperties().setCloseEnabled(false);
        view.addListener(new DockingWindowCleanupListener());
        this.stripChartViews.add(view);
        this.viewMap.addView(1, view);
        PlotPanelStripChart plotPanelStripChart = (PlotPanelStripChart)plotWindow.getPlot();
        CVSim.sim.addChangeListener(plotPanelStripChart.sourceDataChanged);
        plotPanelStripChart.createNewTrace(CVSim.sim.getOutputVariable("LVP"));
        PlotWindow plotWindow2 = new PlotWindow(new TraceListModel(), 1);
        View view2 = new View("Plot 1", null, plotWindow2);
        view2.getWindowProperties().setCloseEnabled(false);
        this.XYPlotViews.add(view2);
        this.viewMap.addView(2, view2);
        PlotPanelXYChart plotPanelXYChart = (PlotPanelXYChart)plotWindow2.getPlot();
        CVSim.sim.addChangeListener(plotPanelXYChart.sourceDataChanged);
        plotPanelXYChart.createNewTrace(CVSim.sim.getOutputVariable("LVV"), CVSim.sim.getOutputVariable("LVP"));
        RootWindow rootWindow = DockingUtil.createRootWindow(this.viewMap, true);
        this.stripChartTabWindow = new TabWindow(view);
        this.stripChartTabWindow.getWindowProperties().setCloseEnabled(false);
        this.XYPlotTabWindow = new TabWindow(view2);
        this.XYPlotTabWindow.getWindowProperties().setCloseEnabled(false);
        SplitWindow splitWindow = new SplitWindow(true, this.stripChartTabWindow, this.XYPlotTabWindow);
        rootWindow.setWindow(splitWindow);
        this.patientList = new ArrayList<Patient>();
        this.parameterPanel = new ParameterPanel();
        this.outputPanel = new OutputPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Simulation Variables", this.parameterPanel);
        jTabbedPane.addTab("Simulation Outputs", this.outputPanel);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTabbedPane.setBorder(compoundBorder);
        ImagePanel imagePanel = new ImagePanel();
        imagePanel.setBorder(compoundBorder);
        JScrollPane jScrollPane = new JScrollPane(imagePanel);
        JViewport jViewport = jScrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        jViewport.setViewPosition(new Point(point.x, point.y + 45));
        JSplitPane jSplitPane = new JSplitPane(1, jTabbedPane, jScrollPane);
        jSplitPane.setDividerLocation((int)((double)dimension2.width * 0.45));
        this.toolbar = new ControlToolBar();
        frame.setJMenuBar(this.createMenuBar());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel.add((Component)this.toolbar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel.add((Component)jSplitPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)rootWindow, gridBagConstraints);
        frame.setContentPane(jPanel);
        frame.setVisible(true);
        frame.setExtendedState(6);
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(new ExitAction());
        jMenuBar.add(this.toolbar.createSimulationMenu());
        JMenu jMenu2 = new JMenu("Plot");
        jMenuBar.add(jMenu2);
        jMenu2.add(new CreateStripChartWindowAction());
        jMenu2.add(new CreateXYPlotWindowAction());
        jMenuBar.add(this.parameterPanel.getMenuOfActions());
        jMenuBar.add(this.outputPanel.getMenuOfActions());
        this.createPatients();
        JMenu jMenu3 = new JMenu("Patients");
        jMenuBar.add(jMenu3);
        for (Patient patient : this.patientList) {
            jMenu3.add(new DisplayPatientHistoryAction(patient));
        }
        return jMenuBar;
    }

    public void createPatients() {
        String string = "Patient 1";
        String string2 = String.format("This patient is 40 years old, is well developed, and presents with dyspnea and chest pain on exertion, and frequent ventricular arrhythmias. He has had several unexplained syncopal attacks, from which he has recovered without incident. Physical exam revealed a prominent LV impulse, a palpable fourth heart sound, a biphasic carotid pulse with a sharp rise time, and a systolic ejection murmur which increased in intensity with isuprel.", new Object[0]);
        Patient patient = new Patient(string, string2);
        patient.addParameterSetting("Total Zero-Pressure Filling Volume", 2000.0);
        patient.addParameterSetting("Total Blood Volume", 6000.0);
        patient.addParameterSetting("Aortic Valve Resistance", 0.1);
        patient.addParameterSetting("Left Ventricle Diastolic Compliance", 3.0);
        patient.addParameterSetting("Left Ventricle Systolic Compliance", 0.1);
        patient.addParameterSetting("Right Ventricle Diastolic Compliance", 4.0);
        patient.addParameterSetting("Nominal Heart Rate", 100.0);
        this.patientList.add(patient);
        String string3 = "Patient 2";
        String string4 = String.format("This patient is a 24 year old woman who presents with a long history of severe dyspnea and now requires constant oxygen supplements. She also has had a long history of peripheral edema. Physical exam reveals elevated jugular venous pressure, a prominent cardiac impulse in the subxyphoid area, and a loud second heart sound which was not split. She had obvious cyanosis and clubbing of the fingers.", new Object[0]);
        Patient patient2 = new Patient(string3, string4);
        patient2.addParameterSetting("Pulmonary Arterial Compliance", 2.5);
        patient2.addParameterSetting("Total Blood Volume", 6000.0);
        patient2.addParameterSetting("Pulmonary Microcirculation Resistance", 1.0);
        patient2.addParameterSetting("Right Ventricle Diastolic Compliance", 10.0);
        patient2.addParameterSetting("Right Ventricle Systolic Compliance", 0.4);
        patient2.addParameterSetting("Nominal Heart Rate", 120.0);
        this.patientList.add(patient2);
        String string5 = "Patient 3";
        String string6 = String.format("This patient is a 67 year old man who complained of awareness of a rapid pulse rate and a forceful heart beat. In addition, he reported that his exercise tolerance had decreased, and that he would get short of breath and fatigued more easily than ever before. He had no previous history of heart disease. A previous physical examination done a year ago had discovered a pulsatile abdominal mass, with an audible bruit in its vicinity. He had good femoral pulses bilaterally at that time. Examination now confirms the presence of the pulsatile mass and bruit. The cardiac exam reveals a rapid heart rate with a very forceful apical impulse. There was a grade 2/6 systolic murmur heard at the apex and over the second intercostal space to the left of the sternum. No diastolic murmurs were heard. Prominent capillary pulsations were noted in the nail beds and under the tongue. Femoral pulses were present bilaterally, athough the left was weaker than the right. The patient was taken to the catheterization lab for confirmation of the diagnosis.", new Object[0]);
        Patient patient3 = new Patient(string5, string6);
        patient3.addParameterSetting("Total Peripheral Resistance", 0.1);
        patient3.addParameterSetting("Venous Compliance", 70.0);
        patient3.addParameterSetting("Total Zero-Pressure Filling Volume", 1500.0);
        patient3.addParameterSetting("Pulmonary Microcirculation Resistance", 0.04);
        patient3.addParameterSetting("Left Ventricle Systolic Compliance", 0.2);
        patient3.addParameterSetting("Right Ventricle Systolic Compliance", 0.6);
        patient3.addParameterSetting("Total Blood Volume", 5500.0);
        patient3.addParameterSetting("Nominal Heart Rate", 120.0);
        this.patientList.add(patient3);
        String string7 = "Patient 4";
        String string8 = String.format("This patient is a 41 year old mother of three children who was well (except for the usual colds, etc.) until last year when she began to experience shortness of breath on even minor exercise, and episodes of shortness of breath during the night which were relieved by standing up. She denied any chest pain, chest infections, palpitations; but did report some mild swelling of the ankles. Her physical activities have become severely limited because of the shortness of breath. She has been taking several medications at the request of her physician. She comes to you for hemodynamic evaluation and assessment. Her exam reveals an enlarged heart, regular rhythm, an S-3 gallop, no murmurs, and fine rales at both lung bases. There was 2+ ankle and pretibial edema.", new Object[0]);
        Patient patient4 = new Patient(string7, string8);
        patient4.addParameterSetting("Total Peripheral Resistance", 0.9);
        patient4.addParameterSetting("Arterial Compliance", 1.0);
        patient4.addParameterSetting("Total Zero-Pressure Filling Volume", 2300.0);
        patient4.addParameterSetting("Pulmonary Arterial Compliance", 2.5);
        patient4.addParameterSetting("Pulmonary Microcirculation Resistance", 0.14);
        patient4.addParameterSetting("Left Ventricle Diastolic Compliance", 5.0);
        patient4.addParameterSetting("Left Ventricle Systolic Compliance", 1.2);
        patient4.addParameterSetting("Right Ventricle Diastolic Compliance", 11.0);
        patient4.addParameterSetting("Right Ventricle Systolic Compliance", 3.6);
        patient4.addParameterSetting("Total Blood Volume", 6300.0);
        patient4.addParameterSetting("Nominal Heart Rate", 125.0);
        this.patientList.add(patient4);
        String string9 = "Patient 5";
        String string10 = String.format("The patient is a 60 year old man who entered the hospital with severe crushing substernal chest pain of two hours duration. He appears short of breath. He is diaphoretic, has cold clammy skin, and his nail-beds are cyanotic. He is very lethargic and seems somewhat confused. He has low blood pressure, elevated jugular venous pressure, a regular cardiac rhythm with an S-3 gallop, and examination of the lungs reveals bibasilar fine rales. He has no edema. His urine output seems to be very scanty.", new Object[0]);
        Patient patient5 = new Patient(string9, string10);
        patient5.addParameterSetting("Total Peripheral Resistance", 1.4);
        patient5.addParameterSetting("Arterial Compliance", 0.5);
        patient5.addParameterSetting("Total Zero-Pressure Filling Volume", 1850.0);
        patient5.addParameterSetting("Pulmonary Arterial Compliance", 2.0);
        patient5.addParameterSetting("Left Ventricle Diastolic Compliance", 8.0);
        patient5.addParameterSetting("Left Ventricle Systolic Compliance", 2.5);
        patient5.addParameterSetting("Right Ventricle Diastolic Compliance", 15.0);
        patient5.addParameterSetting("Right Ventricle Systolic Compliance", 4.0);
        patient5.addParameterSetting("Nominal Heart Rate", 110.0);
        this.patientList.add(patient5);
        String string11 = "Patient 6";
        String string12 = String.format("This 55 year old male bank vice-president had been in excellent health until one month ago when he began to notice unusual shortness of breath and substernal pressure which was associated with physical exercise. The symptoms would be brought on quite predictably after carrying a heavy briefcase up to the third floor of the parking garage, for example. Rest would always relieve the discomfort after a few minutes. He had a known heart murmur which was first noted on a routine physical examination ten years ago, but at the time it had been considered to be an \"innocent\" murmur. On the day of admission he had been carrying a bag of cement to his backyard when he suddenly became lightheaded and then lost conciousness.", new Object[0]);
        Patient patient6 = new Patient(string11, string12);
        patient6.addParameterSetting("Arterial Compliance", 0.8);
        patient6.addParameterSetting("Aortic Valve Resistance", 0.1);
        patient6.addParameterSetting("Left Ventricle Diastolic Compliance", 8.0);
        patient6.addParameterSetting("Left Ventricle Systolic Compliance", 0.3);
        patient6.addParameterSetting("Total Blood Volume", 5100.0);
        patient6.addParameterSetting("Nominal Heart Rate", 60.0);
        this.patientList.add(patient6);
    }

    private class DisplayPatientHistoryAction
    extends AbstractAction {
        Patient pt;

        public DisplayPatientHistoryAction(Patient patient) {
            this.pt = patient;
            this.putValue("Name", "Load " + this.pt.getName());
            this.putValue("ShortDescription", String.format("Display " + this.pt.getName() + " History", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pt.loadParameterSettings();
            if (!this.pt.getFrame().isVisible()) {
                this.pt.getFrame().setVisible(true);
            }
            if (this.pt.getFrame().getExtendedState() == 1) {
                this.pt.getFrame().setExtendedState(0);
            }
            System.out.println("Loading patient history for " + this.pt.getName() + ".");
        }
    }

    private class DockingWindowCleanupListener
    implements DockingWindowListener {
        private DockingWindowCleanupListener() {
        }

        public void viewFocusChanged(View view, View view2) {
        }

        public void windowAdded(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        }

        public void windowClosed(DockingWindow dockingWindow) {
        }

        public void windowClosing(DockingWindow dockingWindow) {
            System.out.println("Caught windowClosing() from DockingWindowCleanupListener, cleaning up.");
            PlotWindow plotWindow = (PlotWindow)((View)dockingWindow).getComponent();
            PlotPanel plotPanel = plotWindow.getPlot();
            plotPanel.removeAllTraces();
        }

        public void windowDocked(DockingWindow dockingWindow) {
        }

        public void windowDocking(DockingWindow dockingWindow) {
        }

        public void windowHidden(DockingWindow dockingWindow) {
        }

        public void windowMaximized(DockingWindow dockingWindow) {
        }

        public void windowMaximizing(DockingWindow dockingWindow) {
        }

        public void windowMinimized(DockingWindow dockingWindow) {
        }

        public void windowMinimizing(DockingWindow dockingWindow) {
        }

        public void windowRemoved(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        }

        public void windowRestored(DockingWindow dockingWindow) {
        }

        public void windowRestoring(DockingWindow dockingWindow) {
        }

        public void windowShown(DockingWindow dockingWindow) {
        }

        public void windowUndocked(DockingWindow dockingWindow) {
        }

        public void windowUndocking(DockingWindow dockingWindow) {
        }
    }

    private class FrameSynchListener
    implements WindowListener {
        private FrameSynchListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
            for (Patient patient : gui.this.patientList) {
                patient.getFrame().setExtendedState(1);
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    private class CreateXYPlotWindowAction
    extends AbstractAction {
        public CreateXYPlotWindowAction() {
            this.putValue("Name", "New Plot");
            this.putValue("ShortDescription", "Create a new plot");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = gui.this.XYPlotTabWindow.getChildWindowCount() + 1;
            PlotWindow plotWindow = new PlotWindow(new TraceListModel(), 1);
            View view = new View("Plot " + n, null, plotWindow);
            gui.this.XYPlotViews.add(view);
            gui.this.viewMap.addView(n, view);
            gui.this.XYPlotTabWindow.addTab(view);
            CVSim.sim.addChangeListener(plotWindow.getPlot().sourceDataChanged);
        }
    }

    private class CreateStripChartWindowAction
    extends AbstractAction {
        public CreateStripChartWindowAction() {
            this.putValue("Name", "New Strip Chart");
            this.putValue("ShortDescription", "Create a new strip chart");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = gui.this.stripChartTabWindow.getChildWindowCount() + 1;
            PlotWindow plotWindow = new PlotWindow(new TraceListModel(), 2);
            View view = new View("Strip Chart " + n, null, plotWindow);
            gui.this.stripChartViews.add(view);
            gui.this.viewMap.addView(n, view);
            gui.this.stripChartTabWindow.addTab(view);
            CVSim.sim.addChangeListener(plotWindow.getPlot().sourceDataChanged);
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("ShortDescription", "Exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            frame.dispose();
            System.exit(0);
        }
    }
}

