/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CSimulation;
import java.util.Timer;
import java.util.TimerTask;

public class SimulationThread {
    private Timer _timer;
    private long _period;
    private String _name;
    private boolean _timerRunning;
    public CSimulation _sim;
    private TimerTask _simTask;

    public SimulationThread(CSimulation cSimulation) {
        this._sim = cSimulation;
        this._period = 0L;
        this._timerRunning = false;
    }

    public String getName() {
        return this._name;
    }

    public void setPeriod(long l) {
        this._period = l;
        System.out.println("Simulation Period set to " + this._period);
        if (this._timerRunning) {
            this.stop();
            this.start();
        }
    }

    public long getPeriod() {
        return this._period;
    }

    public boolean isRunning() {
        return this._timerRunning;
    }

    public void start() {
        if (this._period > 0L && !this._timerRunning) {
            System.out.println("SimulationThread.start(): " + this._period + "ms");
            this._timer = new Timer();
            this._simTask = new TimerTask(){

                public void run() {
                    SimulationThread.this._sim.step();
                }
            };
            this._timer.scheduleAtFixedRate(this._simTask, 0L, this._period);
            this._timerRunning = true;
        }
    }

    public void stop() {
        if (this._timerRunning) {
            System.out.println("SimulationThread.stop(): " + this._period + "ms");
            this._timer.cancel();
            this._timerRunning = false;
        }
    }
}

