/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.Range;
import edu.mit.lcp.SimulationOutputVariable;
import edu.mit.lcp.VariableRecorderInterface;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationOutputVariableBuffer<E extends Number>
implements VariableRecorderInterface<E> {
    public static final int DISABLE_MIN_MAX_UPDATES = 1;
    public static final int DATA_MONOTONIC_INCREASING = 2;
    public static final int DATA_MONOTONIC_DECREASING = 4;
    private E _minVal;
    private E _maxVal;
    private int _flags;
    private SimulationOutputVariable<E> var;
    private int _sizeLimit;
    private int _nextWriteLoc;
    private long lastUpdate;
    private E lastDatum;
    private Vector<E> _data;

    public SimulationOutputVariableBuffer(int n, SimulationOutputVariableBuffer<E> simulationOutputVariableBuffer) {
        this(n, simulationOutputVariableBuffer.getVar(), (Number)simulationOutputVariableBuffer.iterator().next(), simulationOutputVariableBuffer.getFlags());
        for (Number number : simulationOutputVariableBuffer) {
            this._data.setElementAt(number, this._nextWriteLoc);
        }
        this._minVal = (Number)Collections.min(this._data);
        this._maxVal = (Number)Collections.max(this._data);
    }

    public SimulationOutputVariableBuffer(SimulationOutputVariable simulationOutputVariable, E e) {
        this(1, simulationOutputVariable, e, 0);
    }

    public SimulationOutputVariableBuffer(int n, SimulationOutputVariable simulationOutputVariable, E e) {
        this(n, simulationOutputVariable, e, 0);
    }

    public SimulationOutputVariableBuffer(int n, SimulationOutputVariable simulationOutputVariable, E e, int n2) {
        this._sizeLimit = n;
        this.var = simulationOutputVariable;
        this._flags = n2;
        this._data = new Vector(this._sizeLimit);
        for (int i = 0; i < this._sizeLimit; ++i) {
            this._data.add(e);
        }
        this._minVal = e;
        this._maxVal = e;
        this.lastUpdate = -1L;
        this.lastDatum = e;
        this._nextWriteLoc = 0;
    }

    private void incrementWriteLoc() {
        ++this._nextWriteLoc;
        if (this._nextWriteLoc >= this._sizeLimit) {
            this._nextWriteLoc = 0;
        }
    }

    public void clearData() {
        this._data.clear();
    }

    public String toString() {
        return this.var.getDescription();
    }

    @Override
    public int getOutputIndex() {
        return this.var.getOutputIndex();
    }

    @Override
    public String getName() {
        return this.var.getName();
    }

    @Override
    public String getDescription() {
        return this.var.getDescription();
    }

    @Override
    public String getUnits() {
        return this.var.getUnits();
    }

    @Override
    public int getSize() {
        return this._data.size();
    }

    @Override
    public String getCategory() {
        return this.var.getCategory();
    }

    @Override
    public String getType() {
        return this.var.getType();
    }

    public SimulationOutputVariable getVar() {
        return this.var;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int n) {
        this._flags = n;
    }

    @Override
    public Range<E> getTypicalRange() {
        return new Range<E>(this.var.getTypicalRange());
    }

    @Override
    public E getMinVal() {
        return this._minVal;
    }

    @Override
    public E getMaxVal() {
        return this._maxVal;
    }

    @Override
    public long getLastMarker() {
        return this.lastUpdate;
    }

    @Override
    public E getLastDatum() {
        return this.lastDatum;
    }

    @Override
    public void addDatum(E e) {
        this.addMarkedDatum(e, 0L);
    }

    @Override
    public void addMarkedDatum(E e, long l) {
        Number number = (Number)this._data.get(this._nextWriteLoc);
        this._data.setElementAt(e, this._nextWriteLoc);
        this.lastUpdate = l;
        this.lastDatum = e;
        this.incrementWriteLoc();
        if ((~this._flags & 1) == 1) {
            if (((Comparable)e).compareTo(this._minVal) < 0) {
                this._minVal = e;
            } else if (((Comparable)((Object)number)).compareTo(this._minVal) == 0) {
                this._minVal = (this._flags & 2) == 2 ? (Number)((Number)this._data.get(this._nextWriteLoc)) : (Number)((Number)Collections.min(this._data));
            }
            if (((Comparable)e).compareTo(this._maxVal) > 0) {
                this._maxVal = e;
            } else if (((Comparable)((Object)number)).compareTo(this._maxVal) == 0) {
                this._maxVal = (this._flags & 4) == 4 ? (Number)((Number)this._data.get(this._nextWriteLoc)) : (Number)((Number)Collections.max(this._data));
            }
        }
    }

    public int getIteratorStartIndex() {
        return this._nextWriteLoc;
    }

    @Override
    public Iterator<E> iterator() {
        return new WrappingIterator<E>(this._data, this.getIteratorStartIndex());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappingIterator<E extends Number>
    implements Iterator<E> {
        private List<E> _theList;
        private int _startLoc;
        private int _endLoc;
        private int _curLoc;
        private int _size;

        public WrappingIterator(List<E> list, int n) {
            this._theList = list;
            this._size = this._theList.size();
            this._startLoc = n;
            this._curLoc = n;
            this._endLoc = this._startLoc == 0 ? this._size - 1 : n - 1;
        }

        @Override
        public boolean hasNext() {
            return this._curLoc != this._endLoc;
        }

        @Override
        public E next() {
            ++this._curLoc;
            this._curLoc %= this._size;
            return (E)((Number)this._theList.get(this._curLoc));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

