/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.Parameter;
import edu.mit.lcp.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class Patient {
    private String _name;
    private String _history;
    private List<Parameter> parameterList;
    private List<Double> valueList;
    private JFrame frame;

    public Patient(String string, String string2) {
        this._name = string;
        this._history = string2;
        this.parameterList = new ArrayList<Parameter>();
        this.valueList = new ArrayList<Double>();
        this.frame = this.createPatientHistoryFrame();
    }

    private JFrame createPatientHistoryFrame() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setText(this._history);
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        JFrame jFrame = new JFrame("Patient History: " + this._name);
        jFrame.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setOpaque(true);
        jFrame.setContentPane(jPanel);
        int n = 300;
        int n2 = 300;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setSize(n, n2);
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        return jFrame;
    }

    public void addParameterSetting(String string, Double d) {
        Parameter parameter = CVSim.sim.getParameterByName(string);
        if (parameter != null) {
            this.parameterList.add(parameter);
            this.valueList.add(d);
        } else {
            System.out.print("Could not load " + string + " from patient data.\n");
        }
    }

    public void loadParameterSettings() {
        CVSim.gui.parameterPanel.resetParameters(CVSim.sim.getParameterList());
        ParameterPanel cfr_ignored_0 = CVSim.gui.parameterPanel;
        CVSim.gui.parameterPanel.setDisplayMode("Patient");
        for (int i = 0; i < this.parameterList.size(); ++i) {
            this.parameterList.get(i).setValue(this.valueList.get(i));
            this.parameterList.get(i).setPtModeDefaultValue(this.valueList.get(i));
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getHistory() {
        return this._history;
    }

    public void setHistory(String string) {
        this._history = string;
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

