/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.C6_comp_backend.Parameter_vector;
import edu.mit.lcp.C6_comp_backend.main;
import edu.mit.lcp.CVSim;
import edu.mit.lcp.Parameter;
import edu.mit.lcp.ParameterPanel;
import edu.mit.lcp.gui;
import javax.swing.JOptionPane;

public class Parameter6C
extends Parameter {
    private Parameter_vector paramVec;

    public Parameter6C(Parameter_vector parameter_vector, int n, String string, String string2, String string3) {
        this(parameter_vector, n, string, string, string2, string3);
    }

    public Parameter6C(Parameter_vector parameter_vector, int n, String string, String string2, String string3, String string4) {
        super(n, string, string2, string3, string4);
        this.paramVec = parameter_vector;
        this.setDefaultValue();
    }

    public Parameter6C(Parameter_vector parameter_vector, int n, String string, String string2, String string3, String string4, double d, double d2) {
        super(n, string, string2, string3, string4, d, d2);
        this.paramVec = parameter_vector;
        this.setDefaultValue();
    }

    public void setValue(Double d) {
        String string;
        Double d2 = this.getValue();
        if (this.getName().equals("Total Zero-Pressure Filling Volume") && d > CVSim.sim.getParameterByName("Total Blood Volume").getValue()) {
            String string2 = String.format("The Total Zero-Pressure Filling Volume cannot be greater than the Total Blood Volume.", new Object[0]);
            JOptionPane.showMessageDialog(gui.frame, string2);
            return;
        }
        if (this.getName().equals("Left Ventricle Systolic Compliance") && d > CVSim.sim.getParameterByName("Left Ventricle Diastolic Compliance").getValue()) {
            String string3 = String.format("The Left Ventricle Systolic Compliance cannot be greater than the Left Ventricle Diastolic Compliance.", new Object[0]);
            JOptionPane.showMessageDialog(gui.frame, string3);
            return;
        }
        if (this.getName().equals("Right Ventricle Systolic Compliance") && d > CVSim.sim.getParameterByName("Right Ventricle Diastolic Compliance").getValue()) {
            String string4 = String.format("The Right Ventricle Systolic Compliance cannot be greater than the Right Ventricle Diastolic Compliance.", new Object[0]);
            JOptionPane.showMessageDialog(gui.frame, string4);
            return;
        }
        ParameterPanel cfr_ignored_0 = CVSim.gui.parameterPanel;
        if (CVSim.gui.parameterPanel.getDisplayMode().equals("Default")) {
            if (d < this.getMin()) {
                string = String.format("The value you entered for " + this.getName() + " is outside \nthe allowed range. Please enter a value between %.3f and %.3f.", this.getMin(), this.getMax());
                JOptionPane.showMessageDialog(gui.frame, string);
                d = this.getMin();
            } else if (d > this.getMax()) {
                string = String.format("The value you entered for " + this.getName() + " is outside \nthe allowed range. Please enter a value between %.3f and %.3f.", this.getMin(), this.getMax());
                JOptionPane.showMessageDialog(gui.frame, string);
                d = this.getMax();
            }
        }
        if (this.getName().equals("Pulmonary Arterial Compliance")) {
            main.updatePulmonaryArterialCompliance(d, this.paramVec);
        } else if (this.getName().equals("Pulmonary Venous Compliance")) {
            main.updatePulmonaryVenousCompliance(d, this.paramVec);
        } else if (this.getName().equals("Arterial Compliance")) {
            main.updateArterialCompliance(d, this.paramVec);
        } else if (this.getName().equals("Venous Compliance")) {
            main.updateVenousCompliance(d, this.paramVec);
        }
        if (this.getName().equals("Total Blood Volume")) {
            main.updateTotalBloodVolume(d, this.paramVec);
        } else if (this.getName().equals("Intra-thoracic Pressure")) {
            main.updateIntrathoracicPressure(d, this.paramVec);
        } else if (this.getName().equals("Total Zero-Pressure Filling Volume")) {
            main.updateTotalZeroPressureFillingVolume(d, this.paramVec);
        } else {
            main.updateParameter(d, this.paramVec, this.getIndex());
        }
        this.firePropertyChange("VALUE", d2, d);
        string = String.format(this.getName() + " changed from %.3f to %.3f.", d2, this.getValue());
        System.out.println(string);
    }

    public Double getValue() {
        return this.paramVec.getVec(this.getIndex());
    }
}

