/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.DisableableJTable;
import edu.mit.lcp.OutputVariableTableModel;
import edu.mit.lcp.SimulationOutputVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;

public class OutputPanel
extends JPanel {
    private static final String CHOICE_ALL = "ALL";
    public OutputVariableTableModel model;
    private JButton selectButton;
    private JMenu selectButtonMenu;
    private JMenu selectMenu;
    private JLabel categoryComboBoxLabel;
    private JComboBox categoryComboBox;
    private JLabel typeComboBoxLabel;
    private JComboBox typeComboBox;
    private JTable table;
    private JMenu actionsMenu;
    private ActionListener CategoryComboBoxListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
            if (string.equals(OutputPanel.CHOICE_ALL)) {
                string = null;
            }
            OutputPanel.this.model.setCategoryFilter(string);
            String string2 = (String)OutputPanel.this.typeComboBox.getSelectedItem();
            OutputPanel.this.typeComboBox.setModel(new DefaultComboBoxModel<String>(OutputPanel.this.getModelOutputTypeChoices()));
            OutputPanel.this.typeComboBox.setSelectedItem(string2);
            if (!((String)OutputPanel.this.typeComboBox.getSelectedItem()).equals(string2)) {
                OutputPanel.this.typeComboBox.setSelectedItem(OutputPanel.CHOICE_ALL);
            }
        }
    };
    private ActionListener TypeComboBoxListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
            if (string.equals(OutputPanel.CHOICE_ALL)) {
                string = null;
            }
            OutputPanel.this.model.setTypeFilter(string);
        }
    };

    public OutputPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.model = new OutputVariableTableModel(CVSim.sim.getOutputVariables());
        this.actionsMenu = new JMenu("Outputs");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        JLabel jLabel = new JLabel("Show Location:");
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 7));
        jToolBar.add(jLabel);
        this.categoryComboBox = new JComboBox<String>(this.getModelCategoryChoices());
        this.categoryComboBox.addActionListener(this.CategoryComboBoxListener);
        jToolBar.add(this.categoryComboBox);
        JLabel jLabel2 = new JLabel("Show Type:");
        jLabel2.setBorder(new EmptyBorder(0, 7, 0, 7));
        jToolBar.add(jLabel2);
        this.typeComboBox = new JComboBox<String>(this.getModelOutputTypeChoices());
        this.typeComboBox.addActionListener(this.TypeComboBoxListener);
        jToolBar.add(this.typeComboBox);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.setRollover(true);
        this.selectButtonMenu = new JMenu("Select");
        JMenuItem jMenuItem = new JMenuItem("Select All");
        jMenuItem.addActionListener(new SelectAllOutputsAction(this));
        JMenuItem jMenuItem2 = new JMenuItem("Select Visible");
        jMenuItem2.addActionListener(new SelectVisibleOutputsAction(this));
        JMenuItem jMenuItem3 = new JMenuItem("Select None");
        jMenuItem3.addActionListener(new SelectNoneOutputsAction(this));
        this.selectButtonMenu.add(jMenuItem);
        this.selectButtonMenu.add(jMenuItem2);
        this.selectButtonMenu.add(jMenuItem3);
        this.selectButton = new DropDownToolbarButton(this.selectButtonMenu);
        jToolBar2.add(this.selectButton);
        this.selectMenu = new JMenu("Select");
        JMenuItem jMenuItem4 = new JMenuItem("Select All");
        jMenuItem4.addActionListener(new SelectAllOutputsAction(this));
        JMenuItem jMenuItem5 = new JMenuItem("Select Visible");
        jMenuItem5.addActionListener(new SelectVisibleOutputsAction(this));
        JMenuItem jMenuItem6 = new JMenuItem("Select None");
        jMenuItem6.addActionListener(new SelectNoneOutputsAction(this));
        this.selectMenu.add(jMenuItem4);
        this.selectMenu.add(jMenuItem5);
        this.selectMenu.add(jMenuItem6);
        this.actionsMenu.add(this.selectMenu);
        CVSim.sim.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OutputPanel.this.model.fireTableDataChanged();
            }
        });
        this.table = new DisableableJTable(this.model);
        this.table.setCellSelectionEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)jToolBar2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public JMenu getMenuOfActions() {
        return this.actionsMenu;
    }

    private String[] getModelCategoryChoices() {
        List<String> list = this.model.getCategoryNames();
        list.add(0, CHOICE_ALL);
        Object[] objectArray = new String[list.size()];
        list.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[] getModelOutputTypeChoices() {
        List<String> list = this.model.getFilteredOutputTypeNames();
        list.add(0, CHOICE_ALL);
        Object[] objectArray = new String[list.size()];
        list.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private class DropDownToolbarButton
    extends JButton {
        private JPopupMenu buttonMenu;

        public DropDownToolbarButton(JMenu jMenu) {
            super(jMenu.getText());
            this.buttonMenu = jMenu.getPopupMenu();
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    DropDownToolbarButton.this.buttonMenu.show(component, 0, component.getHeight());
                }
            });
        }
    }

    private class SelectNoneOutputsAction
    extends AbstractAction {
        private Component pc;

        public SelectNoneOutputsAction(Component component) {
            super("Select None");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (SimulationOutputVariable simulationOutputVariable : OutputPanel.this.model.getOutputList()) {
                OutputPanel.this.model.setOutputSelected(simulationOutputVariable, false);
            }
        }
    }

    private class SelectVisibleOutputsAction
    extends AbstractAction {
        private Component pc;

        public SelectVisibleOutputsAction(Component component) {
            super("Select Visible");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (SimulationOutputVariable simulationOutputVariable : OutputPanel.this.model.getFilteredOutputList()) {
                OutputPanel.this.model.setOutputSelected(simulationOutputVariable, true);
            }
        }
    }

    private class SelectAllOutputsAction
    extends AbstractAction {
        private Component pc;

        public SelectAllOutputsAction(Component component) {
            super("Select All");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (SimulationOutputVariable simulationOutputVariable : OutputPanel.this.model.getOutputList()) {
                OutputPanel.this.model.setOutputSelected(simulationOutputVariable, true);
            }
        }
    }
}

