/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.C6_comp_backend.Parameter_vector;
import edu.mit.lcp.C6_comp_backend.main;
import edu.mit.lcp.C6_comp_backend.output;
import edu.mit.lcp.CSimulation;
import edu.mit.lcp.Parameter;
import edu.mit.lcp.Parameter6C;
import edu.mit.lcp.Range;
import edu.mit.lcp.SimulationOutputVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSimulation6C
extends CSimulation {
    private output output;
    private CSimulation6CParameters simParameters;

    public CSimulation6C() {
        System.err.println("CSimulation6C()");
        try {
            System.err.println("Loading shared C library");
            System.loadLibrary("C6_comp_backend");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("C library failed to load" + unsatisfiedLinkError);
            System.exit(1);
        }
        this.output = new output();
        this.simParameters = new CSimulation6CParameters();
        this.varList = new ArrayList();
        this.varList.add(new SimulationOutputVariable<Double>(0, "TIME", "Time", "s", "Systemic Parameters", "Time", new Range<Double>(0.0, 0.0)));
        this.varList.add(new SimulationOutputVariable<Double>(1, "LVP", "Left Ventricle Pressure", "mmHg", "Left Heart", "Pressure", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(2, "LVQ", "Left Ventricle Flow", "mL/s", "Left Heart", "Flow", new Range<Double>(0.0, 1500.0)));
        this.varList.add(new SimulationOutputVariable<Double>(3, "LVV", "Left Ventricle Volume", "mL", "Left Heart", "Volume", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(4, "AP", "Arterial Pressure", "mmHg", "Systemic Arteries", "Pressure", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(5, "AQ", "Arterial Flow", "mL/s", "Systemic Arteries", "Flow", new Range<Double>(0.0, 150.0)));
        this.varList.add(new SimulationOutputVariable<Double>(6, "AV", "Arterial Volume", "mL", "Systemic Arteries", "Volume", new Range<Double>(0.0, 1250.0)));
        this.varList.add(new SimulationOutputVariable<Double>(7, "CVP", "Central Venous Pressure", "mmHg", "Systemic Veins", "Pressure", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(8, "CVQ", "Central Venous Flow", "mL/s", "Systemic Veins", "Flow", new Range<Double>(0.0, 250.0)));
        this.varList.add(new SimulationOutputVariable<Double>(9, "CVV", "Central Venous Volume", "mL", "Systemic Veins", "Volume", new Range<Double>(0.0, 3500.0)));
        this.varList.add(new SimulationOutputVariable<Double>(10, "RVP", "Right Ventricle Pressure", "mmHg", "Right Heart", "Pressure", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(11, "RVQ", "Right Ventricle Flow", "mL/s", "Right Heart", "Flow", new Range<Double>(0.0, 1000.0)));
        this.varList.add(new SimulationOutputVariable<Double>(12, "RVV", "Right Ventricle Volume", "mL", "Right Heart", "Volume", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(13, "PAP", "Pulmonary Arterial Pressure", "mmHg", "Pulmonary Arteries", "Pressure", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(14, "PAQ", "Pulmonary Arterial Flow", "mL/s", "Pulmonary Arteries", "Flow", new Range<Double>(0.0, 225.0)));
        this.varList.add(new SimulationOutputVariable<Double>(15, "PAV", "Pulmonary Arterial Volume", "mL", "Pulmonary Arteries", "Volume", new Range<Double>(0.0, 225.0)));
        this.varList.add(new SimulationOutputVariable<Double>(16, "PVP", "Pulmonary Venous Pressure", "mmHg", "Pulmonary Veins", "Pressure", new Range<Double>(0.0, 200.0)));
        this.varList.add(new SimulationOutputVariable<Double>(17, "PVQ", "Pulmonary Venous Flow", "mL/s", "Pulmonary Veins", "Flow", new Range<Double>(0.0, 2000.0)));
        this.varList.add(new SimulationOutputVariable<Double>(18, "PVV", "Pulmonary Venous Volume", "mL", "Pulmonary Veins", "Volume", new Range<Double>(0.0, 1000.0)));
        this.varList.add(new SimulationOutputVariable<Double>(19, "HR", "Heart Rate", "beats/min", "Systemic Parameters", "Reflex", new Range<Double>(0.0, 100.0)));
        this.varList.add(new SimulationOutputVariable<Double>(20, "AR", "Arteriolar Resistance", "PRU", "Systemic Arteries", "Reflex", new Range<Double>(0.0, 10.0)));
        this.varList.add(new SimulationOutputVariable<Double>(21, "VT", "Venous Tone", "mL", "Systemic Veins", "Reflex", new Range<Double>(0.0, 2500.0)));
        this.varList.add(new SimulationOutputVariable<Double>(22, "RVC", "Right Ventricle Contractility", "mL/mmHg", "Right Heart", "Reflex", new Range<Double>(0.0, 10.0)));
        this.varList.add(new SimulationOutputVariable<Double>(23, "LVC", "Left Ventricle Contractility", "mL/mmHg", "Left Heart", "Reflex", new Range<Double>(0.0, 10.0)));
    }

    @Override
    public void reset() {
        main.reset_sim();
    }

    @Override
    public void step() {
        main.step_sim(this.output, this.simParameters.getVector(), this.getDataCompressionFactor(), this.getABReflex_C(), this.getCPReflex_C());
        ++this.steps;
        this.updateRecorders();
        this.dataChanged();
    }

    @Override
    public double getOutput(int n) {
        double d;
        switch (n) {
            case 0: {
                d = this.output.getTime();
                break;
            }
            case 1: {
                d = this.output.getX0();
                break;
            }
            case 2: {
                d = this.output.getQ0();
                break;
            }
            case 3: {
                d = this.output.getV0();
                break;
            }
            case 4: {
                d = this.output.getX1();
                break;
            }
            case 5: {
                d = this.output.getQ1();
                break;
            }
            case 6: {
                d = this.output.getV1();
                break;
            }
            case 7: {
                d = this.output.getX2();
                break;
            }
            case 8: {
                d = this.output.getQ2();
                break;
            }
            case 9: {
                d = this.output.getV2();
                break;
            }
            case 10: {
                d = this.output.getX3();
                break;
            }
            case 11: {
                d = this.output.getQ3();
                break;
            }
            case 12: {
                d = this.output.getV3();
                break;
            }
            case 13: {
                d = this.output.getX4();
                break;
            }
            case 14: {
                d = this.output.getQ4();
                break;
            }
            case 15: {
                d = this.output.getV4();
                break;
            }
            case 16: {
                d = this.output.getX5();
                break;
            }
            case 17: {
                d = this.output.getQ5();
                break;
            }
            case 18: {
                d = this.output.getV5();
                break;
            }
            case 19: {
                d = this.output.getHR();
                break;
            }
            case 20: {
                d = this.output.getAR();
                break;
            }
            case 21: {
                d = this.output.getVT();
                break;
            }
            case 22: {
                d = this.output.getRVC();
                break;
            }
            case 23: {
                d = this.output.getLVC();
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    @Override
    public void updatePressure(int n, double d) {
        main.updatePressure(n, d);
    }

    @Override
    public List<Parameter> getParameterList() {
        return this.simParameters.getParameterList();
    }

    @Override
    public Parameter getParameterByName(String string) {
        return this.simParameters.getParameterByName(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CSimulation6CParameters {
        private Parameter_vector pvec = new Parameter_vector();
        private List<Parameter> plist;

        CSimulation6CParameters() {
            main.init_sim(this.pvec);
            this.plist = this.createParameterList();
        }

        public Parameter_vector getVector() {
            return this.pvec;
        }

        public List<Parameter> getParameterList() {
            return this.plist;
        }

        public Parameter getParameterByName(String string) {
            for (Parameter parameter : this.plist) {
                if (!parameter.getName().equals(string)) continue;
                return parameter;
            }
            return null;
        }

        private List<Parameter> createParameterList() {
            ArrayList<Parameter> arrayList = new ArrayList<Parameter6C>();
            arrayList.add(new Parameter6C(this.pvec, 51, "Left Heart", "Compliance", "Left Ventricle Diastolic Compliance", "mL/mmHg", 0.2, 20.0));
            arrayList.add(new Parameter6C(this.pvec, 52, "Left Heart", "Compliance", "Left Ventricle Systolic Compliance", "mL/mmHg", 0.1, 20.0));
            arrayList.add(new Parameter6C(this.pvec, 45, "Right Heart", "Compliance", "Right Ventricle Diastolic Compliance", "mL/mmHg", 0.2, 40.0));
            arrayList.add(new Parameter6C(this.pvec, 46, "Right Heart", "Compliance", "Right Ventricle Systolic Compliance", "mL/mmHg", 0.2, 40.0));
            arrayList.add(new Parameter6C(this.pvec, 47, "Pulmonary Arteries", "Compliance", "Pulmonary Arterial Compliance", "mL/mmHg", 0.1, 20.0));
            arrayList.add(new Parameter6C(this.pvec, 48, "Pulmonary Veins", "Compliance", "Pulmonary Venous Compliance", "mL/mmHg", 0.1, 40.0));
            arrayList.add(new Parameter6C(this.pvec, 153, "Systemic Arteries", "Compliance", "Arterial Compliance", "mL/mmHg", 0.1, 20.0));
            arrayList.add(new Parameter6C(this.pvec, 154, "Systemic Veins", "Compliance", "Venous Compliance", "mL/mmHg", 0.1, 500.0));
            arrayList.add(new Parameter6C(this.pvec, 155, "Left Heart", "Resistance", "Aortic Valve Resistance", "PRU", 0.001, 2.0));
            arrayList.add(new Parameter6C(this.pvec, 65, "Right Heart", "Resistance", "Pulmonic Valve Resistance", "PRU", 0.001, 2.0));
            arrayList.add(new Parameter6C(this.pvec, 66, "Pulmonary Microcirculation", "Resistance", "Pulmonary Microcirculation Resistance", "PRU", 0.01, 2.0));
            arrayList.add(new Parameter6C(this.pvec, 67, "Pulmonary Veins", "Resistance", "Pulmonary Venous Resistance", "PRU", 0.01, 2.0));
            arrayList.add(new Parameter6C(this.pvec, 156, "Systemic Microcirculation", "Resistance", "Total Peripheral Resistance", "PRU", 0.01, 10.0));
            arrayList.add(new Parameter6C(this.pvec, 157, "Systemic Veins", "Resistance", "Venous Resistance", "PRU", 0.01, 2.0));
            arrayList.add(new Parameter6C(this.pvec, 31, "Systemic Parameters", "Pressure", "Intra-thoracic Pressure", "mmHg", -20.0, 20.0));
            arrayList.add(new Parameter6C(this.pvec, 70, "Systemic Parameters", "Volume", "Total Blood Volume", "mL", 100.0, 10000.0));
            arrayList.add(new Parameter6C(this.pvec, 75, "Systemic Parameters", "Volume", "Total Zero-Pressure Filling Volume", "mL", 0.0, 10000.0));
            arrayList.add(new Parameter6C(this.pvec, 90, "Systemic Parameters", "Heart Rate", "Nominal Heart Rate", "beats/min", 20.0, 250.0));
            arrayList.add(new Parameter6C(this.pvec, 0, "Arterial Baroreflex", "Set Point", "ABR Set Point", "mmHg", 89.0, 105.0));
            arrayList.add(new Parameter6C(this.pvec, 3, "Arterial Baroreflex", "Gain", "ABR Heart Rate Parasympathetic Gain", "ms/mmHg", 0.005, 0.017));
            arrayList.add(new Parameter6C(this.pvec, 2, "Arterial Baroreflex", "Gain", "ABR Heart Rate Sympathetic Gain", "ms/mmHg", 0.005, 0.017));
            arrayList.add(new Parameter6C(this.pvec, 160, "Arterial Baroreflex", "Gain", "ABR Venous Tone Sympathetic Gain", "mL/mmHg"));
            arrayList.add(new Parameter6C(this.pvec, 158, "Arterial Baroreflex", "Gain", "ABR Arterial Resistance Sympathetic Gain", "PRU/mmHg"));
            arrayList.add(new Parameter6C(this.pvec, 12, "Arterial Baroreflex", "Gain", "ABR Contractility Right Ventricle Sympathetic Gain", "mL/mmHg^2", 0.007, 0.03));
            arrayList.add(new Parameter6C(this.pvec, 13, "Arterial Baroreflex", "Gain", "ABR Contractility Left Ventricle Sympathetic Gain", "mL/mmHg^2", 0.004, 0.014));
            arrayList.add(new Parameter6C(this.pvec, 15, "Cardiopulmonary Reflex", "Set Point", "CPR Set Point", "mmHg", 4.0, 10.0));
            arrayList.add(new Parameter6C(this.pvec, 161, "Cardiopulmonary Reflex", "Gain", "CPR Venous Tone Sympathetic Gain", "mL/mmHg"));
            arrayList.add(new Parameter6C(this.pvec, 159, "Cardiopulmonary Reflex", "Gain", "CPR Arterial Resistance Sympathetic Gain", "PRU/mmHg"));
            for (Parameter object2 : arrayList) {
                object2.addPropertyChangeListener(CSimulation6C.this.SimulationParameterChangeListener);
            }
            Parameter[] parameterArray = new Parameter[arrayList.size()];
            CSimulation.ComparatorX comparatorX = new CSimulation.ComparatorX(CSimulation6C.this);
            arrayList.toArray(parameterArray);
            Arrays.sort(parameterArray, comparatorX);
            arrayList = Arrays.asList(parameterArray);
            return arrayList;
        }
    }
}

