import subprocess
import torch

def get_device():
    # find free gpu by nvidia-smi command
    freeGpu = subprocess.check_output('nvidia-smi -q | grep "Minor\|Processes"| grep "None" -B1 | tr -d " " | cut -d ":" -f2 | sed -n "1p"', shell=True)
    # if aint free gpu 
    if len(freeGpu) == 0:
        # raise error
        device = torch.device("cpu")
        #raise RuntimeError("CUDA device unavailable...exist")
    # else set cuda device to free gpu
    else:
        device = torch.device('cuda:'+freeGpu.decode().strip())
    return device