import os
import random

import numpy as np
import pandas as pd
import torch
import yaml


def replace_equivalent_classes(classes, equivalent_classes):
    for j, x in enumerate(classes):
        for multiple_classes in equivalent_classes:
            if x in multiple_classes:
                classes[j] = multiple_classes[
                    0
                ]  # Use the first class as the representative class.
    return classes


equivalent_classes = pd.read_csv("./evaluation-2021/equivalent_classes_scored.csv", dtype="str", header=None).values.tolist()
dx_scored = pd.read_csv("./evaluation-2021/dx_mapping_scored.csv", dtype="str")
target_dxs = dx_scored["SNOMEDCTCode"].values.tolist()
target_dxs = list(set(replace_equivalent_classes(target_dxs, equivalent_classes)))

target_dxs = sorted(target_dxs)
num_target_dxs = len(target_dxs)
TARGETED = {
    "target_dxs": target_dxs,
    "num_target_dxs": num_target_dxs,
}

LEAD_DICT = {
    "TWO": "two_leads",
    "THREE": "three_leads",
    "FOUR": "four_leads",
    "SIX": "six_leads",
    "TWELVE": "twelve_leads",
}


def get_configs(model_directory):
    with open(os.path.join(model_directory, "configs.yaml")) as f:
        configs = yaml.load(f, Loader=yaml.FullLoader)
    return configs


def set_random_seed(SEED):
    torch.manual_seed(SEED)
    torch.cuda.manual_seed_all(SEED)
    random.seed(SEED)
    np.random.seed(SEED)


def setup(configs):
    if configs["RANDOM_SEED"] is not None:
        set_random_seed(configs["RANDOM_SEED"])
    os.environ["CUDA_VISIBLE_DEVICES"] = configs["GPU_NUM"]
    os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
    if torch.cuda.is_available():
        torch.backends.cudnn.deterministic = True  # This option shuould be set for reproducibility, but this hurts performance
        torch.backends.cudnn.benchmark = True
