#!/usr/bin/env sh
training_data=/data1/ecg2/L12_Dataset_Train_2021
test_data_12=/data1/ecg2/L12_Dataset_Test_2021
test_data_6=/data1/ecg2/L6_Dataset_Test_2021
test_data_4=/data1/ecg2/L4_Dataset_Test_2021
test_data_3=/data1/ecg2/L3_Dataset_Test_2021
test_data_2=/data1/ecg2/L2_Dataset_Test_2021
dir_name=`date +%Y-%m-%d_%H-%M-%S.%6N`

mkdir -p results/$dir_name

# Training
python train_model.py $training_data results/$dir_name/model

ON_TRAINING=$(niet ON_TRAINING results/$dir_name/model/configs.yaml)

# Testing, Evaluation, logging
for lead in $ON_TRAINING; do
    echo $lead
    if [ $lead = "TWELVE" ] 
    then
        python test_model.py results/$dir_name/model $test_data_12 results/$dir_name/test_outputs_12
        python evaluation-2021/evaluate_model.py $test_data_12 results/$dir_name/test_outputs_12 results/$dir_name/scores_12.csv results/$dir_name/class_scores_12.csv
        python log_challenge_metric.py --dir-path=results/$dir_name --lead=$lead
    elif [ $lead = "SIX" ] 
    then
        python test_model.py results/$dir_name/model $test_data_6 results/$dir_name/test_outputs_6
        python evaluation-2021/evaluate_model.py $test_data_6 results/$dir_name/test_outputs_6 results/$dir_name/scores_6.csv results/$dir_name/class_scores_6.csv
        python log_challenge_metric.py --dir-path=results/$dir_name --lead=$lead
    elif [ $lead = "FOUR" ] 
    then
        python test_model.py results/$dir_name/model $test_data_4 results/$dir_name/test_outputs_4
        python evaluation-2021/evaluate_model.py $test_data_4 results/$dir_name/test_outputs_4 results/$dir_name/scores_4.csv results/$dir_name/class_scores_4.csv
        python log_challenge_metric.py --dir-path=results/$dir_name --lead=$lead
    elif [ $lead = "THREE" ] 
    then
        python test_model.py results/$dir_name/model $test_data_3 results/$dir_name/test_outputs_3
        python evaluation-2021/evaluate_model.py $test_data_3 results/$dir_name/test_outputs_3 results/$dir_name/scores_3.csv results/$dir_name/class_scores_3.csv
        python log_challenge_metric.py --dir-path=results/$dir_name --lead=$lead
    elif [ $lead = "TWO" ]
    then
        python test_model.py results/$dir_name/model $test_data_2 results/$dir_name/test_outputs_2
        python evaluation-2021/evaluate_model.py $test_data_2 results/$dir_name/test_outputs_2 results/$dir_name/scores_2.csv results/$dir_name/class_scores_2.csv
        python log_challenge_metric.py --dir-path=results/$dir_name --lead=$lead
    else
        echo "NOTHING ON TRAINING"
    fi
done
