#!/usr/bin/env sh

dir="/data1/ecg"
src_train=$dir"/L12_Dataset_Train_2021"
src_test=$dir"/L12_Dataset_Test_2021"

echo "Extracting L2 Train..."
python ./extract_leads_wfdb.py -i $src_train -o $dir"/L2_Dataset_Train_2021" -l I II
echo "Extracting L3 Train..."
python ./extract_leads_wfdb.py -i $src_train -o $dir"/L3_Dataset_Train_2021" -l I II V2
echo "Extracting L4 Train..."
python ./extract_leads_wfdb.py -i $src_train -o $dir"/L4_Dataset_Train_2021" -l I II III V2
echo "Extracting L6 Train..."
python ./extract_leads_wfdb.py -i $src_train -o $dir"/L6_Dataset_Train_2021" -l I II III aVR aVL aVF

echo "Extracting L2 Test..."
python ./extract_leads_wfdb.py -i $src_test -o $dir"/L2_Dataset_Test_2021" -l I II
echo "Extracting L3 Test..."
python ./extract_leads_wfdb.py -i $src_test -o $dir"/L3_Dataset_Test_2021" -l I II V2
echo "Extracting L4 Test..."
python ./extract_leads_wfdb.py -i $src_test -o $dir"/L4_Dataset_Test_2021" -l I II III V2
echo "Extracting L6 Test..."
python ./extract_leads_wfdb.py -i $src_test -o $dir"/L6_Dataset_Test_2021" -l I II III aVR aVL aVF