#!/usr/bin/env sh

# Prerequisite: Please manually download tar.gz files from the official Physionet/Cinc challenge 2021 github webpage.
# https://physionetchallenges.github.io/2021/
# This script extracts tar.gz files from PhysioNet/CinC challenge 2021 to respective folders with proper names

if [ $# -ne 1 ]
then
    echo "One input argument required (ex ./extract_dataset.sh /data1/ecg/)"
else
    # 1
    echo "Extracting Dataset_CPSC"
    mkdir $1/Dataset_CPSC
    tar -zxf $1/WFDB_CPSC2018.tar.gz -C $1/Dataset_CPSC --strip-components 1

    # 2
    echo "Extracting Dataset_CPSC2"
    mkdir $1/Dataset_CPSC2
    tar -zxf $1/WFDB_CPSC2018_2.tar.gz -C $1/Dataset_CPSC2 --strip-components 1

    # 3
    echo "Extracting Dataset_StPetersburg"
    mkdir $1/Dataset_StPetersburg
    tar -zxf $1/WFDB_StPetersburg.tar.gz -C $1/Dataset_StPetersburg --strip-components 1

    # 4
    echo "Extracting Dataset_PTB"
    mkdir $1/Dataset_PTB
    tar -zxf $1/WFDB_PTB.tar.gz -C $1/Dataset_PTB --strip-components 1

    # 5
    echo "Extracting Dataset_PTB-XL"
    mkdir $1/Dataset_PTB-XL
    tar -zxf $1/WFDB_PTBXL.tar.gz -C $1/Dataset_PTB-XL --strip-components 1

    # 6
    echo "Extracting Dataset_Georgia"
    mkdir $1/Dataset_Georgia
    tar -zxf $1/WFDB_Ga.tar.gz -C $1/Dataset_Georgia --strip-components 1

    # 7
    echo "Extracting Dataset_ChapmanShaoxing"
    mkdir $1/Dataset_ChapmanShaoxing
    tar -zxf $1/WFDB_ChapmanShaoxing.tar.gz -C $1/Dataset_ChapmanShaoxing --strip-components 1

    # 8
    echo "Extracting Dataset_Ningbo"
    mkdir $1/Dataset_Ningbo
    tar -zxf $1/WFDB_Ningbo.tar.gz -C $1/Dataset_Ningbo --strip-components 1
fi