# Dataset setup
**혼선 방지를 위해 모든 command는 repository 최상위 폴더에서 실행하기를 권장합니다. (`ECG2021Challenge-dev2/data`의 상위 폴더인 `ECG2021Challenge-dev2` 폴더 안에서 실행)**

1. Physionet/CinC challenge 2021 데이터는 https://physionetchallenges.org/2021/ 에서 직접 다운로드 해주셔야 합니다. 해당 페이지의 'Data Access' 소제목 아래에 다운로드 링크가 있습니다. 다운받은 tar.gz 파일들의 이름은 다음과 같습니다.
```
    WFDB_CPSC2018.tar.gz        // CPSC
    WFDB_CPSC2018_2.tar.gz      // CPSC-Extra
    WFDB_StPetersburg.tar.gz    // St Petersburg
    WFDB_PTB.tar.gz             // PTB
    WFDB_PTBXL.tar.gz           // PTB-XL
    WFDB_Ga.tar.gz              // Georgia
    WFDB_ChapmanShaoxing.tar.gz // Chapman-Shaoxing
    WFDB_Ningbo.tar.gz          // Ningbo
```

2. tar.gz 파일들을 `/data1/ecg/` 아래에 넣어줍니다. 대상 폴더 명을 input argument로 하여 `extract_dataset.sh`를 실행해줍니다.
```
    $ ./data/extract_dataset.sh /data1/ecg/
```
실행 결과 `/data1/ecg/` 아래에 8개의 Dataset 폴더가 생성됩니다.
```
    Dataset_CPSC
    Dataset_CPSC2
    Dataset_Georgia
    Dataset_PTB
    Dataset_PTB-XL
    Dataset_StPetersburg
    Dataset_ChapmanShaoxing
    Dataset_Ningbo
```

3-1. `merge_sets.split_train_test.yaml` 파일을 적절히 수정하고 최상위 폴더에서 `merge_sets.split_train_test.py`를 실행합니다.
```
    $ python data/merge_sets.split_train_test.py  data/merge_sets.split_train_test.yaml
```
실행 결과 `/data1/ecg/` 아래에 `L12_Dataset_Train_2021`, `L12_Dataset_Test_2021` 폴더가 생성됩니다. `L12_Dataset_Test_2021`는 scored label을 하나 이상 포함한 sample만을 포함합니다.

3-2. `merge_sets.split_train_test_jw.yaml` 파일을 적절히 수정하고 최상위 폴더에서 `merge_sets.split_train_test_jw.py`를 실행하면 다른 방식으로 training/test set을 나눕니다.
```
    $ python data/merge_sets.split_train_test_jw.py  data/merge_sets.split_train_test_jw.yaml
```
여기서 `L12_Dataset_Test_2021`는 scored label을 하나 이상 포함한 sample만을 포함하는데, 전체 sample을 섞어서 random split하는 것이 아니라 특정 dataset에서 지정한 num_test_samples만큼 test sample을 뽑습니다.

`/data1/ecg/`(`merge_sets.split_train_test_jw.yaml`에서 `datapath`로 지정한 폴더) 아래에 `local_train_label_dist.csv`와 `local_test_label_dist.csv` 파일이 생성됩니다. 3-2의 split 방법을 적용한 후 training set과 test set에 각 label sample이 dataset별로 얼마나 많은지 기록해둔 파일입니다.

4. 최상위 폴더에서`extract_leadsets.sh`를 실행하여 12-lead dataset을 각 lead dataset으로 나누어줍니다.
```
    $ ./data/extract_leadsets.sh
```
실행 결과 `/data1/ecg/` 아래에 다음 10개의 Train/Test 폴더가 생성되고, 이 폴더들이 현 repository에서 training 및 test에 이용됩니다.
```
    L12_Dataset_Train_2021
    L6_Dataset_Train_2021
    L4_Dataset_Train_2021
    L3_Dataset_Train_2021
    L2_Dataset_Train_2021
    L12_Dataset_Test_2021
    L6_Dataset_Test_2021
    L4_Dataset_Test_2021
    L3_Dataset_Test_2021
    L2_Dataset_Test_2021
```

---

\+ Development 과정에서 코드를 실행할 때마다 preprocessing 등의 작업(`/src/data_preparation/dataset_func.py`에서 `get_data_info_dict`를 lead별로 호출)을 다시 실행하는 것을 방지하기 위해, 이 작업이 완료된 dictionary instance를 pickle 파일로 미리 저장해둘 수 있습니다. `save_preprocessed_pickle.py`파일 안의 경로를 적절히 수정한 후 최상위 폴더에서 `save_preprocessed_pickle.py`를 실행합니다.
```
    python data/save_preprocessed_pickle.py
```
실행 결과 `SAVE_DATA_DIR`로 지정해준 경로 아래에 `preprocess_data` 폴더가 생성되고, 다음 5개의 pkl 파일이 생성됩니다.
```
    TWO_simple_preprocessed_train_data_2021.pkl
    THREE_simple_preprocessed_train_data_2021.pkl
    FOUR_simple_preprocessed_train_data_2021.pkl
    SIX_simple_preprocessed_train_data_2021.pkl
    TWELVE_simple_preprocessed_train_data_2021.pkl
```