# 모델별 configuration settings 예시

### BaseResnet
```
  MODEL: "BaseResnet50"
  N_EPOCHS: 40
  N_EPOCHS_PRETRAINING: 0
  BATCH_SIZE: 128
  LEARNING_RATE: 0.1
  VALID_RATIO: 0.2
```

### ECGBert
```
  MODEL: "ECGBert"
  MODEL_CONFIG:
    conv_channel: 512
  BERT_CONFIG:
    hidden_size: 512
    num_hidden_layers: 6
    num_attention_heads: 8
    intermediate_size: 512
  N_EPOCHS: 10
  N_EPOCHS_PRETRAINING: 0
  BATCH_SIZE: 128
  LEARNING_RATE: 0.00002
  VALID_RATIO: 0.2

```
BERT_CONFIG의 경우 https://huggingface.co/transformers/model_doc/bert.html#transformers.BertConfig를 참고.

### ECGViT
```
  MODEL: "ECGViT"
  MODEL_CONFIG:
    window_length: 32
    window_stride: 24
  VIT_CONFIG: # ViT-Ti (arXiv 2106.10270 How to train your ViT)
    hidden_size: 192
    num_hidden_layers: 12
    num_attention_heads: 3
    intermediate_size: 768
  N_EPOCHS: 40
  N_EPOCHS_PRETRAINING: 0
  BATCH_SIZE: 128
  LEARNING_RATE: 0.00005
  VALID_RATIO: 0.2
```
VIT_CONFIG의 경우 https://huggingface.co/transformers/model_doc/vit.html#vitconfig를 참고.

### TimeSSLTransformer
```
  MODEL: "TimeSSLTransformer"
  MODEL_CONFIG:
    window_length: 32
    window_stride: 16
    contrastive_head_size: 256
    num_transformations: 10
    recording_projection_head_size: 256
  BERT_CONFIG:
    hidden_size: 512
    num_hidden_layers: 4
    num_attention_heads: 4
    intermediate_size: 1024
  N_EPOCHS: 10
  N_EPOCHS_PRETRAINING: 0
  BATCH_SIZE: 128
  LEARNING_RATE: 0.00002
  VALID_RATIO: 0.2
```
BERT_CONFIG의 경우 https://huggingface.co/transformers/model_doc/bert.html#transformers.BertConfig를 참고.

### With pretraining (ex SimCLR)
```
  USE_PRETRAINED_MODEL: False
  # PRETRAINED_MODEL_PATH: results/debug_now/model/6_lead_model_backbone/backbone_best.pt (USE_PRETRAINED_MODEL이 TRUE인 경우 경로 지정 필요)

  MODEL: "BaseResnet18"
  N_EPOCHS_PRETRAINING: 2
  METHOD_PRETRAINING: "SimCLR"
  BATCH_SIZE_PRETRAINING: 256
  LEARNING_RATE_PRETRAINING: 0.04
  # TEMPERATURE_PRETRAINING: 0.07 (optional)
  # PATIENCE_PRETRAINING: 30 (optional)
  # WEIGHT_DECAY_PRETRAINING: 0.0001 (optional)
  # SAVE_FREQUENCY: 10 (optional)

  N_EPOCHS: 2
  BATCH_SIZE: 128
  LEARNING_RATE: 0.007
  VALID_RATIO: 0.2
```