## To run this with docker
```
    cd ~
    mkdir ecg/ECGsubmissiontest
    cd ecg/ECGsubmissiontest
    mkdir training_data test_data model test_outputs

    (training_data, test_data 폴더에 적절한 데이터 넣어주기)

    git clone https://github.com/snu-adsl/ECG2021Challenge-submission.git

    cd ECG2021Challenge-submission
    (Dockerfile 위치에서)
    sudo docker build -t <image_name> .

    sudo docker run -it -v ~/ecg/ECGsubmissiontest/model:/physionet/model -v ~/ecg/ECGsubmissiontest/test_data:/physionet/test_data -v ~/ecg/ECGsubmissiontest/test_outputs:/physionet/test_outputs -v ~/ecg/ECGsubmissiontest/training_data:/physionet/training_data <image_name> bash

```

## 실험 환경 셋업
- 이 repository는 실험을 위한 용도입니다. Submission은 ECG2021Challenge-submit에서 진행됩니다.
- python 3.8로 실험을 진행해 주세요. Submission시엔 Dockerfile로 적합한 이미지를 만들어주도록 해야하는데, 이는 submit repository에서 처리할 예정입니다.
- 원래의 repository에 있던 파일은 다음 9개입니다: `Dockerfile`, `LISENSE`, `README.md`, `extract_leads_wfdb.py`, `helper_code.py`, `requirements.txt`, `team_code.py`, `test_model.py`, `train_model.py`
- 이 중 `train_model.py`, `test_model.py`, `helper_code.py`는 절대 변경하지 마세요. 자세한 사항은 아래 README를 참고하세요.
- `/data/` 안에서 training set, test set을 만든 후, `/`(root) 아래 symbolic link를 만들어주세요. 실행에 필요한 폴더들도 `/`(root) 아래 추가로 만들어 주세요.
```
    ln -s data/your_training_set training_data
    ln -s data/your_test_set test_data
    mkdir model test_outputs
```

## Formatter
- formatter는 black을 사용해주세요.
### 설치
```
    pip install black
```
### formatting 실행
```
    black source_code.py
```

## 실험 실행
### Training
```
    python train_model.py training_data model
```
- training_data로 모델 트레이닝
- 결과: model 폴더에 12_lead_model.pt, 2_lead_model.pt, 3_lead_model.pt, 6_lead_model.pt 생성됨.

### Test
```
    python test_model.py model test_data test_outputs
```
- 저장된 모델 model 폴더로부터 로드하여 test. 
- 결과: test_outputs 폴더에 A0001.csv, ... 등의 파일 생성

### Evaluation
```
    cd evaluation2021
    python evaluate_model.py ../test_data ../test_outputs scores.csv class_scores.csv
```
- test_data 폴더의 label들과 test_output 폴더의 prediction(binary, probability)을 비교하여 `scores.csv`, `class_scores.csv` 파일을 생성


# Python example code for the PhysioNet/Computing in Cardiology Challenge 2021

## What's in this repository?

We implemented a random forest classifier that uses age, sex, and the root mean square of the ECG lead signals as features. This simple example illustrates how to format your Python entry for the Challenge, and it should finish running on any of the Challenge training datasets in a minute or two on a personal computer. However, it is **not** designed to score well (or, more accurately, it is designed not to score well), so you should not use it as a baseline for your model's performance.

This code uses four main scripts, as described below, to train and test your model for the 2021 Challenge.

## How do I run these scripts?

You can run this classifier code by installing the requirements

    pip install requirements.txt

and running

    python train_model.py training_data model
    python test_model.py model test_data test_outputs

where `training_data` is a folder of training data files, `model` is a folder for saving your models, `test_data` is a folder of test data files (you can use the training data locally for debugging and cross-validation), and `test_outputs` is a folder for saving your models' outputs. The [PhysioNet/CinC Challenge 2021 webpage](https://physionetchallenges.org/2021/) provides training databases with data files and a description of the contents and structure of these files.

After training your model and obtaining test outputs with above commands, you can evaluate the scores of your models using the [PhysioNet/CinC Challenge 2021 evaluation code](https://github.com/physionetchallenges/evaluation-2021) by running

    python evaluate_model.py labels outputs scores.csv class_scores.csv

where `labels` is a folder containing files with one or more labels for each ECG recording, such as the training database on the PhysioNet webpage; `outputs` is a folder containing files with outputs produced by your models for those recordings; `scores.csv` (optional) is a collection of scores for your models; and `class_scores.csv` (optional) is a collection of per-class scores for your models.

## Which scripts I can edit?

We will run the `train_model.py` and `test_model.py` scripts to run your training code and testing code, so please check these scripts and the functions that they call.
Our example code uses four main scripts to train and test your model for the 2021 Challenge:

Please edit the following script to add your training and testing code:

* `team_code.py` is a script with functions for training your model and running your trained models.

Please do **not** edit the following scripts. We will use the unedited versions of these scripts.

* `train_model.py` is a script for calling your training code on the training data.
* `test_model.py` is a script for calling your trained models on the test data.
* `helper_code.py` is a script with helper variables and functions that we used for our code. You are welcome to use them in your code.

These four scripts must remain in the root path of your repository, but you can put other scripts and other files elsewhere in your repository.

## How do I train, save, load, and run my model?

To train and save your models, please edit the `training_code` function in the `team_code.py` script. Please do not edit the input arguments or output arguments of the `training_code` function.

To load and run your trained model, please edit the `load_twelve_lead_model`, `load_six_lead_model`, `load_three_lead_model`, and `load_two_lead_model` functions as well as the `run_twelve_lead_model`, `run_six_lead_model`, `run_three_lead_model` and `run_two_lead_model` functions in the `team_code.py` script, which takes an ECG recording as an input and returns the class labels and probabilities for the ECG recording as outputs. Please do not edit the input or output arguments of the functions for loading or running your models.

## What else is in this repository?

This README has instructions for running the example code and writing and running your own code.

We also included a script, `extract_leads_wfdb.py`, for extracting reduced-lead sets from the training data. You can use this script to produce reduced-lead data that you can use with your code. You can run this script using the following commands:

    python extract_leads_wfdb.py -i twelve_lead_directory -o two_lead_directory -l II V5 
    python extract_leads_wfdb.py -i twelve_lead_directory -o six_lead_directory -l I II III aVL aVR aVF 

Here, the `-i` argument gives the input folder, the `-o` argument gives the output folder, and the `-l` argument gives the leads.

## How do I run these scripts in Docker?

Docker and similar platforms allow you to containerize and package your code with specific dependencies that you can run reliably in other computing environments and operating systems.

To guarantee that we can run your code, please [install](https://docs.docker.com/get-docker/) Docker, build a Docker image from your code, and run it on the training data. To quickly check your code for bugs, you may want to run it on a subset of the training data.

If you have trouble running your code, then please try the follow steps to run the example code, which is known to work.

1. Create a folder `example` in your home directory with several subfolders.

        user@computer:~$ cd ~/
        user@computer:~$ mkdir example
        user@computer:~$ cd example
        user@computer:~/example$ mkdir training_data test_data model test_outputs

2. Download the training data from the [Challenge website](https://physionetchallenges.org/2021/#data-access). Put some of the training data in `training_data` and `test_data`. You can use some of the training data to check your code (and should perform cross-validation on the training data to evaluate your algorithm).

3. Download or clone this repository in your terminal.

        user@computer:~/example$ git clone https://github.com/physionetchallenges/python-classifier-2021.git

4. Build a Docker image and run the example code in your terminal.

        user@computer:~/example$ ls
        model  python-classifier-2021  test_data  test_outputs  training_data

        user@computer:~/example$ ls training_data/
        A0001.hea  A0001.mat  A0002.hea  A0002.mat  A0003.hea  ...

        user@computer:~/example$ cd python-classifier-2021/

        user@computer:~/example/python-classifier-2021$ docker build -t image .

        Sending build context to Docker daemon  30.21kB
        [...]
        Successfully tagged image:latest

        user@computer:~/example/python-classifier-2021$ docker run -it -v ~/example/model:/physionet/model -v ~/example/test_data:/physionet/test_data -v ~/example/test_outputs:/physionet/test_outputs -v ~/example/training_data:/physionet/training_data image bash

        root@[...]:/physionet# ls
            Dockerfile             model             test_data      train_model.py
            extract_leads_wfdb.py  README.md         test_model.py
            helper_code.py         requirements.txt  test_outputs
            LICENSE                team_code.py      training_data

        root@[...]:/physionet# python train_model.py training_data model

        root@[...]:/physionet# python test_model.py model test_data test_outputs

        root@[...]:/physionet# exit
        Exit

        user@computer:~/example/python-classifier-2021$ cd ..

        user@computer:~/example$ ls test_outputs/
        A0006.csv  A0007.csv  A0008.csv  A0009.csv  A0010.csv  ...

## How do I learn more?

Please see the [PhysioNet/CinC Challenge 2021 webpage](https://physionetchallenges.org/2021/) for more details. Please post questions and concerns on the [Challenge discussion forum](https://groups.google.com/forum/#!forum/physionet-challenges).

## Useful links

* [The PhysioNet/CinC Challenge 2021 webpage](https://physionetchallenges.org/2021/)
* [MATLAB example code for the PhysioNet/CinC Challenge 2021](https://github.com/physionetchallenges/matlab-classifier-2021)
* [Evaluation code for the PhysioNet/CinC Challenge 2021](https://github.com/physionetchallenges/evaluation-2021)
* [Frequently Asked Questions (FAQ)](https://physionetchallenges.org/faq/)
