%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% team_testing_code
%%% Apply classifier model to test set
%%%
%%% Inputs: ...
%%%
%%% Outputs: ...
%%%
%%% Author:  Santiago Jiménez-Serrano [sanjiser@upv.es]
%%% Version: 1.0
%%% Date:    2020-03-26
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [score, labels, classes] = team_testing_code(data, header_data, loaded_model)

    model    = loaded_model.model;
    classes  = loaded_model.classes;
    mu       = loaded_model.mu;
    sigma    = loaded_model.sigma;
    medianas = loaded_model.medianas;

    num_classes = length(classes);
    labels      = zeros(1, num_classes);
    score       = zeros(1, num_classes);
    gs          = zeros(1, num_classes);

    %% Extract features from test data
    tmp_hea   = strsplit(header_data{1},' ');
    num_leads = str2num(tmp_hea{2});
    [leads, leads_idx] = get_leads(header_data,num_leads);
    features = get_features(data, header_data, leads_idx);
    
    %% Fill the NaN values with the median
    nan_idx = isnan(features);
    features(nan_idx) = medianas(nan_idx);
    
    %% Appy the z-score
    features=bsxfun(@minus,   features, mu);
    features=bsxfun(@rdivide, features, sigma);

    %% Use your classifier here to obtain a label and score for each class.

    % Debug...
    %%% test_features_size = size(features);
    %%% size(model);

    %score = mnrval(model,features);
    parfor i = 1 : length(model)
        
        % userdata(1) => threshold
        % userdata(2) => g value
        
        gs(i) = model{i}.userdata.ths(2);
        
        %if gs(i) > 0.55
        %if gs(i) > 0.70           
            score(i) = model{i}(features(:, model{i}.userdata.features_idx)', 'useGPU', 'no');
            %score(i) = model{i}(features', 'useGPU', 'no');

            if score(i) >= model{i}.userdata.ths(1)
                labels(i) = 1;
            end

            if score(i) < -1
                score(i) = -1;
            end
            if score(i) > 1
                score(i) = 1;
            end
            score(i) = (score(i)+1)/2;
        %end
        
    end
    
    % Perform some positive class filtering
%     gss = gs(labels==1);
%     if length(gss) > 5
%         s  = sort(gss, 'descend');
%         th = s(5);
%         labels(labels == 1 & gs < th) = 0;
%     end
    

    
end
