%% Apply classifier model to test set

function [score, label_opt,classes] = team_testing_code(data,header_data, loaded_model)

addpath(genpath('dev/'))

% Extract features from test data
tmp_hea = strsplit(header_data{1},' ');
num_leads = str2num(tmp_hea{2});
[leads, leads_idx] = get_leads(header_data,num_leads);
[features,lea] = get_features(data,header_data,leads_idx,leads);
empties = cellfun('isempty',features);
features(empties) = {NaN};
features = cell2mat(features);


n_lea = sum( ismember(string(lea),"1") );
n_global = sum( ismember(string(lea),"0") );
if(length(features) < (num_leads*n_lea+n_global)) %if not enough features, only use global (sex, ...) and set others to nan
    features = [nan(1,num_leads*n_lea+n_global-1) features((end-n_global+1):end)];
elseif(length(features) > (num_leads*n_lea+n_global)) %if too many features, only use features, that belong to respective leads
    Features_leads_idx = ismember(string(lea),string(leads_idx)) | ismember(string(lea),"0");
    features = features(:,Features_leads_idx);
end
classes = loaded_model.classes;


% impute missing values
features(isinf(features)) = nan;


% make predictions
model = loaded_model.model;
[label, label_opt, score] = predict_boosted_decision_tree_ensemble(model, ...
                                                                        features, ...
                                                                        classes);
end