%% Parameters for decision tree ensemble
dte_parameters = struct();
dte_parameters.n_splits = 10;
dte_parameters.n_learners = 1000;
dte_parameters.learn_rate = 0.1;
% dte_parameters.hyper_pars = {'NumLearningCycles', 'MinLeafSize'};
dte_parameters.hyper_pars = {'none'};
dte_parameters.perform_pca = true;
dte_parameters.method = 'AdaBoostM1'; % Possible 'Method': AdaBoostM1, LogitBoost, RUSBoost
dte_parameters.cost_amp = 1;

%% Parameters for second/top classifier
cls_second_parameters = struct();


%% FEATURES TO INCLUDE
% metrics = {'mean',
%     'median',
%     'min',
%     'max',
%     'std'
%     };

% leads = {
%     'I',
%     'II',
%     'III',
%     'aVR',
%     'aVL',
%     'aVF',
%     'V1',
%     'V2',
%     'V3',
%     'V4',
%     'V5',
%     'V6'
%     };


features_numerical_base = {
    'NumBeats'          ,
    'Gain'
    };
features_numerical_HRV = {
    'HRV_filtRate'      ,
    'HRV_meanRR'        ,
    'HRV_medianRR'      ,
    'HRV_minRR'         ,
    'HRV_maxRR'         ,
    'HRV_SDRR'          ,
    'HRV_RMSSD'         ,
    'HRV_SDSD'          ,
    'HRV_RRV'           ,
    'HRV_pNN50'         ,
    'HRV_NN50'          ,
    'HRV_tri'           ,
    'HRV_TINN'          ,
    'HRV_SD1'           ,
    'HRV_SD2'           ,
    'HRV_SD1SD2ratio'   ,
    'HRV_pLF'           ,
    'HRV_pHF'           ,
    'HRV_LFHFratio'     ,
    'HRV_VLF'           ,
    'HRV_LF'            ,
    'HRV_HF'            ,
    'HRV_ApEn'          ,
    'HRV_DFA1'          ,
    'HRV_DFA2'
    };
features_numerical_SQI = {
    'SQI_bas'           ,
    'SQI_k'             ,
    'SQI_p'             ,
    'SQI_r'             ,
    'SQI_s'             ,
    'SQI_std'           ,
    'SQI_x'
    };
features_numerical_QTV = {
    'QTV_meanQT'        ,
    'QTV_medianQT'      ,
    'QTV_minQT'         ,
    'QTV_maxQT'         ,
    'QTV_SDQT'          ,
    'QTV_STVQT'         ,
    'QTV_LTVQT'         ,
    'QTV_QTV'           ,
    'QTV_QTVi'          ,
    'QTV_cSDQT'         ,
    'QTV_cQTV'          ,
    'QTV_cQTVi'
    };
features_numerical_Template = {
    'Template_clDiff'   ,
    'Template_clSize1'  ,
    'Template_Isolevel1',
    'Template_PQint1'   ,
    'Template_QRSint1'  ,
    'Template_QTint1'   ,
    'Template_PQamp1'   ,
    'Template_QRSamp1'  ,
    'Template_Tamp1'    ,
    'Template_clSize2'  ,
    'Template_Isolevel2',
    'Template_PQint2'   ,
    'Template_QRSint2'  ,
    'Template_QTint2'   ,
    'Template_PQamp2'   ,
    'Template_QRSamp2'  ,
    'Template_Tamp2'    
    };
features_numerical_others = {
    'Others_numPeaks'   ,
    'Others_numPMStrokes',
    'Others_heightPeaksMean',
    'Others_heightPeaksMedian',
    'Others_heightPeaksKurtosis'
    };
features_numerical = [
    features_numerical_base,
    features_numerical_HRV,
    features_numerical_SQI,
    features_numerical_QTV,
    features_numerical_Template,
    features_numerical_others
    ];
% features_numerical_add = [
%     features_numerical_HRV,
%     features_numerical_QTV
%     ];
% features_numerical_add = features_numerical_add' + "_" + metrics;
% features_numerical_add = reshape(features_numerical_add,[],1);
% features_numerical_add = cellstr(features_numerical_add);

features_categorical = {
    };

features_numerical_global = {
    'TotalTime'         ,
%    'NumWindows'        ,
%    'SamplFreq'         ,
    'Age'
    };

features_categorical_global = {
    'Sex'
    };