%% Anlayse Starter
clearvars

% Lade Start-Parameter
parameterSTART
% Lade 2DSW Parameter
parameter2DSW

SParameter.downsample = NaN;
SParameter.upsample = NaN;
AParameter.multiChannel = 0;
SParameter.convChannel = 2;

WParameter.signal_min = 1;
WParameter.signal_max = 0;

AParameter.Plot = 0;
AParameter.Print = 0;
AParameter.PrintOut = 0;
AParameter.Statistik.save2csv = 0;
AParameter.Statistik.save2mat = 2;

AParameter_init = AParameter;

% change this to where the network drive is mounted
data_dir = fullfile('..', '..', '..', 'tmp', 'uncompressed');
% change this to where you want to save the output data (using network
% drive needs matlab to have writing permission!)
output_dir = fullfile('..', '..', '..', 'tmp', 'preprocessed');

dbs_dir = dir(data_dir);

for db=3:length(dbs_dir) % browse through different databases
    db_folders = dir(fullfile(dbs_dir(db).folder, dbs_dir(db).name));
    
    for dbf=3:length(db_folders) % browse through different folders of each database (usually has only one)
        AParameter.DataDir = [fullfile(db_folders(dbf).folder, db_folders(dbf).name) dsd];
        AParameter.output_folder = fullfile(output_dir, dbs_dir(db).name);
        data_files = dir(fullfile(AParameter.DataDir, AParameter.DataModeParameter.m_subfolder{1}, ['*' AParameter.DataModeParameter.m_subname{1} '.' AParameter.DataModeParameter.m_ext{1}]));
        
        mkdir(AParameter.output_folder);
        
        parfor i=1:length(data_files) % browse through different records of each database folder (do this in parallel threads)            
            % create copies of relevant vars for each worker
            sp = SParameter;
            ap = AParameter;
            wp = WParameter;
            
            name = split(data_files(i).name, '.');
            fn = [name{1} '_features' '.mat'];
            output_file = fullfile(AParameter.output_folder, fn);
            
            output = struct();
            
            for j=1:12
                sp.convChannel = j;
                sp.Channel = j;
                
                try
                    [EMed,EParameter] = WarpSTART(fullfile(ap.DataDir, data_files(i).name),wp,ap,sp);
                    output.(EParameter.Lead) = EParameter;
                    output.labels = EMed;
                catch ex
                    display([data_files(i,:).name '_ch' num2str(sp.Channel) ': ' getReport(ex)])
                end
            end
            
            parsave(output_file, output);
            
            disp(i/length(data_files)); % approximation for the progress (parfor runs somewhat arbitrary)
            disp(fullfile(data_files(i).folder, data_files(i).name));
        end
    end
end