function [predictions, predictions_opt, scores, scored_labels] = predict_boosted_decision_tree_ensemble(classifier, ...
                                                                        X, ...
                                                                        scored_labels)%, ...
%                                                                         var_names)
    if nargin < 3 || isempty(scored_labels)
        scored_labels = string({classifier(:).dx});
    end

%     X = array2table(X, 'VariableNames', var_names);
    predictions = zeros(size(X, 1), length(scored_labels));
    predictions_opt = zeros(size(X, 1), length(scored_labels));
    %scores = zeros(size(X, 1), length(scored_labels), 2);
    scores = zeros(size(X,1), length(scored_labels));
    
    for i=1:length(scored_labels)
        j = find(string({classifier(:).dx})==scored_labels{i}); 
        if isempty(j)
            error('Error in trained classifier(i).dx and related scored_labels(j)');
        end
        
%        [y, sc] = classifier(i).branch.predictFcn(X);
%        if classifier(i).branch
%         T = size(classifier(j).branch.Trained,1); %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        T = size(classifier(j).model,1);
        y = zeros(T,1);
        sc = zeros(T,2);
        for t = 1:T
%             [y(t), sc(t,:)] = predict(classifier(j).branch.Trained{t}, X); %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            [y(t), sc(t,:)] = predict(classifier(j).model{t}, X);
        end
%        [y, sc] = kfoldPredict(classifier(i).branch);

        predictions(:, i) = median(y);
        %scores(:, i, :) = mean(sc,1);
        scores(:,i) = mean(sc(:,2));
%         predictions_opt(:, i) = mean(sc(:,2),1) > classifier(j).result.th_opt; %%%%%%%%%%%%%%%%%%%%%%
%         predictions_opt(:, i) = median(sc(:,2) > classifier(j).result.th_opt); %%%%%%%%%%%%%%%%%%%%%%
%         predictions_opt(:, i) = mean(sc(:,2),1) > classifier(j).th_opt; %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        predictions_opt(:, i) = median(sc(:,2) > classifier(j).th_opt);
    end
end