function classifier = fit_dt_main(features, label, classes, feat_names)
%% Preprocess the featureset
% find samples with feature vector containing only NaN
rows = find(sum(isnan(features), 2) == size(features, 2));
features(rows, :) = [];
label(rows, :) = [];


%% Set vars
categorical_var_names = {'Sex'};


%% Perform grid search



%% Set hyperparamters
% apply a custom misclassification cost
use_cost = false;
% set the parameters for the boosted decision tree ensemble
dte_parameters = struct();
dte_parameters.stratified_string = 'Holdout'; % 'Holdout' or 'KFold'
dte_parameters.stratified_numeric = 0.1; % e.g.: 0.3 or 4
% dte_parameters.stratified_string = 'KFold'; % 'Holdout' or 'KFold'
% dte_parameters.stratified_numeric = 3; % e.g.: 0.3 or 4
dte_parameters.method = 'LogitBoost';
dte_parameters.n_splits = 4; %4 %2
dte_parameters.n_learners = 256; %256 %49
dte_parameters.learn_rate = 0.1; %0.1
dte_parameters.numBins = 256; %256 %50
%dte_parameters.cost_amp = 2;


%% Train classifier
classifier = fit_boosted_decision_tree_ensemble(...
    features, ...
    label, ...
    classes, ...
    use_cost, ...
    categorical_var_names, ...
    feat_names, ...
    dte_parameters);

for i = 1:length(classes)
    classifier(i).th_opt = classifier(i).result.th_opt;
    classifier(i).model = classifier(i).branch.Trained;
end

classifier = rmfield(classifier, {'result','branch'});

% %% Predict classifier
% preds = zeros(size(features, 1), length(classes));
% preds_opt = zeros(size(features, 1), length(classes));
% scores = zeros(size(features, 1), length(classes), 2);
% 
% for i=1:length(classes)
% 
%     if classes{i} ~= classifier(i).dx
%         error('Error in trained classifier(i).dx and related scored_labels(i)');
%     end
% 
%     [y, sc] = kfoldPredict(classifier(i).branch);
% 
%     preds(:, i) = y;
%     scores(:, i, :) = sc;
%     preds_opt(:, i) = sc(:,2) > classifier(i).result.th_opt;
% 
%     classifier(i).kfoldpredict = struct();
%     classifier(i).kfoldpredict.preds = preds;
%     classifier(i).kfoldpredict.preds_opt = preds_opt;
%     classifier(i).kfoldpredict.scores = scores;
%     classifier(i).kfoldpredict.targets = label(:, i);
% end
% 
% % classifier = rmfield(classifier, {'result','kfoldpredict'});



% result.perf = perform(trainedClassifier, y.', y_out);
% result.cm = confusionmat(y.', y_out);
% result.prec = result.cm(2,2) / (result.cm(2,2) + result.cm(1,2));
% result.rec = result.cm(2,2) / (result.cm(2,2) + result.cm(2,1));
% result.f1 = 2 * (result.prec * result.rec) / (result.prec + result.rec);
% fprintf('TH: %1.3f <<>> Performance: %1.3f <<>> Precision: %1.3f <<>> Recall: %1.3f <<>> F1 Score: %1.3f\n', th_final, result.perf, result.prec, result.rec, result.f1);
end
