function [ AParameter, SParameter, WParameter ] = updateTemplate(AParameter, SParameter, WParameter)

AParameter.template_update = 1;
TempTHR = WParameter.WarpTHR;
TempxSegAnz = WParameter.xSegAnz;
TempySegAnz = WParameter.ySegAnz;
Tempsave2csv = AParameter.Statistik.save2csv;

WParameter.xSegAnz = round(WParameter.xSegAnz*2);
WParameter.ySegAnz = round(WParameter.ySegAnz*2);
WParameter.WarpTHR=0;
AParameter.Statistik.save2csv=0;

[BeatTemplate, AParameter] = generateTemplateTDE(SParameter.ecgSignal,SParameter.Annotation,SParameter.RLocation,SParameter.RR,AParameter, SParameter);

% Warp init Template to New
SParameter.Template.newTemplate = BeatTemplate;
EParameter = WarpQT(AParameter, SParameter, WParameter);

if or(SParameter.Template.UpdateRefMode == 2,SParameter.Template.UpdateRefMode  == 3)
    if EParameter.SParameter.SignalZVBegin < 1
        euclDisTempStart = -1*EParameter.SParameter.SignalZVBegin + 2;
    else
        euclDisTempStart = 1;
    end
    
    if EParameter.SParameter.SignalZVEnd < length(EParameter.SParameter.SignalBeat)
        if EParameter.SParameter.SignalZVBegin < 1
            euclDisTempEnd = EParameter.SParameter.SignalZVEnd + euclDisTempStart - 1;
        else
            euclDisTempEnd = EParameter.SParameter.SignalZVEnd - EParameter.SParameter.SignalZVBegin + 1;
        end
    else
        euclDisTempEnd = length(EParameter.SParameter.SignalBeat) - EParameter.SParameter.SignalZVBegin + 1;
    end
    BeatTemplate = EParameter.SParameter.SignalZV(euclDisTempStart:euclDisTempEnd);
    if EParameter.SParameter.SignalZVBegin > 0
        WarpQX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeQ)) - EParameter.SParameter.SignalZVBegin + 1;
        WarpQXRoundError = abs(WarpQX - ((EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeQ)) - EParameter.SParameter.SignalZVBegin + 1));
        WarpSX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeS)) - EParameter.SParameter.SignalZVBegin + 1;
        WarpSXRoundError = abs(WarpSX - ((EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeS)) - EParameter.SParameter.SignalZVBegin + 1));
        WarpRX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeR)) - EParameter.SParameter.SignalZVBegin + 1;
        WarpRXRoundError = abs(WarpRX - ((EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeR)) - EParameter.SParameter.SignalZVBegin + 1));
        WarpTendX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTEnd)) - EParameter.SParameter.SignalZVBegin + 1;
        WarpTendXRoundError = abs(WarpTendX - ((EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTEnd)) - EParameter.SParameter.SignalZVBegin + 1));
        WarpTpeakX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTPeak)) - EParameter.SParameter.SignalZVBegin + 1;
        WarpTpeakXRoundError = abs(WarpTpeakX - ((EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTPeak)) - EParameter.SParameter.SignalZVBegin + 1));
    else
        WarpQX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeQ));
        WarpQXRoundError = abs(WarpQX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeQ)));
        WarpSX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeS));
        WarpSXRoundError = abs(WarpSX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeS)));
        WarpRX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeR));
        WarpRXRoundError = abs(WarpRX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeR)));
        WarpTendX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTEnd));
        WarpTendXRoundError = abs(WarpTendX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTEnd)));
        WarpTpeakX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTPeak));
        WarpTpeakXRoundError = abs(WarpTpeakX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTPeak)));
        
    end
else
    WarpQX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeQ));
    WarpQXRoundError = abs(WarpQX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeQ)));
    WarpSX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeS));
    WarpSXRoundError = abs(WarpSX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeS)));
    WarpRX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeR));
    WarpRXRoundError = abs(WarpRX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeR)));
    WarpTendX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTEnd));
    WarpTendXRoundError = abs(WarpTendX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTEnd)));
    WarpTpeakX = round(EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTPeak));
    WarpTpeakXRoundError = abs(WarpTpeakX - (EParameter.SParameter.SignalMatrix(1,EParameter.SParameter.SignalMatrix(4,:)==EParameter.AParameter.PunktCodeTPeak)));
    
end
if SParameter.Template.debugPlot
    h = figure;
    title([strrep(SParameter.PlotPrefix,'_','\_') ' ' num2str(SParameter.Template.Begin) ' ' num2str(SParameter.Template.Quality)])
    hold on
    plot(BeatTemplate)
    plot(WarpQX,BeatTemplate(WarpQX),'o')
    plot(WarpRX,BeatTemplate(WarpRX),'o')
    plot(WarpSX,BeatTemplate(WarpSX),'o')
    plot(WarpTendX,BeatTemplate(WarpTendX),'o')
    plot(WarpTpeakX,BeatTemplate(WarpTpeakX),'o')
end
if AParameter.Print
    export_fig([SParameter.PlotPrefix '_' num2str(SParameter.Template.Nr) '.png'])
    close(h)
end

% dynamisch
% Warp old Template to New
if SParameter.Template.UpdateRefMode  == 1
    SParameter.InitBeatTemplate = BeatTemplate;
    SParameter.InitRefs = [WarpQX WarpRX WarpSX WarpTpeakX WarpTendX];
elseif SParameter.Template.UpdateRefMode  == 3
    SParameter.InitBeatTemplate = BeatTemplate';
    SParameter.InitRefs = [WarpQX WarpRX WarpSX WarpTpeakX WarpTendX];
end

% Wiederherstellen
WParameter.WarpTHR = TempTHR;
WParameter.xSegAnz = TempxSegAnz;
WParameter.ySegAnz = TempySegAnz;
AParameter.Statistik.save2csv = Tempsave2csv;

SParameter.Templates(SParameter.Template.Nr).BeatTemplate = BeatTemplate';
SParameter.Templates(SParameter.Template.Nr).Refs = SParameter.Refs;
SParameter.Templates(SParameter.Template.Nr).GenPar = SParameter.Template;
SParameter.Templates(SParameter.Template.Nr).RoundingErrors = [WarpQXRoundError WarpRXRoundError WarpSXRoundError WarpTendXRoundError WarpTpeakXRoundError];

SParameter.BeatTemplate = BeatTemplate';
SParameter.Refs = [WarpQX WarpRX WarpSX WarpTpeakX WarpTendX; double(unicode2native('Q')) double(unicode2native('R')) double(unicode2native('S')) double(unicode2native('P')) double(unicode2native('T'))];

% Initialisierung
% Initialisierung des Templates
dref = SParameter.BeatTemplate;%cell2mat(Signals(3))/10;
SParameter.Signal = dref - min(dref); % Template
SParameter.Signal = SParameter.Signal';
SParameter.Signal_max = max(SParameter.Signal);

% Lngenskalierung anhand der xSegemente
if WParameter.SegMode == 0
    % Lngenskalierung anhand der xSegemente
    if rem(length(SParameter.Signal),WParameter.xSegAnz)
        SParameter.Refs(1,:) = round(SParameter.Refs(1,:)*(length(SParameter.Signal)+WParameter.xSegAnz-rem(length(SParameter.Signal),WParameter.xSegAnz))/length(SParameter.Signal));
        SParameter.Signal = resample(SParameter.Signal,length(SParameter.Signal)+WParameter.xSegAnz-rem(length(SParameter.Signal),WParameter.xSegAnz),length(SParameter.Signal));
    end
end
WParameter.xLength = length(SParameter.Signal);

% Hhenanpassung anhand der ySegemente
WParameter.yLength = round(max(SParameter.Signal) * 1.2);
if rem(WParameter.yLength,WParameter.ySegAnz)
    WParameter.yLength = WParameter.yLength + (WParameter.ySegAnz - rem(WParameter.yLength,WParameter.ySegAnz));
end

SParameter.Signal = SParameter.Signal + (WParameter.yLength - SParameter.Signal_max)/2;

% Init Segments
[WParameter] = initSegments(AParameter, SParameter, WParameter);

WParameter.anzWarpingPoints = (WParameter.xSegAnz + 1) * (WParameter.ySegAnz + 1);

% Init Points Matrix
WParameter = initPointsMatrix(WParameter);

% Init WarpingPoints Matrix
WParameter = initWarpingPointsMatrix(WParameter);

% WarpingPoint <-> Slack Zuordnung
WParameter.dxMatrix = zeros(WParameter.xSegAnz+1,2);
WParameter.dyMatrix = zeros(WParameter.ySegAnz+1,2);
WParameter.dxMatrix(:,1) = [WParameter.xSlack; WParameter.xSlack(WParameter.xSegAnz)];
WParameter.dxMatrix(:,2) = [-WParameter.xSlack(1); -WParameter.xSlack];
WParameter.dyMatrix(:,1) = [WParameter.ySlack; WParameter.ySlack(WParameter.ySegAnz)];
WParameter.dyMatrix(:,2) = [-WParameter.ySlack(1); -WParameter.ySlack];

% SParameter.SignalMatrix
SParameter.SignalMatrixInit = [0:WParameter.xLength-1;SParameter.Signal;zeros(1,WParameter.xLength);zeros(1,WParameter.xLength)];
% Original Backup
SParameter.SignalMatrixbakInit = [0:WParameter.xLength-1;SParameter.Signal;zeros(1,WParameter.xLength)];

% SpezialPunktKodierungen
AParameter.PunktCodeTEnd = unicode2native('T');
AParameter.PunktCodeQ = unicode2native('Q');
AParameter.PunktCodeS = unicode2native('S');
AParameter.PunktCodeR = unicode2native('R');
AParameter.PunktCodeTPeak = unicode2native('T')+unicode2native('P');

% SpezialPunkte setzen
SParameter.SignalMatrixInit(4,SParameter.Refs(1,1)) = AParameter.PunktCodeQ;
SParameter.SignalMatrixInit(4,SParameter.Refs(1,2)) = AParameter.PunktCodeR;
SParameter.SignalMatrixInit(4,SParameter.Refs(1,5)) = AParameter.PunktCodeTEnd;
SParameter.SignalMatrixInit(4,SParameter.Refs(1,3)) = AParameter.PunktCodeS;
SParameter.SignalMatrixInit(4,SParameter.Refs(1,4)) = AParameter.PunktCodeTPeak;

% Segmentzuordung
for i=1:WParameter.xSegAnz
    for j=1:WParameter.ySegAnz
        SParameter.SignalMatrixInit(3,WParameter.WarpingPointsInit(1,i,1)+1:WParameter.WarpingPointsInit(1,i+1,1)) = SParameter.SignalMatrixInit(3,WParameter.WarpingPointsInit(1,i,1)+1:WParameter.WarpingPointsInit(1,i+1,1)) + and(SParameter.SignalMatrixInit(2,WParameter.WarpingPointsInit(1,i,1)+1:WParameter.WarpingPointsInit(1,i+1,1)) < WParameter.WarpingPointsInit(j+1,1,2),SParameter.SignalMatrixInit(2,WParameter.WarpingPointsInit(1,i,1)+1:WParameter.WarpingPointsInit(1,i+1,1)) > WParameter.WarpingPointsInit(j,1,2))*(i+(j-1)*WParameter.xSegAnz);
    end
end

AParameter.template_update = 0;

end

