% function [positionalignment,template_out,c_koeff_vektor,not_aligned,template_before,zaehler]=tde_fest(positions,signal,l,template_width)
%

function [positionalignment,template_out,mediandiffer,template_before,zaehler]=tde_mod(positions,signal,l,template_width,samp_rate,window,RRmedian)

% Diese Funktion fhrt die TDE mit festen Signalfenstern durch.
%
% In:   positions ... Vektor der ursprnglichen Annotationen
%       signal ... Vektor der Signalamplituden
%       l ... Fensterbreite des Signalausschnitts in samples
%       template_width ... feste Fensterbreite des Templates in ms fr
%       sanples
%       samp_rate ... Abtastrate
%       window ... Finales Fenster fr das Template anhand RRmedian
%       RRmedian ... Medianes RR-Intervall in samples fr beatwindow Funktion
%       
%
% Out:  positionalignment ... Vektor der neuen, ausgerichteten Annotationen
%       template_out ... Template aller betrachteten Schlge nach TDE
%       c_koeff_vektor ... Vektor der Korr.koeff zwischen Template und Signal
%       not_aligned ... Index der unvernderten Annotationen
%       template_before ... Template aller betrachteten Schlge vor der TDE
%       zaehler ... Anzahl der Iteration zum Erreichen der Abbruchbedingung
%
% 19-07-09, Martin Schmidt

signal = cast(signal,'double');
%tic
%% Einstellung der Parameter

%% Startwertvorgaben und hnliches

% bergabe der ursprnglichen Annotationen
org_pos=positions;

% Zhlparameter fr den Fall, dass die Kreuzkorr. zw. Signal und Template
% an mehreren Stellen maximal wird
tester=0;

% Initalisierung des time-delay-Vektors
d=zeros(1,length(positions));

% Vektor fr in vorheriger Schleife berechneter delay
d_xcorr_ausgabe=zeros(1,length(positions));
c_xcorr_ausgabe=zeros(1,length(positions));

% d mit beliebigen Werten grer 2 vorbelegen, damit die
% Konvergenz-Schleife korrekt ausgefhrt werden kann
d=d+10;

% Initialisierung des Kreuz-Korrelationsvektors mit den maximalen
% Korrelationen zw. Template und aktuellem Signal
c_vektor=zeros(1,length(positions));

% Abbruch-Bedingung fr die Konvergenz-Schleife. Ist der Mittelwert aller
% Ausrichtungen der Annotationen grer als abbr_bed, so wird weiter
% ausgerichtet
abbr_bed=0;

% Start-Belegung von meanr mit beliebigem Wert grer gleich abbr_bed, damit
% Konvergenz-Schleife starten kann
meand=abbr_bed+5;

% Zhler fr Iterationen
zaehler=0;

% Zhler fr maximale Verschiebungen
%maxd_zaehler=[];

% Matrix fr Signalausschnitte
curr_sig=zeros(length(positions),l+1);

RRmedian = round(RRmedian);
[window_start, window_end, ndim] = beatwindow(RRmedian,2*RRmedian,samp_rate,window);
window_start = round(window_start);
window_end = round(window_end);
template_ecg_witdh = window_end - window_start + 1;
template_pre_off = RRmedian-window_start;
template_post_off = window_end-RRmedian;
curr_sig2=zeros(length(positions),template_ecg_witdh);


%% Template vor TDE berechnen
%template erzeugen
template_before=zeros(1,template_ecg_witdh);

for j=1:length(positions)
    
    % wenn die Annotation existiert, wird sie bercksichtigt
    if ~isnan(positions(j));
        
        % Erzeugung eines Templates im Bereich um die Annotation
        % (Annotation befindet sich in der Mitte des Templates
        template_before=template_before+signal(positions(j)-template_pre_off:positions(j)+template_post_off);
    end
end
template_before=template_before/(length(find(~isnan(positions))));


% Schleife fr Konvergenzprfung, die beendet wird, wenn die
% Abbruchbedingung (meand < abbr_bed) erfllt ist.
while meand > abbr_bed
    
    % Inkrementierung des Iterationszhlers
    zaehler=zaehler+1;
    
    %t0=tic;
    % uere Schleife ber alle Annotationen (=positions)
    for i=1:length(positions)
        
        % Initialisierung des Templates. Das Template muss in jeder
        % Schleife neu berechnet werden
        template=zeros(1,template_width+1);
        
        %t1=tic;
        %% Template gemittelt ber alle Fenster, auer dem aktuellen (steht so im paper...)
        % for-Schleife zur Erzeugung des Templates --> durch eigene Befehle
        % ersetzt worden
        %         for j=1:length(positions)
        %
        %             % hier wird der aktuelle Signalabschnitt ausgeschlossen
        %             if j~=i;
        %                 % Erzeugung eines Templates im Bereich um die Annotation
        %                 % (Annotation befindet sich in der Mitte des Templates
        %                 template=template+signal(positions(j)-floor(template_width/2):positions(j)+floor(template_width/2));
        %
        %             end
        %         end
        
        % Template-Zeitwerte finden
        template_anfang=positions(:)-floor(template_width/2);
        template_matrix=repmat(template_anfang, [1 template_width+1]);
        inc_folge=0:1:template_width;
        inc_matrix=repmat(inc_folge,[length(positions) 1]);
        template_punkte= inc_matrix + template_matrix;
        
        % Template Signalwerte bestimmen...
        template_werte=signal(template_punkte);
        % ...und aufsummieren
        template_sum=sum(template_werte,1)-signal(positions(i)-floor(template_width/2):positions(i)+floor(template_width/2));
        
        % Template-Mittelung abschlieen durch Division der Anzahl der
        % Templates
        template=template_sum/(length(positions)-1);
        %toc(t1);
        
        %% Verschiebung durch maximale Korrelation berechnen
        
        % weil l und template_width nicht die gleiche Lnge haben,
        % wrde bei der Kreuzkorrelation ein zero-padding am Ende eines
        % der Fenster durchgefhrt werden und die Annotation nicht mehr
        % in der Mitte des jeweiligen Fensters sein. Dewegen werden
        % manuell Nullen am Anfang und Ende des Templates angehngt, damit
        % die Fenster gleich lang werden.
        
        % Differenz zwischen Breite des Templates und aktuellem
        % Signalfenster
        fenster_diff=l-template_width;
        
        % Erweiterung und Ausgabe des aktuellen Templates
        template=[zeros(1,fenster_diff/2) template zeros(1,fenster_diff/2)];
        
        % Zuweisung des aktuellen Signalauschnittes in die Matrix der
        % Signalauschnitte. Passiert nur im ersten Iterations-Schritt vor
        % der Ausrichtung.
        if zaehler==1
            curr_sig(i,:)=signal(positions(i)-l/2:positions(i)+l/2);
            curr_sig2(i,:)=signal(positions(i)-template_pre_off:positions(i)+template_post_off);
        end
        
        % Kreuzkorrelation von aktuellem Template und aktuellem
        % Signalabschnitt. Ausgabe der Korrelation(skoeffizienten) (=c)
        % und Verschiebung (=lags); Bereiche an den Rndern (ohne volle
        % Abdeckung) des Templates bleiben unbercksichtigt, Nullen
        % werden dabei nicht zum Template gezhlt (maxlags=fenster_diff/2)
        [c,lags]=xcorr(template,curr_sig(i,:),fenster_diff/2);
        
        maxima=find(c==max(c));
        % existieren mehrere gleich groe Maxima, wird das erste
        % ausgewhlt
        if length(maxima)>1
            new_max=find(lags(maxima)~=0);
            n=new_max;
            n=maxima(1);
            % Diese Variable zhlt, wie oft mehrere Maxima
            % auftraten
            tester=tester+1;
        else
            n=maxima;
        end
        
        % In der festen Schleife muss immer die Vorgngerverschiebung
        % mitgenomen werden, damit die Neuausrichtung korrekt
        % ausgefhrt wird.
        if zaehler==1
            delay=lags(n);
        else
            delay=lags(n)-d_xcorr_ausgabe(i);
        end
        
        d_xcorr_ausgabe(i)=lags(n);
        
        % Verschiebung der Annotation um den entsprechenden delay, wenn
        % Korr. grer als vorher.
        
        if max(c)>c_xcorr_ausgabe(i)
            positions(i)=positions(i)-delay;
            
            % bergabe des delays an den time-delay-Vektor
            d(i)=delay;
            
            % bergabe der Maximalen Korr. an Korr.vektor (auch bei zu
            % geringer Korr.)
            c_vektor(i)=max(c);
            % Ansonsten wird der aktuelle delay auf Null gesetz
        else
            d(i)=0;
        end
        c_xcorr_ausgabe(i)=max(abs(c));
    end
    
    % Mittelwert aller delays berechnen --> Konvergenzprfung am Anfang der
    % Schleife
    if zaehler <10
        meanc = mean(c_xcorr_ausgabe);
        meand = mean(abs(d));
    else
        meand=0;
    end
    
end

%disp(maxd_zaehler);

% Prfen, ob Ausrichtung die Annotation zu weit weg verschoben hat
differ=abs(org_pos-positions);
diff=differ>100;

% Positionen mit zu groer Differenz zur ursprnglichen Anno zurcksetzen
positions(diff)=NaN;

not_aligned=[diff];

%% neue Positionen ausgeben
% Zusammenfgen des Annotationsvektors aus ausgerichteten Annotationen nach
% TDE und unvernderten originalen Annotationen an den nicht ausgerichteten
% Stellen
org_pos(~isnan(positions))=0;
positions(isnan(positions))=0;

% Ausgabe des neuen Annotationsvektors
positionalignment=positions+org_pos;
%toc

%% Neu Korrektur der Grenzen
mediandiffer = round(median(differ));
if mediandiffer > 10
    mediandiffer = mod(mediandiffer,15);
end
template_pre_off = template_pre_off + mediandiffer;
template_post_off = template_post_off - mediandiffer;

%% Template Neuberechnung
%template erzeugen
template_out=zeros(1,template_ecg_witdh);
countern = 0;
for j=1:length(positionalignment)
    
    % wenn die Annotation existiert, wird sie bercksichtigt
    if ~isnan(positionalignment(j));
        
        % Erzeugung eines Templates im Bereich um die Annotation
        % (Annotation befindet sich in der Mitte des Templates
        if and((positionalignment(j)-template_pre_off)>=1,(positionalignment(j)+template_post_off<=length(signal)))
            template_out=template_out+signal(positionalignment(j)-template_pre_off:positionalignment(j)+template_post_off);
            countern = countern+1;
        end
        
    end
end
template_out=template_out/countern;


end
