function [ EParameter ] = saveParameters(SParameter,w_start,w_end)

% check for window-wise or full-signal parameter calculation
if nargin < 2 || isempty(w_start) || isempty(w_end)
    mode = 1;
    w_start = 0;
    w_end = SParameter.ecgHeader.total_time;
else
    mode = 2;
end

%calculate window start and end points in samples instead of seconds
w_start = w_start * SParameter.SampleFreq;
w_end = w_end * SParameter.SampleFreq;

%calculate parameters
for i = 1:numel(w_start)
    mask = (SParameter.BeatLoc+SParameter.BeatLength) > w_start(i) & ...
        (SParameter.BeatLoc+SParameter.BeatLength) <= w_end(i);

    % general information
    if mode == 1
        EParameter.Age = SParameter.ecgHeader.age;
        EParameter.Sex = SParameter.ecgHeader.sex;
        EParameter.TotalTime = SParameter.ecgHeader.total_time;
        EParameter.Lead = SParameter.ecgHeader.lead;
        EParameter.SamplFreq = SParameter.SampleFreq;
        EParameter.Gain = SParameter.ecgHeader.gain;
        EParameter.NumBeats = size(SParameter.RLocation,1);
    end

    % statistical measures
    RR = SParameter.RR(mask')/SParameter.SampleFreq*1000;

    % filter RR
    rr_thr = 30;
    [filtBeats, filtRate] = filtRR(SParameter.BeatLoc(mask),RR,rr_thr);
    EParameter.HRV_filtRate(i) = filtRate;
    if filtRate < .8
        RR = RR(filtBeats == 0)';

        EParameter.HRV_meanRR(i) = HRV.nanmean(RR/1000)*1000;
        EParameter.HRV_medianRR(i) = HRV.nanmedian(RR/1000)*1000;
        EParameter.HRV_minRR(i) = nanmin(RR/1000)*1000;
        EParameter.HRV_maxRR(i) = nanmax(RR/1000)*1000;
        EParameter.HRV_SDRR(i) = HRV.SDNN(RR/1000,0,0)*1000;
        EParameter.HRV_RMSSD(i) = HRV.RMSSD(RR/1000,0,0)*1000;
        EParameter.HRV_SDSD(i) = HRV.SDSD(RR/1000,0,0)*1000;
        EParameter.HRV_RRV(i) = ((EParameter.HRV_SDRR(i).^2)./(EParameter.HRV_meanRR(i).^2))*1000;
        [EParameter.HRV_pNN50(i),EParameter.HRV_NN50(i)] = HRV.pNNx(RR/1000,0,50,0);
        if EParameter.HRV_pNN50(i)==0
            EParameter.HRV_pNN50(i)=nan;
        end
        if EParameter.HRV_NN50(i)==0
            EParameter.HRV_NN50(i)=nan;
        end
        % geometric measures
        [EParameter.HRV_tri(i),EParameter.HRV_TINN(i)] = HRV.triangular_val(RR/1000,0);
        [EParameter.HRV_SD1(i),EParameter.HRV_SD2(i),EParameter.HRV_SD1SD2ratio(i)] = HRV.returnmap_val(RR/1000,0);
        % frequency measures
        [EParameter.HRV_pLF(i),EParameter.HRV_pHF(i),EParameter.HRV_LFHFratio(i),EParameter.HRV_VLF(i),EParameter.HRV_LF(i),EParameter.HRV_HF(i)] = HRV.fft_val(RR/1000,0,1000);
        % nonlinear measures
        EParameter.HRV_ApEn(i) = HRV.ApEn(RR/1000,0);
        p_DFA = HRV.DFA(RR/1000,10:40,70:300);
        EParameter.HRV_DFA1(i) = p_DFA(1);
        EParameter.HRV_DFA2(i) = p_DFA(2);
    else
        EParameter.HRV_meanRR(i) = NaN;
        EParameter.HRV_medianRR(i) = NaN;
        EParameter.HRV_minRR(i) = NaN;
        EParameter.HRV_maxRR(i) = NaN;
        EParameter.HRV_SDRR(i) = NaN;
        EParameter.HRV_RMSSD(i) = NaN;
        EParameter.HRV_SDSD(i) = NaN;
        EParameter.HRV_RRV(i) = NaN;
        EParameter.HRV_pNN50(i) = NaN;
        EParameter.HRV_NN50(i) = NaN;
        % geometric measures
        EParameter.HRV_tri(i) = NaN;
        EParameter.HRV_TINN(i) = NaN;
        EParameter.HRV_SD1(i) = NaN;
        EParameter.HRV_SD2(i) = NaN;
        EParameter.HRV_SD1SD2ratio(i) = NaN;
        % frequency measures
        EParameter.HRV_pLF(i) = NaN;
        EParameter.HRV_pHF(i) = NaN;
        EParameter.HRV_LFHFratio(i) = NaN;
        EParameter.HRV_VLF(i) = NaN;
        EParameter.HRV_LF(i) = NaN;
        EParameter.HRV_HF(i) = NaN;
        % nonlinear measures
        EParameter.HRV_ApEn(i) = NaN;
        p_DFA = NaN;
        EParameter.HRV_DFA1(i) = NaN;
        EParameter.HRV_DFA2(i) = NaN;
    end

    %% SQI Analysis
    if mode == 1
        try
            EParameter.SQI_bas = bassqi(SParameter.ecgSignal,SParameter.SampleFreq);
        catch
            EParameter.SQI_bas = NaN;
        end
        try
            EParameter.SQI_k = ksqi(SParameter.ecgSignal);
        catch
            EParameter.SQI_k = NaN;
        end
        try
            EParameter.SQI_p = psqi(SParameter.ecgSignal,SParameter.SampleFreq);
        catch
            EParameter.SQI_p = NaN;
        end
        try
            EParameter.SQI_r = rsqi(SParameter.RLocation,SParameter.SampleFreq,0.96);
        catch
            EParameter.SQI_r = NaN;
        end
        try
            EParameter.SQI_s = ssqi(SParameter.ecgSignal);
        catch
            EParameter.SQI_s = NaN;    
        end
        try
            EParameter.SQI_std = stdsqi(SParameter.ecgSignal);
        catch
            EParameter.SQI_std = NaN;    
        end
        try
            EParameter.SQI_x = xsqi(SParameter.ecgSignal,SParameter.RLocation,SParameter.SampleFreq,0.12);
        catch
            EParameter.SQI_x = NaN;
        end
    end

    % QTV 
    if ~isnan(SParameter.QT)
        m_c = -0.36;
        norm_Tamp = 300;

        QT = SParameter.QT(mask')/SParameter.SampleFreq*1000;
        medianTamp = abs(SParameter.Template.Amps1(4));
        
        EParameter.QTV_meanQT(i) = nanmean(QT);
        EParameter.QTV_medianQT(i) = nanmedian(QT);
        EParameter.QTV_minQT(i) = nanmin(QT);
        EParameter.QTV_maxQT(i) = nanmax(QT);
        EParameter.QTV_SDQT(i) = nanstd(QT);
        EParameter.QTV_STVQT(i) = sum(abs(QT(2:end)-QT(1:end-1)))/(sqrt(2)*size(QT,1));
        EParameter.QTV_LTVQT(i) = sum(abs(QT(2:end)+QT(1:end-1)-2*EParameter.QTV_meanQT(i)))/(sqrt(2)*size(QT,1));
        EParameter.QTV_QTV(i) = ((EParameter.QTV_SDQT(i).^2)./(EParameter.QTV_meanQT(i).^2))*1000;
        EParameter.QTV_QTVi(i) = log10(EParameter.QTV_QTV(i)./EParameter.HRV_RRV(i));

        EParameter.QTV_cSDQT(i) = nanstd(QT)* (10.^(m_c*log10(norm_Tamp/medianTamp)));
        EParameter.QTV_cQTV(i) = (((EParameter.QTV_SDQT(i)* (10.^(m_c*log10(norm_Tamp/medianTamp)))).^2)./(EParameter.QTV_meanQT(i).^2))*1000;
        EParameter.QTV_cQTVi(i) = EParameter.QTV_QTVi(i) + 2*m_c*log10(norm_Tamp/medianTamp);
    else
        EParameter.QTV_meanQT(i) = NaN;
        EParameter.QTV_medianQT(i) = NaN;
        EParameter.QTV_minQT(i) = NaN;
        EParameter.QTV_maxQT(i) = NaN;
        EParameter.QTV_SDQT(i) = NaN;
        EParameter.QTV_STVQT(i) = NaN;
        EParameter.QTV_LTVQT(i) = NaN;
        EParameter.QTV_QTV(i) = NaN;
        EParameter.QTV_QTVi(i) = NaN;

        EParameter.QTV_cSDQT(i) = NaN;
        EParameter.QTV_cQTV(i) = NaN;
        EParameter.QTV_cQTVi(i) = NaN;

    end

    % template measures for template of cluster 1 and 2
    if mode == 1
        try
            EParameter.Template_clDiff = SParameter.clDiff;
        catch
            EParameter.Template_clDiff = NaN;
        end
        
        try
            EParameter.Template_clSize1 = SParameter.clSize1;
            EParameter.Template_Isolevel1 = SParameter.Template.Amps1(1);
            EParameter.Template_PQint1 = (SParameter.Template.Refs1(4)-SParameter.Template.Refs1(1))/SParameter.SampleFreq*1000;
            EParameter.Template_QRSint1 = (SParameter.Template.Refs1(6)-SParameter.Template.Refs1(4))/SParameter.SampleFreq*1000;
            EParameter.Template_QTint1 = (SParameter.Template.Refs1(9)-SParameter.Template.Refs1(4))/SParameter.SampleFreq*1000;
            EParameter.Template_PQamp1 = SParameter.Template.Amps1(2);
            EParameter.Template_QRSamp1 = SParameter.Template.Amps1(3);
            EParameter.Template_Tamp1 = SParameter.Template.Amps1(4);
        catch
            EParameter.Template_clSize1 = NaN;
            EParameter.Template_Isolevel1 = NaN;
            EParameter.Template_PQint1 = NaN;
            EParameter.Template_QRSint1 = NaN;
            EParameter.Template_QTint1 = NaN;
            EParameter.Template_PQamp1 = NaN;
            EParameter.Template_QRSamp1 = NaN;
            EParameter.Template_Tamp1 = NaN;
        end
        
        try
            EParameter.Template_clSize2 = SParameter.clSize2;
            EParameter.Template_Isolevel2 = SParameter.Template.Amps2(1);
            EParameter.Template_PQint2 = (SParameter.Template.Refs2(4)-SParameter.Template.Refs2(1))/SParameter.SampleFreq*1000;
            EParameter.Template_QRSint2 = (SParameter.Template.Refs2(6)-SParameter.Template.Refs2(4))/SParameter.SampleFreq*1000;
            EParameter.Template_QTint2 = (SParameter.Template.Refs2(9)-SParameter.Template.Refs2(4))/SParameter.SampleFreq*1000;
            EParameter.Template_PQamp2 = SParameter.Template.Amps2(2);
            EParameter.Template_QRSamp2 = SParameter.Template.Amps2(3);
            EParameter.Template_Tamp2 = SParameter.Template.Amps2(4);
        catch
            EParameter.Template_clSize2 = NaN;
            EParameter.Template_Isolevel2 = NaN;
            EParameter.Template_PQint2 = NaN;
            EParameter.Template_QRSint2 = NaN;
            EParameter.Template_QTint2 = NaN;
            EParameter.Template_PQamp2 = NaN;
            EParameter.Template_QRSamp2 = NaN;
            EParameter.Template_Tamp2 = NaN;
        end
    end
    
    %other parameters
    EParameter.Others_numPeaks = SParameter.num_peaks_norm;
    EParameter.Others_heightPeaksMean = SParameter.height_peaks_mean;
    EParameter.Others_heightPeaksMedian = SParameter.height_peaks_median;
    EParameter.Others_numPMStrokes = SParameter.pm_strokes;
    EParameter.Others_heightPeaksKurtosis = SParameter.height_peaks_kurtosis;
end
end

function [res] = isemptyToNaN(input)
if isempty(input)
    res = NaN;
else
    res = input;
end
end