function [AParameter, SParameter, skip] = readTemplate(AParameter, SParameter)

SParameter.Template.TemplateFileVer = -1;

if strcmp(AParameter.DataMode, 'wfdb_qtdb')
    SParameter.Template.TemplateFileVer = 0;
    skip = 0;
elseif ~strcmp(AParameter.DataMode,'Mathias_Pacing')
    try
        load([AParameter.TemplateDir AParameter.TemplateFile])
    catch exception
        
        display([SParameter.PlotPrefix ' Fehler beim Laden des Templates'])
        skip = true;
    end
else
    try
        tmp = strsplit(SParameter.PlotPrefix,'_');
        load([AParameter.TemplateDir tmp{1} '_Baseline_' tmp{3}])
    catch exception
        
        display([SParameter.PlotPrefix ' Fehler beim Laden des Templates'])
        skip = true;
    end
end

if and(~skip,SParameter.Template.TemplateFileVer ~= 0)
    % Fr alte Templates bei denen noch keine Vorverarbeitung
    % implementiert war
    if ~exist('PreProcMode','var')
        PreProcMode = 0;
    end
    % Prfe ob das Template mit der selben Vorverarbeitungsmethode
    % erstellt wurde
    
    if PreProcMode ~= AParameter.PreProcMode
        display([SParameter.PlotPrefix ' Achtung! Verschiedene Vorverarbeitungsmodi'])
    end
    %     if strcmp(AParameter.DataMode, 'baumert_real')
    %         RefR = round(RefQ + (RefS-RefQ)/2);
    %         SParameter.Refs = [RefQ RefR RefS RefTpeak RefTend; double(unicode2native('Q')) double(unicode2native('R')) double(unicode2native('S')) double(unicode2native('T')+unicode2native('P')) double(unicode2native('T'))];
    %         SParameter.InitRefs = SParameter.Refs;
    %     else
    if or(strcmp(SParameter.WindowMode,'modLagunaPT'),strcmp(SParameter.WindowMode,'modLagunaQT'))
        SParameter.Refs = [Refs; double(unicode2native('P'))+double(unicode2native('B')) double(unicode2native('P')) double(unicode2native('P'))+double(unicode2native('E')) double(unicode2native('Q')) double(unicode2native('R')) double(unicode2native('S')) double(unicode2native('T'))+double(unicode2native('B')) double(unicode2native('T')) double(unicode2native('T')+unicode2native('E'))];
        if ~AParameter.multiChannel
            SParameter.Refs(1,:) = SParameter.Refs(1,:) - LeftCut + 1;
        end
        SParameter.InitRefs = SParameter.Refs;
    else
        SParameter.Refs = Refs;
    end
    %     end
    SParameter.Template.LeftCut = LeftCut;
    SParameter.Template.RightCut = RightCut;
    
    % Version > 0.2
    if exist('file_ver','var')
        if str2double(strrep(file_ver,'v','')) == 0.2
            AParameter.DataMode = DataMode;
            AParameter.DataModeParameter = getDataMode(AParameter.DataMode);
            %AParameter.DataDir = DataDir;
            SParameter.Channel = Channel;
            SParameter.Template.SampleFreq = SampleFreq;
            AParameter.PreProcMode = PreProcMode;
            SParameter.Template.TemplateFileVer = str2double(strrep(file_ver,'v',''));
            if PreProcMode ~= AParameter.PreProcMode
                display([SParameter.PlotPrefix ' Achtung! Vorverarbeitungsmodi aus Template bernommen'])
            end
        elseif str2double(strrep(file_ver,'v','')) == 0.3
            AParameter.DataMode = DataMode;
            AParameter.DataModeParameter = getDataMode(AParameter.DataMode);
            %AParameter.DataDir = DataDir;
            SParameter.Channel = Channel;
            SParameter.Template.SampleFreq = SampleFreq;
            AParameter.PreProcMode = PreProcMode;
            SParameter.Template.TemplateFileVer = str2double(strrep(file_ver,'v',''));
            if PreProcMode ~= AParameter.PreProcMode
                display([SParameter.PlotPrefix ' Achtung! Vorverarbeitungsmodi aus Template bernommen'])
            end
            if or(or(strcmp(SParameter.WindowMode,'modLagunaPT'),strcmp(SParameter.WindowMode,'modLagunaQT')),strcmp(SParameter.WindowMode,'mQRS'))
                SParameter.Template.Ref.Refs = SParameter.Refs;
                if ~AParameter.multiChannel
                    SParameter.Refs(1,:) = SParameter.Refs(1,:) + QRSDetect;
                end
                SParameter.Refs(3,:) = PreRefs;
                SParameter.Refs(3,~isnan(SParameter.Refs(3,:))) = 1;
                SParameter.Template.Ref.QRSDetect = QRSDetect;
                SParameter.Template.Ref.QRSDiff = QRSDiff;
                SParameter.Template.Ref.TDEShift = TDEShift;
            end
        else
            SParameter.Template.TemplateFileVer = 0.1;
        end
        
    end
elseif skip
    display([SParameter.PlotPrefix ' Template bersprungen'])
end

end

