function [ AParameter, SParameter, skip ] = readData(AParameter, SParameter )

os = getenv('OS');
if strcmp(os,'Windows_NT')
    deli = '\';
else
    deli = '/';
end

skip = false;

SParameter.avChannel = {'Select','1','2','3'};

try
    [data,header_data] = load_challenge_data(strrep([AParameter.DataDir AParameter.DataFile],'.mat',''));
    [recording,Total_time,num_leads,leads,sfreq,gain,age,sex,med]=extract_data_from_header(header_data);
catch exception
    display([SParameter.PlotPrefix ' Fehler beim Laden der Signaldaten'])
    skip = true;
end

if size(data,1) > size(data,2)
    data = data';
end

SParameter.avChannel = cell(1,size(data,1)+1,1);
SParameter.avChannel{1} = 'Select';
for i=1:size(data,1)
    SParameter.avChannel{1,i+1} = num2str(i);
end

SParameter.ecgHeader.name = string(recording);
SParameter.ecgHeader.total_time = Total_time;
SParameter.ecgHeader.gain = gain(SParameter.Channel);
SParameter.ecgHeader.age = age;
SParameter.ecgHeader.sex = sex;
SParameter.ecgHeader.med = string(med);
SParameter.ecgHeader.lead = leads(SParameter.Channel);

SParameter.SampleFreq = sfreq;
if ischar(SParameter.Channel)
    SParameter.Channel = find(ismember(SParameter.avChannel,SParameter.Channel))-1;
end

SParameter.ecgSignal = data(SParameter.Channel,:);



if ~AParameter.template_create
    if ~isnan(SParameter.downsample)
        if SParameter.downsample >= SParameter.SampleFreq
            error('Downsampling > Sampling')
        end
        if round(SParameter.SampleFreq/SParameter.downsample) ~= SParameter.SampleFreq/SParameter.downsample
            error('Wahl Downsampling!')
        end
        SParameter.ecgSignal = downsample(SParameter.ecgSignal,SParameter.SampleFreq/SParameter.downsample);
        SParameter.SampleFreq = SParameter.downsample;
    end
    
    if ~isnan(SParameter.upsample)
        if SParameter.upsample <= SParameter.SampleFreq
            error('Upsampling < Sampling')
        end
        if round(SParameter.upsample/SParameter.SampleFreq) ~= SParameter.upsample/SParameter.SampleFreq
            error('Wahl Upsampling!')
        end
        SParameter.ecgSignal = interp(SParameter.ecgSignal,SParameter.upsample/SParameter.SampleFreq);
        SParameter.SampleFreq = SParameter.upsample;
    end
else
    SParameter.Template.SampleFreq = SParameter.SampleFreq;
end

SParameter.ecgSignal = SParameter.ecgSignal*SParameter.DataScale;

end

