%%Filter Implementierung
function [ECG_Data_New] = preproc(ECG_Data,AParameter,SParameter)

split_parts = ceil(length(ECG_Data) / 10000000);
ECG_Data_bak = ECG_Data;
pads = 1*SParameter.SampleFreq; %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i=1:split_parts
    if i ~= split_parts
        ECG_Data = ECG_Data_bak((i-1)*10000000+1:i*10000000);
    else
        ECG_Data = ECG_Data_bak((i-1)*10000000+1:length(ECG_Data_bak));
    end
    
    ECG_Data = padarray(ECG_Data,pads,0,'both'); %%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if AParameter.PreProcMode == 1
        Fs = SParameter.SampleFreq;	% Sampling Frequency
        Fstop1 = 0.2;	% First Stopband Frequency
        Fpass1 = 0.3;	% First Passband Frequency
        Fpass2 = 35;	% Second Passband Frequency
        Fstop2 = 50;	% Second Stopband Frequency
        Astop1 = 10;	% First Stopband Attenuation (dB)
        Apass  = 0.1;	% Passband Ripple (dB)
        Astop2 = 10;	% Second Stopband Attenuation (dB)
        match  = 'passband';	% Band to match exactly
        
        h  = fdesign.bandpass(Fstop1, Fpass1, Fpass2, Fstop2, Astop1, Apass, ...
            Astop2, Fs);
        Hd = design(h, 'butter', 'MatchExactly', match);
        
        % Mit ein- und ausschwingen
        ECG_Data_New = filtfilt(Hd.sosMatrix,Hd.scaleValues,[fliplr(ECG_Data) ECG_Data fliplr(ECG_Data)]);
        ECG_Data_New = ECG_Data_New(length(ECG_Data)+1:2*length(ECG_Data));
    elseif AParameter.PreProcMode == 2
        fs = SParameter.SampleFreq;
        fo = 50;
        q = 35;
        bw = (fo/(fs/2))/q;
        [b,a] = iircomb(fs/fo,bw,'notch');
        
        ECG_Data_New = filtfilt(b,a,[fliplr(ECG_Data) ECG_Data fliplr(ECG_Data)]);
        ECG_Data_New = ECG_Data_New(length(ECG_Data)+1:2*length(ECG_Data));
    elseif AParameter.PreProcMode == 3
        % Hochpass ab 0.3 Hz
        
        Fs = SParameter.SampleFreq;  % Sampling Frequency
        
        Fstop = 0.2;         % Stopband Frequency
        Fpass = 0.3;         % Passband Frequency
        Astop = 60;          % Stopband Attenuation (dB)
        Apass = 0.01;        % Passband Ripple (dB)
        match = 'stopband';  % Band to match exactly
        
        % Construct an FDESIGN object and call its BUTTER method.
        h  = fdesign.highpass(Fstop, Fpass, Astop, Apass, Fs);
        Hd = design(h, 'butter', 'MatchExactly', match);
        
        % Mit ein- und ausschwingen
        ECG_Data_New = filtfilt(Hd.sosMatrix,Hd.scaleValues,[fliplr(ECG_Data) ECG_Data fliplr(ECG_Data)]);
        ECG_Data_New = ECG_Data_New(length(ECG_Data)+1:2*length(ECG_Data));
    elseif AParameter.PreProcMode == 4
        % Hochpass ab 0.3 Hz + 60Hz comb
        
        Fs = SParameter.SampleFreq;  % Sampling Frequency
        
        Fstop = 0.2;         % Stopband Frequency
        Fpass = 0.3;         % Passband Frequency
        Astop = 60;          % Stopband Attenuation (dB)
        Apass = 0.01;        % Passband Ripple (dB)
        match = 'stopband';  % Band to match exactly
        
        % Construct an FDESIGN object and call its BUTTER method.
        h  = fdesign.highpass(Fstop, Fpass, Astop, Apass, Fs);
        Hd = design(h, 'butter', 'MatchExactly', match);
        
        % Mit ein- und ausschwingen
        ECG_Data_New = filtfilt(Hd.sosMatrix,Hd.scaleValues,[fliplr(ECG_Data) ECG_Data fliplr(ECG_Data)]);
        ECG_Data_New = ECG_Data_New(length(ECG_Data)+1:2*length(ECG_Data));
        
        fs = SParameter.SampleFreq;
        fo = 60;
        q = 35;
        wo = fo/(fs/2);  bw = wo/q;
        [b,a] = iirnotch(wo,bw);
        
        ECG_Data_New = filtfilt(b,a,[fliplr(ECG_Data_New) ECG_Data_New fliplr(ECG_Data_New)]);
        ECG_Data_New = ECG_Data_New(length(ECG_Data)+1:2*length(ECG_Data));     
     
    elseif AParameter.PreProcMode == 5 % Filter Studienarbeit
        Fs = SParameter.SampleFreq;  % Sampling Frequency

        Fstop1 = 0.2;         % First Stopband Frequency
        Fpass1 = 0.3;         % First Passband Frequency
        Fpass2 = 15;          % Second Passband Frequency
        Fstop2 = 45;          % Second Stopband Frequency
        Astop1 = 10;          % First Stopband Attenuation (dB)
        Apass  = 0.1;         % Passband Ripple (dB)
        Astop2 = 10;          % Second Stopband Attenuation (dB)
        match  = 'passband';  % Band to match exactly

        % Construct an FDESIGN object and call its BUTTER method.
        h  = fdesign.bandpass(Fstop1, Fpass1, Fpass2, Fstop2, Astop1, Apass, ...
                              Astop2, Fs);
        Hd = design(h, 'butter', 'MatchExactly', match);

        % Mit ein- und ausschwingen
        ECG_Data_New = filtfilt(Hd.sosMatrix,Hd.scaleValues,[fliplr(ECG_Data) ECG_Data fliplr(ECG_Data)]);
        ECG_Data_New = ECG_Data_New(length(ECG_Data)+1:2*length(ECG_Data));
    end
    ECG_Data_New = ECG_Data_New(pads+1:end-pads); %%%%%%%%%%%%%%%%%%%%%%%%%
    
    if i ~= split_parts
        ECG_Data_New_bak((i-1)*10000000+1:i*10000000) = ECG_Data_New;
    else
        ECG_Data_New_bak((i-1)*10000000+1:length(ECG_Data_bak)) = ECG_Data_New;
    end
    
end

ECG_Data_New = ECG_Data_New_bak;

if AParameter.Plot == 2
    figure;
    hold;
    plot(ECG_Data);
    plot(ECG_Data_New,'r');
    
    figure;
    hold;
    plot((0:length(ECG_Data)-1)/length(ECG_Data)*1000,abs(fft(ECG_Data)));
    plot((0:length(ECG_Data)-1)/length(ECG_Data)*1000,abs(fft(ECG_Data_New)),'r');
end
