function [ AParameter, SParameter, skip ] = preext( AParameter, SParameter, WParameter, skip )
%%% exclude motion artifacts
% limit height -> 2 seconds (1 sec overlap) -> mean(max) + 2 x std(max)

% cut ends if std is too high


%%% QRS Detection
if strcmp(SParameter.QRSMode,'biosig')
    if SParameter.SampleFreq == 257
%         QRSDetect2 = qrsdetect(SParameter.ecgSignal',256,2); % QRS detection based on Alfonso et al. 1999
%         QRSDetect = qrsdetect(SParameter.ecgSignal',256,1); % QRS detection based on Hilbert transformation
    else
%         QRSDetect2 = qrsdetect(SParameter.ecgSignal',SParameter.SampleFreq,2);% QRS detection based on Alfonso et al. 1999
        QRSDetect = qrsdetect(SParameter.ecgSignal',SParameter.SampleFreq,1);% QRS detection based on Hilbert transformation

        
        [SParameter,QRSDetect] = correctQRS(SParameter,QRSDetect);
%         QRSDetect2 = correctQRS(SParameter,QRSDetect2);
        
%         fig = figure; %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         subplot(1,2,1) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         plot(SParameter.ecgSignal) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         hold on %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         plot(QRSDetect.EVENT.POS,SParameter.ecgSignal(QRSDetect.EVENT.POS),'o')
%         subtitle([SParameter.ecgHeader.name + ', lead ' + string(SParameter.ecgHeader.lead)+', '+string(SParameter.SampleFreq)+' Hz'])
%         hold off
%         title('Hilbert transformation - qrsdetect Mode 1') %%%%%%%%%%%%%%%%
%         subtitle([SParameter.ecgHeader.name + ', lead ' + string(SParameter.ecgHeader.lead)+', '+string(SParameter.SampleFreq)+' Hz'])
%         ylabel('U in mV') %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         xlabel('time stamps') %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         set(gca,'FontSize',12) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         hold off %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         subplot(1,2,2) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         plot(SParameter.ecgSignal) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         hold on %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         plot(QRSDetect2.EVENT.POS,SParameter.ecgSignal(QRSDetect2.EVENT.POS),'o')
%         title('Alfonso et al. 1999 - qrsdetect Mode 2','FontSize',15) %%%%%
%         subtitle([SParameter.ecgHeader.name + ', lead ' + string(SParameter.ecgHeader.lead)+', '+string(SParameter.SampleFreq)+' Hz'])
%         set(gca,'FontSize',12) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         hold off %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         ylabel('U in mV') %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         xlabel('time stamps') %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         fig.Position = [100 100 800 300]; %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%         savefig(fig,['.\figures\qrsdetect_'+SParameter.ecgHeader.name+'-'+string(SParameter.ecgHeader.lead)+'.fig'])
%         close(fig) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
    
    SParameter.RLocation = QRSDetect.EVENT.POS;
    SParameter.RR = QRSDetect.EVENT.POS(2:end)-QRSDetect.EVENT.POS(1:end-1);
    SParameter.Annotation = ones(1,length(SParameter.RLocation))*78;
elseif strcmp(SParameter.QRSMode,'Ref')
    SParameter.RLocation = SParameter.RefRX;
    if ~isfield(SParameter,'RR')
        SParameter.RR = SParameter.RLocation(2:end)-SParameter.RLocation(1:end-1);
    end
    if ~isfield(SParameter,'Annotation')
        SParameter.Annotation = ones(1,length(SParameter.RLocation))*78;
    end
else
    disp('QRS Detection Routine nicht implementiert!')
end

%%% Beat Extraction
[BeatArray, BeatLoc, RLocationN] = extractBeats(SParameter.ecgSignal',SParameter.Annotation,SParameter.RLocation,SParameter.WindowMode, SParameter.SampleFreq);
if strcmp(AParameter.DataMode, 'wfdb_qtdb')
    [BeatArray, BeatLoc, RLocationN, SParameter] = extractBeatsRef(AParameter,SParameter);
end
SParameter.RLocationN = RLocationN;
SParameter.BeatLoc = BeatLoc;

for i=1:length(BeatArray)
    SParameter.BeatLength(i) = size(BeatArray{i},1);
end
SParameter.BeatArray = BeatArray;

%%% Template Generation
if strcmp(SParameter.Template.GenerationMode,'TDE')
    [BeatTemplate, AParameter, SParameter] = generateTemplateTDE(AParameter, SParameter);
elseif strcmp(SParameter.Template.GenerationMode,'Ref')
    [BeatTemplate, AParameter, SParameter] = generateTemplateRef(AParameter, SParameter);
elseif strcmp(SParameter.Template.GenerationMode,'EMG')
    [BeatTemplate, AParameter, SParameter] = generateTemplateEMG(AParameter, SParameter);
elseif strcmp(SParameter.Template.GenerationMode,'Cluster')
    [AParameter, SParameter] = clusterTemplate(AParameter, SParameter);
else
    disp('Template Generation Routine nicht implementiert!')
end

if SParameter.BeatTemplate == false
    skip = true;
end

% if SParameter.Channel~=SParameter.convChannel
%     figure, plot([1:length(BeatTemplate)]-SParameter.Template.TDEShift+SParameter.Template.QRSDiff,BeatTemplate,'b'), hold on, plot(SParameter.Refs(1,:) - SParameter.Template.TDEShift + SParameter.Template.QRSDiff,BeatTemplate(SParameter.Refs(1,:)),'b*')
% else
%     figure, plot(BeatTemplate,'r'), hold on, plot(SParameter.Refs(1,:),BeatTemplate(SParameter.Refs(1,:)),'r*')
% end

if and(AParameter.multiChannel,~AParameter.template_create)
    SParameter.Refs(1,:) = SParameter.Refs(1,:) - SParameter.Template.LeftCut + 1;
end

if ~AParameter.template_create
    % if ~strcmp(AParameter.DataMode, 'baumert_real')
        BeatTemplate = BeatTemplate(SParameter.Template.LeftCut:SParameter.Template.RightCut);
    % end
end

if ~skip
    SParameter.BeatTemplate = SParameter.BeatTemplate';
end

if and(~AParameter.template_create,strcmp(~AParameter.DataMode, 'wfdb_qtdb'))
    if or(strcmp(SParameter.WindowMode,'modLagunaPT'),strcmp(SParameter.WindowMode,'modLagunaQT'))
        SParameter.Template.TWA = abs(mean(SParameter.BeatTemplate([SParameter.Refs(1,SParameter.Refs(2,:)==(unicode2native('T') + unicode2native('B'))) SParameter.Refs(1,SParameter.Refs(2,:)==(unicode2native('T') + unicode2native('E')))])')-SParameter.BeatTemplate([SParameter.Refs(1,SParameter.Refs(2,:)==(unicode2native('T')))]));
    end
end

end

