function [h] = plotWarpedSignal(AParameter, SParameter, WParameter, TParameter, Counter, dSignal)

cSignalBeat = [0 0 0];
cTemplate = [31 58 213] ./ 255;
if TParameter.Iteration == 1
    c2DSW = [56 126 244] ./ 255;
elseif TParameter.Iteration == 2
    c2DSW = [40 215 234] ./ 255;
elseif TParameter.Iteration == 3
    c2DSW = [6 205 50] ./ 255;
elseif TParameter.Iteration == 4
    c2DSW = [226 255 12] ./ 255;
elseif TParameter.Iteration == 5
    c2DSW = [255 175 17] ./ 255;
elseif TParameter.Iteration == 6
    c2DSW = [255 113 94] ./ 255;
elseif TParameter.Iteration == 7
    c2DSW = [255 0 0] ./ 255;    
end

if TParameter.Iteration == 1
    scrsz = get(0, 'ScreenSize');
    if AParameter.Print
        h = figure('Position', [50 scrsz(4)-100-1000 1600 1000],'Visible','off');
    else
        h = figure('Position', [50 scrsz(4)-100-1000 1600 1000]);
    end
    hold on;
end

% for i=0:WParameter.xSegAnz
%     if i == 0
%         plot([0,0]+SParameter.Signal_xmin,[WParameter.Grid_ymin,WParameter.Grid_ymax],'b--');
%     elseif i == WParameter.xSegAnz
%         plot([sum(WParameter.xSegLength(1:i))-1,sum(WParameter.xSegLength(1:i))-1]+SParameter.Signal_xmin,[WParameter.Grid_ymin,WParameter.Grid_ymax],'b--');
%     else
%         plot([sum(WParameter.xSegLength(1:i))-1,sum(WParameter.xSegLength(1:i))-1]+SParameter.Signal_xmin,[WParameter.Grid_ymin,WParameter.Grid_ymax],'b--');
%     end
% end
% 
% for i=0:WParameter.ySegAnz
%     if i == 0
%         plot([0,WParameter.xLength]+SParameter.Signal_xmin,[WParameter.Grid_ymin,WParameter.Grid_ymin],'b--');
%     elseif i == WParameter.ySegAnz
%         plot([0,WParameter.xLength-1]+SParameter.Signal_xmin,WParameter.Grid_ymin+[sum(WParameter.ySegLength(1:i)),sum(WParameter.ySegLength(1:i))],'b--');
%     else
%         plot([0,WParameter.xLength-1]+SParameter.Signal_xmin,WParameter.Grid_ymin+[sum(WParameter.ySegLength(1:i)),sum(WParameter.ySegLength(1:i))],'b--');
%     end
% end

if TParameter.Iteration == 1
    for i=1:size(WParameter.WarpingPointsInit(:,:,1),1)-1
        for j=1:size(WParameter.WarpingPointsInit(:,:,1),2)
            plot([WParameter.WarpingPointsInit(i+1,j,1),WParameter.WarpingPointsInit(i,j,1)]+SParameter.Signal_xmin,[WParameter.WarpingPointsInit(i+1,j,2),WParameter.WarpingPointsInit(i,j,2)],'--','Color',cTemplate);
        end
    end
    for i=1:size(WParameter.WarpingPointsInit(:,:,1),1)
        for j=1:size(WParameter.WarpingPointsInit(:,:,1),2)-1
            plot([WParameter.WarpingPointsInit(i,j+1,1),WParameter.WarpingPointsInit(i,j,1)]+SParameter.Signal_xmin,[WParameter.WarpingPointsInit(i,j+1,2),WParameter.WarpingPointsInit(i,j,2)],'--','Color',cTemplate);
        end
    end
end

for i=1:WParameter.anzWarpingPoints
    WarpingPointZeile = fix((i - 1) / (WParameter.xSegAnz + 1));
    WarpingPointSpalte = mod(i - 1,WParameter.xSegAnz + 1);
    plot(WParameter.WarpingPoints(WarpingPointZeile+1,WarpingPointSpalte+1,1),WParameter.WarpingPoints(WarpingPointZeile+1,WarpingPointSpalte+1,2),'o','Color',c2DSW);
end

for i=1:size(WParameter.Points(:,:,1),1)-1
    for j=1:size(WParameter.Points(:,:,1),2)
        plot([WParameter.Points(i+1,j,3),WParameter.Points(i,j,3)],[WParameter.Points(i+1,j,4),WParameter.Points(i,j,4)],'Color',c2DSW);
    end
end
for i=1:size(WParameter.Points(:,:,1),1)
    for j=1:size(WParameter.Points(:,:,1),2)-1
        plot([WParameter.Points(i,j+1,3),WParameter.Points(i,j,3)],[WParameter.Points(i,j+1,4),WParameter.Points(i,j,4)],'Color',c2DSW);
    end
end


if ~AParameter.template_create
    WarpQX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeQ);
    WarpSX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeS);
    WarpRX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeR);
    WarpTendX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeTEnd);
    WarpTpeakX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeTPeak);
    WarpTbeginX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeTBegin);
    WarpPbeginX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodePBegin);
    WarpPpeakX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodePPeak);
    WarpPendX = SParameter.SignalMatrix(1,SParameter.SignalMatrix(4,:)==AParameter.PunktCodePEnd);
    
    WarpQY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeQ);
    WarpSY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeS);
    WarpRY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeR);
    WarpTendY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeTEnd);
    WarpTpeakY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeTPeak);
    WarpTbeginY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodeTBegin);
    WarpPbeginY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodePBegin);
    WarpPpeakY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodePPeak);
    WarpPendY = SParameter.SignalMatrix(2,SParameter.SignalMatrix(4,:)==AParameter.PunktCodePEnd);
    
    QTTimeWarp = WarpTendX - WarpQX;
end

if TParameter.Iteration == 1
    plot(1:length(SParameter.SignalBeat),SParameter.SignalBeat,'Color',cSignalBeat);
    plot((0:length(SParameter.SignalInit)-1)+SParameter.xShift,SParameter.SignalInit,'Color',cTemplate);
end
plot(SParameter.SignalMatrix(1,:),SParameter.SignalMatrix(2,:),'Color',c2DSW);


if and(AParameter.template_update,or(SParameter.Template.UpdateRefMode == 2,SParameter.Template.UpdateRefMode  == 0))
    for i=1:size(SParameter.Refs,2)
        if ~isnan(SParameter.Refs(1,i))
            RefsY = [RefsY, SParameter.Signal(SParameter.InitRefs(1,i))];
        end
    end
    
    plot(SParameter.InitRefs(1,~isnan(SParameter.InitRefs(1,:)))+SParameter.xShift-1,RefsY+SParameter.Signal_orgmin,'o','Color',cTemplate);
elseif AParameter.template_create
    QTTimeWarp = NaN;
else
    RefsY = [];
    for i=1:size(SParameter.Refs,2)
        if ~isnan(SParameter.Refs(1,i))
            RefsY = [RefsY, SParameter.Signal(SParameter.Refs(1,i))];
        end
    end
    
    plot(SParameter.Refs(1,~isnan(SParameter.Refs(1,:)))+SParameter.xShift-1,RefsY,'o','Color',cTemplate);
end

if ~AParameter.template_create
    plot([WarpPbeginX, WarpPpeakX, WarpPendX, WarpQX, WarpRX, WarpSX, WarpTbeginX, WarpTpeakX, WarpTendX],[WarpPbeginY, WarpPpeakY, WarpPendY, WarpQY, WarpRY, WarpSY, WarpTbeginY, WarpTpeakY, WarpTendY],'o','Color',c2DSW);
end

% for i=1:WParameter.xSegAnz
%     dSignalSpalte = calcGueteSpalte(i+1, SParameter.SignalMatrix, WParameter.xSegAnz, WParameter.xSegLength, WParameter.ySegAnz, WParameter.ySegLength, SParameter.SignalBeat, SParameter.SignalZV, TParameter.xSlack, TParameter.ySlack, SParameter.SignalZVBegin, SParameter.SignalZVEnd, AParameter.Plot);
%     text(round(cumsum(WParameter.xSegLength(i,2))),min(SParameter.Signal)+SParameter.Signal_orgmin,['\fontsize{10} ' num2str(dSignalSpalte)])
% end

title([num2str(Counter) ' dSignal ' num2str(dSignal) ', QTZeit: ' num2str(QTTimeWarp/SParameter.SampleFreq)]);
%     [TWelleSchnittX,TWelleSchnittY] = intersections(SParameter.SignalMatrix(1,:),SParameter.SignalMatrix(2,:),SignalZVBegin:SignalZVEnd,SParameter.SignalBeat,true);
%     TWelleSchnittXBegin = find(abs(TWelleSchnittX - TWelleWarpX(1)) == min(abs(TWelleSchnittX - TWelleWarpX(1))));
%     TWelleSchnittXEnd = find(abs(TWelleSchnittX - TWelleWarpX(2)) == min(abs(TWelleSchnittX - TWelleWarpX(2))));
%     plot([TWelleSchnittX(TWelleSchnittXBegin) TWelleSchnittX(TWelleSchnittXEnd)],[TWelleSchnittY(TWelleSchnittXBegin) TWelleSchnittY(TWelleSchnittXEnd)],'mo');

drawnow

if AParameter.Print
    set(h,'PaperPositionMode','auto', 'PaperType', 'A3','PaperOrientation','landscape','InvertHardcopy','off');
    if AParameter.template_update
        print(h, '-dpdf', '-r600', ['plot\TemplateWarp_' AParameter.PlotPrefix '_' num2str(SParameter.Template.Nr,'%06.0f') '_mode_' num2str(WParameter.WarpMode) '_iter_' num2str(WParameter.Iteration.max) '_segMode_' num2str(WParameter.SegMode) '_WarpTHR_' num2str(WParameter.WarpTHR) '_xSlackFak_' num2str(WParameter.xSlackFak) '_ySlackFak_' num2str(WParameter.ySlackFak) '.pdf']);
    else
        print(h, '-dpdf', '-r600', ['plot\' AParameter.PlotPrefix '_' num2str(Counter,'%06.0f') '_mode_' num2str(WParameter.WarpMode) '_iter_' num2str(WParameter.Iteration.max) '_segMode_' num2str(WParameter.SegMode) '_WarpTHR_' num2str(WParameter.WarpTHR) '_xSlackFak_' num2str(WParameter.xSlackFak) '_ySlackFak_' num2str(WParameter.ySlackFak) '.pdf']);
    end
end

if ~and(AParameter.Plot==1,AParameter.Print==0)
    close(h)
end


end