function [ template_out2, AParameter, SParameter ] = generateTemplateTDE(AParameter,SParameter)

if and(SParameter.Template.SearchForMedianRR,~AParameter.template_create)
    if 60*SParameter.Template.MedianRRseg*SParameter.Template.SearchLength*SParameter.SampleFreq > length(SParameter.ecgSignal)
        ecgSig = SParameter.ecgSignal(60*(SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*SParameter.SampleFreq+1:end)';
    else
        ecgSig = SParameter.ecgSignal(60*(SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*SParameter.SampleFreq+1:60*SParameter.Template.MedianRRseg*SParameter.Template.SearchLength*SParameter.SampleFreq)';
    end

    RAnn = find(and(SParameter.Template.MedianRRseg*SParameter.Template.SearchLength*60*SParameter.SampleFreq >= SParameter.RLocation, SParameter.RLocation >= (SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*60*SParameter.SampleFreq));
    Ann = SParameter.Annotation(RAnn);
    Rloc = SParameter.RLocation(RAnn) - 60*(SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*SParameter.SampleFreq;
    RR = SParameter.RR(RAnn);
elseif strcmp(AParameter.DataMode,'Mathias_Pacing')
    ecgSig = SParameter.tempSignal';
    Ann = SParameter.tempAnnotation;
    Rloc = SParameter.tempRLocation;
    RR = SParameter.tempRR;    
else
    ecgSig = SParameter.ecgSignal';
    Ann = SParameter.Annotation;
    Rloc = SParameter.RLocation;
    RR = SParameter.RR;
end

l = round(300*SParameter.SampleFreq/1000);
tmp_str = num2str(round(l/2*10));
if str2double(tmp_str(end)) == 5
    l = l + 1;
end

template_width = round(100*SParameter.SampleFreq/1000);
tmp_str = num2str(round(template_width/2*10));
if str2double(tmp_str(end)) == 5
    template_width = template_width + 1;
end
window = SParameter.Template.WindowMode;
quality_val = 1;
quality = SParameter.Template.StartQuality;

if strcmp(AParameter.DataMode,'wfdb_qtdb')
    window_shift_sek = 80;
else
    window_shift_sek = SParameter.Template.TemplateIntervall * 60;
end

window_shift = SParameter.SampleFreq*window_shift_sek;

if AParameter.template_update
    begin_index = SParameter.Templates(SParameter.Template.Nr).Int_Begin;
    template_search_intervall = SParameter.Template.UpdateIntervall;
else
    begin_index = SParameter.Template.BeginIndex;
    template_search_intervall = SParameter.Template.SearchLength; % in Minuten
end
% end_index = begin_index+window_shift;
noTemplate = true;

if (SParameter.Template.SearchLength * 60 * SParameter.SampleFreq) > size(ecgSig,1)
    SParameter.Template.SearchLength = floor(size(ecgSig,1) / 60 / SParameter.SampleFreq);
end

window_count = floor(((SParameter.Template.SearchLength * 60 * SParameter.SampleFreq)-begin_index+1)/(window_shift/2) - 1);
window_templates = cell(window_count,7);

if strcmp(AParameter.DataMode,'wfdb_qtdb')
    window_count = 1;
end
%elseif strcmp(AParameter.DataMode,'wfdb_nsrdb')
%    window_count = 100;
%end

if window_count < 1
    window_count = 1;
end

if ~isempty(RR)
    for i=1:window_count
        % Bestimmte Fenster-Grenzen
        begin_index_window = begin_index + (i-1)*(window_shift/2);
        end_index_window = begin_index_window + window_shift;
        
        % Suche R-Annotationen im Fenster
        RAnn = find(and(end_index_window >= Rloc, Rloc >= begin_index_window));
        if strcmp(AParameter.DataMode,'wfdb_qtdb')
            RAnn = [1:length(Rloc)];
            end_index_window = length(ecgSig);
        end
        % Filtere nach den R-Annotationen 'normal beat'
        RAnnN = char(Ann(RAnn(1:length(RAnn)))) == 'N';
        
        % Wenn genug Annotationen im Fenster
        %if length(RAnnN(RAnnN==1)) > (ceil(window_shift_sek)/3)
            RAnnN = RAnn(RAnnN == 1);
            
            % Falls es der letzte Schlag ist -> kein RR-Intervall vorhanden
            if ~isempty(find(RAnnN > length(RR), 1))
                RAnnN = RAnnN(RAnnN <= length(RR));
            end
            
            % Medianes RR-Intervall des Fensters
            RRmedian = median(RR(RAnnN));
            
            % Mglichkeit das Fenster manuell zu erweitern
            if isfield(SParameter.Template,'RRextend')
                RRmedian = RRmedian + SParameter.Template.RRextend;
            end
            
            % Positionen der R-Annotationen
            if strcmp(AParameter.DataMode,'wfdb_qtdb')
                positions = Rloc-begin_index_window+1;
            else
                positions = Rloc(RAnnN(2:end-2))-begin_index_window+1;
            end
            
            % Wenn erste R-Annotation ganz am Anfang -> bei der 2. beginnen
            if positions(1) == 0
                positions = positions(2:end);
                Ann = Ann(2:end);
                RR = RR(2:end);
                Rloc = Rloc(2:end);
            end
            
            % Falls Fenster lnger als Signal
            if end_index_window > length(ecgSig)
                end_index_window = length(ecgSig);
            end
            
            % Schlge im Fenster extrahieren
            signal = ecgSig(begin_index_window:end_index_window)';
            RRmedianr = round(RRmedian);
            [window_start, window_end, ndim] = beatwindow(RRmedianr,2*RRmedianr,SParameter.SampleFreq,window);
            
            window_start = round(window_start);
            window_end = round(window_end);
            template_ecg_witdh = window_end - window_start + 1;
            template_pre_off = RRmedianr-window_start;
            template_post_off = window_end-RRmedianr;
            tmp_template = zeros(1,template_ecg_witdh);
            
            % Wenn durch Ausschneiden auerhalb des Signals
            positions = positions(find((positions - template_pre_off) >= 1));
            positions = positions(find((positions + template_post_off) <= length(signal)));
            
            % Plot Template vor TDE
            if SParameter.Template.debugPlot
                figure
                title(['Schlge vor TDE: Anzahl = ' num2str(length(positions)) ' Qualitt = ' num2str(quality)]);
                hold on
                
                tmp_cnt = 0;
                for j=1:length(positions)
                    if ~isnan(positions(j));
                        tmp_template = tmp_template + (signal(positions(j)-template_pre_off:positions(j)+template_post_off));
                        tmp_cnt = tmp_cnt + 1;
                        plot(signal(positions(j)- template_pre_off:positions(j)+template_post_off))
                    end
                end
                
                plot(tmp_template/tmp_cnt,'r','LineWidth',2)
            end
            
            % Schlge mittels TDE ausrichten
            [positionalignment,template_out,not_aligned,template_before,zaehler]=tde_mod(positions,signal,l,template_width,SParameter.SampleFreq,window,RRmedian);
            
            % Plot der mittels TDE ausgerichteten Schlge
            if SParameter.Template.debugPlot
                figure
                title(['Schlge nach TDE: Anzahl = ' num2str(length(positionalignment)) ' Qualitt = ' num2str(quality)]);
                hold on
                tmp_template = zeros(1,template_ecg_witdh);
                tmp_cnt = 0;
            end
            
            clearvars('template_signals','template_signals_m');
            
            % Ungltige Positionen aussortieren
            positionalignment = positionalignment(~isnan(positionalignment));
            positionalignment = positionalignment(and((positionalignment-template_pre_off)>=1,(positionalignment+template_post_off<=length(signal))));
            positions = positions(and((positionalignment-template_pre_off)>=1,(positionalignment+template_post_off<=length(signal))));
            
            for j=1:length(positionalignment)
                template_signals{j} = signal(positionalignment(j)- template_pre_off:positionalignment(j)+template_post_off);
                template_median(j) = median(template_signals{j});
                if SParameter.Template.debugPlot
                    plot(template_signals{j})
                    tmp_template = tmp_template + template_signals{j};
                    tmp_cnt = tmp_cnt + 1;
                end
                template_signals_m{j} = template_signals{j} - median(template_signals{j});
            end
            
            if SParameter.Template.debugPlot
                plot(tmp_template/tmp_cnt,'r','LineWidth',2)
            end
            
            window_templates{i,1} = template_out;
            window_templates{i,2} = template_signals;
            window_templates{i,3} = template_median;
            window_templates{i,4} = template_signals_m;
            window_templates{i,5} = RRmedian;
            window_templates{i,6} = positionalignment;
            window_templates{i,7} = nanmedian(positions - positionalignment);
            window_templates{i,8} = RAnnN;
        % end
    end
    
    % Suche erstes Fenster wo weniger als 50% der Schlge aussortiert werden
    for j=1:10:1000
        for i=1:window_count
            if ~ isempty(window_templates{i,1})
                template_out = window_templates{i,1};
                template_signals = window_templates{i,2};
                template_median = window_templates{i,3};
                template_signals_m = window_templates{i,4};
                RRmedian = window_templates{i,5};
                positionalignment = window_templates{i,6};
                tde_shift = window_templates{i,7};
                
                eucl_disM = zeros(length(template_signals_m),1);
                
                % Anfang und Ende nicht so stark betrachten
                template_out_tmp = template_out-median(template_out);
                template_out_tmp_begin = round(0.1*length(template_out));
                template_out_tmp_end = round(0.9*length(template_out));
                template_out_tmp = template_out_tmp(template_out_tmp_begin:template_out_tmp_end);
                
                for k=1:length(template_signals_m)
                    
                    template_signals_tmp = template_signals_m{k};
                    template_signals_tmp = template_signals_tmp(template_out_tmp_begin:template_out_tmp_end);
                    eucl_disM(k) = Distance(template_signals_tmp,template_out_tmp)/length(template_out_tmp);
                end
                
                eucl_rej = eucl_disM>(quality_val + 1.1*(j-1));
                
                template_signals = template_signals(eucl_rej==0);
                template_out2 = zeros(1,length(template_out));
                template_e = zeros(1,length(template_out));
                
                % Plot der nicht exkludierten Schlge
                if SParameter.Template.debugPlot
                    figure
                    title(['Schlge nach Exklusion: Anzahl = ' num2str(length(template_signals)) ' Qualitt = ' num2str(j)]);
                    hold on
                end
                
                for k=1:length(template_signals)
                    if SParameter.Template.debugPlot
                        plot(template_signals{k})
                    end
                    template_out2 = template_out2 + template_signals{k};
                end
                
                template_out2 = template_out2 / length(template_signals);
                
                if SParameter.Template.debugPlot
                    plot(template_out2,'r','LineWidth',2)
                end
                
                if round(length(template_signals)/length(positionalignment)*100) >= 50
                    %display(['Begin bei: ' num2str(begin_index)])
                    quality = j;
                    section = i;
                    noTemplate = false;
                    
                    e_signals = cell2mat(template_signals');
                    for k=1:length(template_signals)
                        e_signals(k,:) = e_signals(k,:) - mean(e_signals(k,:));
                    end
                    
                    for k=1:length(template_out)
                        template_e(1,k) = std(e_signals(:,k));
                    end
                    
                    break;
                end
            end
        end
        if ~noTemplate
            break;
        end
    end
end

if ~noTemplate
    SParameter.Template.Quality = quality;
    if SParameter.Template.SearchForMedianRR
        SParameter.Template.Begin = 60*(SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*SParameter.SampleFreq + begin_index + (i-1)*(window_shift/2);
    else
        SParameter.Template.Begin = begin_index + (i-1)*(window_shift/2);
    end
    SParameter.Template.PreTDETemplate = template_out;
    SParameter.Template.Template = template_out2;
    SParameter.Template.TemplateE = template_e;    
    SParameter.Template.SampleFreq = SParameter.SampleFreq;
    SParameter.Template.RRmedian = RRmedian;
    SParameter.Template.PreProcMode = AParameter.PreProcMode;
    SParameter.Template.PositionAlignment = positionalignment;
    SParameter.Template.TDEShift = tde_shift;
    SParameter.Template.QRSDetect = template_pre_off + 1 + SParameter.Template.TDEShift; 
    SParameter.Template.Beats = window_templates{section,8};
    SParameter.Template.TemplateEstd = median(std(e_signals));
% else
%     display([SParameter.PlotPrefix ' Kein Template gefunden'])
%     if ~ AParameter.template_create
%         template_out2 = SParameter.BeatTemplate;
%     end
end

if and(noTemplate,begin_index==1)
    display([SParameter.PlotPrefix ' Kein initiales Template gefunden'])
    template_out2 = false;
end

end

