function [ BeatTemplate,Rloc ] = generateTemplate( BeatArray,BeatRAnn, AParameter )
    average_beats = 100;
    
    % average first x beats
    % calc median beatlength
    for i=1:average_beats
        BeatLength(i) = length(BeatArray{i});
    end
    BeatLength = median(BeatLength);
    
    counter=0;
    % finde ersten Schlag der Kriterien entspricht
    for i=1:average_beats
        if and(length(BeatArray{i}) < (BeatLength*1.2),length(BeatArray{i}) > (BeatLength*0.8))
            counter(i) = i;  
        else
            counter(i) = 100;
        end
    end
    counter = min(counter);
    
    if counter == 0
        display('template generation error')
    end
    
    BeatTemplate = BeatArray{counter};
    Rloc = BeatRAnn(counter);
    countern = 1;
    
    if AParameter.Plot
        figure
        hold on
        plot(BeatTemplate)
    end
    
    shift(1) = 0;
    % Suche Korrelation
    for i=counter+1:average_beats
        % xcorr
        lengthmax = max(length(BeatTemplate),length(BeatArray{i}));
        xcorrmax = find(max(xcorr(BeatTemplate,BeatArray{i})) == xcorr(BeatTemplate,BeatArray{i}));
        shift(i-counter+1) = xcorrmax(1) - lengthmax;
    end
    
    % Berechne Shift
    shift_begin(1) = 0;
    shift_end(1) = length(BeatTemplate);
    
    for i=counter+1:average_beats
        if and(length(BeatArray{i}) < (BeatLength*1.3),length(BeatArray{i}) > (BeatLength*0.8))
            if abs(shift(i-counter+1)) < BeatLength*0.3
                shift_begin(i-counter+1) = shift(i-counter+1);
                shift_end(i-counter+1) = length(BeatArray{i}) + shift(i-counter+1); 
            end          
        end
    end
    
    % Berechne Template Lnge
    shift_begin_t = max(shift_begin);
    shift_end_t = min(shift_end(shift_end~=0))-1;
    
    BeatTemplate = BeatTemplate(shift_begin_t+1:shift_end_t+1);
    
    if AParameter.Plot
        plot(shift_begin_t+1:shift_end_t+1,BeatTemplate,'r')
    end
    
    % Shifte
    for i=counter+1:average_beats
        if and(length(BeatArray{i}) < (BeatLength*1.3),length(BeatArray{i}) > (BeatLength*0.8))
            if abs(shift(i-counter+1)) < BeatLength*0.3
                t1 = shift_begin_t - shift_begin(i-counter+1);
                t2 = length(BeatArray{i}) - shift_begin(i-counter+1) - (length(BeatArray{i}) - shift_end_t);
                BeatTemp = BeatArray{i};
                BeatTemplate = BeatTemplate + BeatTemp(t1+1:t2+1);
                Rloc = Rloc + shift(i-counter+1) + BeatRAnn(i-counter+1) - shift_begin_t;                
                countern = countern + 1;    
            end
        end
    end
    
    Rloc = round(Rloc/countern);
    BeatTemplate = BeatTemplate/countern;
    
    if AParameter.Plot
        plot(shift_begin_t:shift_end_t,BeatTemplate,'k')
        figure 
        plot(BeatTemplate)
        hold
    end    
    
    % Savitzky-Golay filter 
    if AParameter.TemplateFilter
        BeatTemplate = sgolayfilt(BeatTemplate,2,15);
    end
    
    if AParameter.Plot
        plot(BeatTemplate,'r')
    end    
end

