function [filtBeats, filtRate] = filtRR(BeatLoc, RRseries, rr_thr)

old_BeatLoc = BeatLoc;
old_RRseries = RRseries;

BeatRejection.average_width = 100;
BeatRejection.rejFak = 2;

rr_mov_mean = moving_average_mean(RRseries,BeatRejection.average_width)';
rr_mov_std = moving_average_std(RRseries,BeatRejection.average_width)';
rr_mov_mean(rr_mov_mean<300) = 300;
rr_mov_mean(rr_mov_mean>1000) = 1000;
rr_mov_std(rr_mov_std>100) = 100;

rr_prefilt = find(RRseries < (rr_mov_mean' + 2*rr_mov_std'));

BeatLoc = BeatLoc(rr_prefilt);
RRseries = RRseries(rr_prefilt);

if size(BeatLoc,2) > 5
    filtBeats = ~ismember(1:size(old_BeatLoc,2),rr_prefilt(timeseriesFilterPercentage(RRseries',BeatLoc,'Deviation',rr_thr)))';
    filtRate = size(find(filtBeats>0),1)/size(filtBeats,1);
else
    filtBeats = old_BeatLoc;
    filtRate = 1;
end
end

