function EParameter = errorParameters(data, header_data, AParameter, SParameter, leads)

% read header data
[~, SParameter, ~] = readData_adjusted(data, header_data, AParameter,SParameter,leads);


%% General Parameters
    EParameter.Age = SParameter.ecgHeader.age;
    EParameter.Sex = SParameter.ecgHeader.sex;
    EParameter.TotalTime = SParameter.ecgHeader.total_time;
    EParameter.Lead = SParameter.ecgHeader.lead;
    EParameter.SamplFreq = SParameter.SampleFreq;
    EParameter.Gain = SParameter.ecgHeader.gain;
    EParameter.NumBeats = 0;

%% HRV parameters
    EParameter.HRV_filtRate = NaN;
    
    EParameter.HRV_meanRR = NaN;
    EParameter.HRV_medianRR = NaN;
    EParameter.HRV_minRR = NaN;
    EParameter.HRV_maxRR = NaN;
    EParameter.HRV_SDRR = NaN;
    EParameter.HRV_RMSSD = NaN;
    EParameter.HRV_SDSD = NaN;
    EParameter.HRV_RRV = NaN;
    EParameter.HRV_pNN50 = NaN;
    EParameter.HRV_NN50 = NaN;
    % geometric measures
    EParameter.HRV_tri = NaN;
    EParameter.HRV_TINN = NaN;
    EParameter.HRV_SD1 = NaN;
    EParameter.HRV_SD2 = NaN;
    EParameter.HRV_SD1SD2ratio = NaN;
    % frequency measures
    EParameter.HRV_pLF = NaN;
    EParameter.HRV_pHF = NaN;
    EParameter.HRV_LFHFratio = NaN;
    EParameter.HRV_VLF = NaN;
    EParameter.HRV_LF = NaN;
    EParameter.HRV_HF = NaN;
    % nonlinear measures
    EParameter.HRV_ApEn = NaN;
    p_DFA = NaN;
    EParameter.HRV_DFA1 = NaN;
    EParameter.HRV_DFA2 = NaN;
    

%% SQI Parameters
    try
        EParameter.SQI_bas = bassqi(SParameter.ecgSignal,SParameter.SampleFreq);
    catch
        EParameter.SQI_bas = NaN;
    end
    try
        EParameter.SQI_k = ksqi(SParameter.ecgSignal);
    catch
        EParameter.SQI_k = NaN;
    end
    try
        EParameter.SQI_p = psqi(SParameter.ecgSignal,SParameter.SampleFreq);
    catch
        EParameter.SQI_p = NaN;
    end
    EParameter.SQI_r = NaN;
    try
        EParameter.SQI_s = ssqi(SParameter.ecgSignal);
    catch
        EParameter.SQI_s = NaN;    
    end
    try
        EParameter.SQI_std = stdsqi(SParameter.ecgSignal);
    catch
        EParameter.SQI_std = NaN;    
    end
    EParameter.SQI_x = NaN;
    
    
%% QTV Parameters
    EParameter.QTV_meanQT = NaN;
    EParameter.QTV_medianQT = NaN;
    EParameter.QTV_minQT = NaN;
    EParameter.QTV_maxQT = NaN;
    EParameter.QTV_SDQT = NaN;
    EParameter.QTV_STVQT = NaN;
    EParameter.QTV_LTVQT = NaN;
    EParameter.QTV_QTV = NaN;
    EParameter.QTV_QTVi = NaN;

    EParameter.QTV_cSDQT = NaN;
    EParameter.QTV_cQTV = NaN;
    EParameter.QTV_cQTVi = NaN;
    
    
%% template measures for template of cluster 1 and 2
    EParameter.Template_clDiff = NaN;
    
    EParameter.Template_clSize1 = NaN;
    EParameter.Template_Isolevel1 = NaN;
    EParameter.Template_PQint1 = NaN;
    EParameter.Template_QRSint1 = NaN;
    EParameter.Template_QTint1 = NaN;
    EParameter.Template_PQamp1 = NaN;
    EParameter.Template_QRSamp1 = NaN;
    EParameter.Template_Tamp1 = NaN;

    EParameter.Template_clSize2 = NaN;
    EParameter.Template_Isolevel2 = NaN;
    EParameter.Template_PQint2 = NaN;
    EParameter.Template_QRSint2 = NaN;
    EParameter.Template_QTint2 = NaN;
    EParameter.Template_PQamp2 = NaN;
    EParameter.Template_QRSamp2 = NaN;
    EParameter.Template_Tamp2 = NaN;
    
    
%% Other Parameters
    peaks_all = findpeaks(SParameter.ecgSignal);

    EParameter.Others_numPeaks = numel(peaks_all)/(SParameter.ecgHeader.total_time);
    EParameter.Others_heightPeaksMean = mean(peaks_all);
    EParameter.Others_heightPeaksMedian = median(peaks_all);
    EParameter.Others_heightPeaksKurtosis = kurtosis(peaks_all);
    EParameter.Others_numPMStrokes = NaN;
end


