function [SParameter,QRSDetect] = correctQRS(SParameter,QRSDetect)

% delete qrs complexes that are too close to beginning or end
if(QRSDetect.EVENT.POS(1) < floor(SParameter.SampleFreq*0.3))
    QRSDetect.EVENT.POS(1) = [];
    QRSDetect.EVENT.TYP(1) = [];
    QRSDetect.EVENT.CHN(1) = [];
    QRSDetect.EVENT.DUR(1) = [];
elseif(QRSDetect.EVENT.POS(end) > (numel(SParameter.ecgSignal) - floor(SParameter.SampleFreq*0.3)))
    QRSDetect.EVENT.POS(end) = [];
    QRSDetect.EVENT.TYP(end) = [];
    QRSDetect.EVENT.CHN(end) = [];
    QRSDetect.EVENT.DUR(end) = [];
end


%% set detected qrs complexes to local maximum
w = floor(SParameter.SampleFreq * (0.1/2)); % offset: 100/2 ms
t_axis = 1:numel(SParameter.ecgSignal);
for ev = 1:length(QRSDetect.EVENT.POS)
    % define signal part
    if(QRSDetect.EVENT.POS(ev) - w <= 0)
        mask = t_axis>=0 & t_axis <= QRSDetect.EVENT.POS(ev)+w;
    elseif(QRSDetect.EVENT.POS(ev) + w > length(SParameter.ecgSignal))
        mask = t_axis >= QRSDetect.EVENT.POS(ev)-w & t_axis <= length(SParameter.ecgSignal);
    else
        mask = t_axis >= QRSDetect.EVENT.POS(ev)-w & t_axis <= QRSDetect.EVENT.POS(ev)+w;
    end
    s_temp = SParameter.ecgSignal;
    s_temp(~mask) = nan;

    % find actual peak
    [~,QRSDetect.EVENT.POS(ev)] = max(s_temp.^2);
end


%% find peaks that are too close to zero (<100?)
peaks_small = find(abs(SParameter.ecgSignal(QRSDetect.EVENT.POS))<100);
if numel(peaks_small)>0
    QRSDetect.EVENT.POS(peaks_small) = [];
end


%% find pathophysiological peaks
% sort out single positiv/negativ peaks
peaks = SParameter.ecgSignal(QRSDetect.EVENT.POS);
if(numel(peaks)>7)
    peaks_neg = find(peaks<0); %find negative peaks
    peaks_pos = find(peaks>0); %find positive peaks
    x = 2; %Factor with which positive / negative peaks must be overrepresented so that peaks with the other sign are rejected 
    if(numel(peaks)>=(numel(peaks_neg)*x) && numel(peaks_neg)~=0)
        for p = 1:numel(peaks_neg)
            if peaks(peaks_neg(p))<= -mean(abs(peaks))*0.8
                ev = QRSDetect.EVENT.POS(peaks_neg(p));
                mask = t_axis >= ev-w & t_axis <= ev+w;
                s_temp = SParameter.ecgSignal;
                s_temp(~mask) = nan;
                
                [peaks(peaks_neg(p)),QRSDetect.EVENT.POS(peaks_neg(p))] = max(s_temp);
            else
                QRSDetect.EVENT.POS(peaks_neg(p)) = nan;
            end
        end
        %QRSDetect.EVENT.POS(peaks_neg) = [];
    elseif(numel(peaks)>=(numel(peaks_pos)*x) && numel(peaks_pos)~=0)
        for p = 1:numel(peaks_pos)
            if peaks(peaks_pos(p))>= mean(abs(peaks))*0.8
                ev = QRSDetect.EVENT.POS(peaks_pos(p));
                mask = t_axis >= ev-w & t_axis <= ev+w;
                s_temp = SParameter.ecgSignal;
                s_temp(~mask) = nan;
                
                [peaks(peaks_pos(p)),QRSDetect.EVENT.POS(peaks_pos(p))] = min(s_temp);
            else
                QRSDetect.EVENT.POS(peaks_pos(p)) = nan;
            end
        end
        %QRSDetect.EVENT.POS(peaks_pos) = [];
    end
end

QRSDetect.EVENT.POS(isnan(QRSDetect.EVENT.POS)) = [];


%% find and sort out pace maker strokes
max_abs = max( abs(SParameter.ecgSignal) );
[~,halfMaxPeaks] = findpeaks(abs(SParameter.ecgSignal),'MinPeakHeight',max_abs/2);

pp_halfMaxPeaks = halfMaxPeaks(2:end)-halfMaxPeaks(1:end-1); %delete lower peaks if peaks are too close together
pp_short = find(pp_halfMaxPeaks < (0.1*SParameter.SampleFreq));
while(numel(pp_short)>0)
    temp1 = halfMaxPeaks(pp_short(1));
    temp2 = halfMaxPeaks(pp_short(1)+1);
    
    if SParameter.ecgSignal(temp1)>= SParameter.ecgSignal(temp2)
        halfMaxPeaks(halfMaxPeaks==temp2) = [];
    else
        halfMaxPeaks(halfMaxPeaks==temp1) = [];
    end

    pp_halfMaxPeaks(pp_short(1)) = [];
    pp_short = find(pp_halfMaxPeaks < (0.1*SParameter.SampleFreq));
end

if (numel(halfMaxPeaks)/SParameter.ecgHeader.total_time) <= 0.2 %take as pace maker activity if frequency of peaks of at least 1/2 height of max amplitude value is lower then 0.2Hz
    SParameter.pm_strokes = numel(halfMaxPeaks);
    temp = ismember(QRSDetect.EVENT.POS,halfMaxPeaks);
    QRSDetect.EVENT.POS(temp) = [];
else
    SParameter.pm_strokes = 0;
end


%% find peaks with a distance of less than at a HR of 240 bpm 
HR_max = 240/60;
RR = QRSDetect.EVENT.POS(2:end)-QRSDetect.EVENT.POS(1:end-1);
RR_short = find( (RR/SParameter.SampleFreq) <= (1/HR_max) );

while numel(RR_short)>0
    temp1 = QRSDetect.EVENT.POS(RR_short(1));
    temp2 = QRSDetect.EVENT.POS(RR_short(1)+1);
    
    temp_mean = median(SParameter.ecgSignal(QRSDetect.EVENT.POS));
    if(abs(SParameter.ecgSignal(temp1)-temp_mean)>=abs(SParameter.ecgSignal(temp2)-temp_mean))
        QRSDetect.EVENT.POS(RR_short(1)) = [];
    else
        QRSDetect.EVENT.POS(RR_short(1)+1) = [];
    end
    
    RR = QRSDetect.EVENT.POS(2:end)-QRSDetect.EVENT.POS(1:end-1);
	RR_short = find( (RR/SParameter.SampleFreq) <= (1/HR_max) );
end
    


%% find all peaks
peaks_all = findpeaks(SParameter.ecgSignal);
SParameter.num_peaks_norm = numel(peaks_all)/(SParameter.ecgHeader.total_time);
SParameter.height_peaks_mean = mean(peaks_all);
SParameter.height_peaks_median = median(peaks_all);
SParameter.height_peaks_kurtosis = kurtosis(peaks_all);


% check for missed peaks


% % delete qrs complexes that are too close to beginning or end
% if(QRSDetect.EVENT.POS(1) < floor(SParameter.SampleFreq*0.3))
%     QRSDetect.EVENT.POS(1) = [];
%     QRSDetect.EVENT.TYP(1) = [];
%     QRSDetect.EVENT.CHN(1) = [];
%     QRSDetect.EVENT.DUR(1) = [];
% elseif(QRSDetect.EVENT.POS(end) > (numel(SParameter.ecgSignal) - floor(SParameter.SampleFreq*0.3)))
%     QRSDetect.EVENT.POS(end) = [];
%     QRSDetect.EVENT.TYP(end) = [];
%     QRSDetect.EVENT.CHN(end) = [];
%     QRSDetect.EVENT.DUR(end) = [];
% end

end