function [AParameter, SParameter] = clusterTemplate(AParameter,SParameter)

if and(SParameter.Template.SearchForMedianRR,~AParameter.template_create)
    if 60*SParameter.Template.MedianRRseg*SParameter.Template.SearchLength*SParameter.SampleFreq > length(SParameter.ecgSignal)
        ecgSig = SParameter.ecgSignal(60*(SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*SParameter.SampleFreq+1:end)';
    else
        ecgSig = SParameter.ecgSignal(60*(SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*SParameter.SampleFreq+1:60*SParameter.Template.MedianRRseg*SParameter.Template.SearchLength*SParameter.SampleFreq)';
    end

    RAnn = find(and(SParameter.Template.MedianRRseg*SParameter.Template.SearchLength*60*SParameter.SampleFreq >= SParameter.RLocation, SParameter.RLocation >= (SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*60*SParameter.SampleFreq));
    Ann = SParameter.Annotation(RAnn);
    Rloc = SParameter.RLocation(RAnn) - 60*(SParameter.Template.MedianRRseg-1)*SParameter.Template.SearchLength*SParameter.SampleFreq;
    RR = SParameter.RR(RAnn);
elseif strcmp(AParameter.DataMode,'Mathias_Pacing')
    ecgSig = SParameter.tempSignal';
    Ann = SParameter.tempAnnotation;
    Rloc = SParameter.tempRLocation;
    RR = SParameter.tempRR;    
else
    ecgSig = SParameter.ecgSignal';
    Ann = SParameter.Annotation;
    Rloc = SParameter.RLocation;
    RR = SParameter.RR;
end

l = round(300*SParameter.SampleFreq/1000);
tmp_str = num2str(round(l/2*10));
if str2double(tmp_str(end)) == 5
    l = l + 1;
end

template_width = round(100*SParameter.SampleFreq/1000);
tmp_str = num2str(round(template_width/2*10));
if str2double(tmp_str(end)) == 5
    template_width = template_width + 1;
end
window = SParameter.Template.WindowMode;
quality_val = 1;
quality = SParameter.Template.StartQuality;

if strcmp(AParameter.DataMode,'wfdb_qtdb')
    window_shift_sek = 80;
else
    window_shift_sek = SParameter.Template.TemplateIntervall * 60;
end

window_shift = SParameter.SampleFreq*window_shift_sek;

if AParameter.template_update
    begin_index = SParameter.Templates(SParameter.Template.Nr).Int_Begin;
    template_search_intervall = SParameter.Template.UpdateIntervall;
else
    begin_index = SParameter.Template.BeginIndex;
    template_search_intervall = SParameter.Template.SearchLength; % in Minuten
end
% end_index = begin_index+window_shift;
noTemplate = true;

if (SParameter.Template.SearchLength * 60 * SParameter.SampleFreq) > size(ecgSig,1)
    SParameter.Template.SearchLength = floor(size(ecgSig,1) / 60 / SParameter.SampleFreq);
end

window_count = floor(((SParameter.Template.SearchLength * 60 * SParameter.SampleFreq)-begin_index+1)/(window_shift/2) - 1);
window_templates = cell(window_count,7);

if strcmp(AParameter.DataMode,'wfdb_qtdb')
    window_count = 1;
end
%elseif strcmp(AParameter.DataMode,'wfdb_nsrdb')
%    window_count = 100;
%end

if window_count < 1
    window_count = 1;
end

if ~isempty(RR)
    for i=1:window_count
        % Bestimmte Fenster-Grenzen
        begin_index_window = begin_index + (i-1)*(window_shift/2);
        end_index_window = begin_index_window + window_shift;
        
        % Suche R-Annotationen im Fenster
        RAnn = find(and(end_index_window >= Rloc, Rloc >= begin_index_window));
        if strcmp(AParameter.DataMode,'wfdb_qtdb')
            RAnn = [1:length(Rloc)];
            end_index_window = length(ecgSig);
        end
        % Filtere nach den R-Annotationen 'normal beat'
        RAnnN = char(Ann(RAnn(1:length(RAnn)))) == 'N';
        
        % Wenn genug Annotationen im Fenster
        %if length(RAnnN(RAnnN==1)) > (ceil(window_shift_sek)/3)
            RAnnN = RAnn(RAnnN == 1);
            
            % Falls es der letzte Schlag ist -> kein RR-Intervall vorhanden
            if ~isempty(find(RAnnN > length(RR), 1))
                RAnnN = RAnnN(RAnnN <= length(RR));
            end
            
            % Medianes RR-Intervall des Fensters
            RRmedian = median(RR(RAnnN));
            
            % Möglichkeit das Fenster manuell zu erweitern
            if isfield(SParameter.Template,'RRextend')
                RRmedian = RRmedian + SParameter.Template.RRextend;
            end
            
            % Positionen der R-Annotationen
            if strcmp(AParameter.DataMode,'wfdb_qtdb')
                positions = Rloc-begin_index_window+1;
            else
                positions = Rloc(RAnnN(2:end-2))-begin_index_window+1;
            end
            
            % Wenn erste R-Annotation ganz am Anfang -> bei der 2. beginnen
            if positions(1) == 0
                positions = positions(2:end);
                Ann = Ann(2:end);
                RR = RR(2:end);
                Rloc = Rloc(2:end);
            end
            
            % Falls Fenster länger als Signal
            if end_index_window > length(ecgSig)
                end_index_window = length(ecgSig);
            end
            
            % Schläge im Fenster extrahieren
            signal = ecgSig(begin_index_window:end_index_window)';
            RRmedianr = round(RRmedian);
            [window_start, window_end, ndim] = beatwindow(RRmedianr,2*RRmedianr,SParameter.SampleFreq,window);
            
            window_start = round(window_start);
            window_end = round(window_end);
            template_ecg_witdh = window_end - window_start + 1;
            template_pre_off = RRmedianr-window_start;
            template_post_off = window_end-RRmedianr;
            tmp_template = zeros(1,template_ecg_witdh);
            
            % Wenn durch Ausschneiden außerhalb des Signals
            positions = positions(find((positions - template_pre_off) >= 1));
            positions = positions(find((positions + template_post_off) <= length(signal)));
            
            % Plot Template vor TDE
            if SParameter.Template.debugPlot
                figure
                title(['Schläge vor TDE: Anzahl = ' num2str(length(positions)) ' Qualität = ' num2str(quality)]);
                hold on
                
                tmp_cnt = 0;
                for j=1:length(positions)
                    if ~isnan(positions(j));
                        tmp_template = tmp_template + (signal(positions(j)-template_pre_off:positions(j)+template_post_off));
                        tmp_cnt = tmp_cnt + 1;
                        plot(signal(positions(j)- template_pre_off:positions(j)+template_post_off))
                    end
                end
                
                plot(tmp_template/tmp_cnt,'r','LineWidth',2)
            end
            
            template_signals = cell(length(positions),1);
            template_signals_m = cell(length(positions),1);
            template_median = NaN*ones(length(positions),1);
            
            for j=1:length(positions)
                template_signals{j} = signal(positions(j)- template_pre_off:positions(j)+template_post_off);
                template_median(j) = median(template_signals{j});
                if SParameter.Template.debugPlot
                    plot(template_signals{j})
                    tmp_template = tmp_template + template_signals{j};
                    tmp_cnt = tmp_cnt + 1;
                end
                template_signals_m{j} = template_signals{j} - median(template_signals{j});
            end
            
            if SParameter.Template.debugPlot
                plot(tmp_template/tmp_cnt,'r','LineWidth',2)
            end
            
            window_templates{i,1} = NaN;
            window_templates{i,2} = template_signals;
            window_templates{i,3} = template_median;
            window_templates{i,4} = template_signals_m;
            window_templates{i,5} = RRmedian;
            window_templates{i,6} = positions;
            window_templates{i,7} = nanmedian(positions - positions);
            window_templates{i,8} = RAnnN;
        % end
    end
    
    
    %%% Cluster signals
    try
        
    template_signals_mA = cell2mat(template_signals_m);
    S =  mdwtcluster(template_signals_mA,'maxclust',2);
    
    cl_diff = mean(abs(median(template_signals_mA(S.IdxCLU(:,1)==1,:))-median(template_signals_mA(S.IdxCLU(:,1)==2,:))));
    
    cl_size1 = length(find(S.IdxCLU(:,1)==1))/size(template_signals_mA,1);
    cl_size2 = length(find(S.IdxCLU(:,1)==2))/size(template_signals_mA,1);
    

    if size(find(S.IdxCLU(:,1)==1),1) > 1
        [cl_positionalignment1,cl_template_out1,not_aligned,template_before,zaehler]=tde_mod(positions(find(S.IdxCLU(:,1)==1)),signal,l,template_width,SParameter.SampleFreq,window,RRmedian);        
    else
       cl_template_out1 = signal(positions(find(S.IdxCLU(:,1)==1))- template_pre_off:positions(find(S.IdxCLU(:,1)==1))+template_post_off);
    end
    if size(find(S.IdxCLU(:,1)==2),1) > 1
        [cl_positionalignment2,cl_template_out2,not_aligned,template_before,zaehler]=tde_mod(positions(find(S.IdxCLU(:,1)==2)),signal,l,template_width,SParameter.SampleFreq,window,RRmedian);
    else
        cl_template_out2 = signal(positions(find(S.IdxCLU(:,1)==2))- template_pre_off:positions(find(S.IdxCLU(:,1)==2))+template_post_off);
    end
    catch ex
        disp(ex)
    end
    % Plot the first cluster
%     close all
%     hold on;
%     plot(template_signals_mA(S.IdxCLU(:,1)==1,:)','r');
%     plot(cl_template_out1,'r','LineWidth',2);
%     
%     plot(template_signals_mA(S.IdxCLU(:,1)==2,:)','g')
%     plot(cl_template_out2,'g','LineWidth',2);
    
end

if cl_size1>cl_size2
    BeatTemplate = cl_template_out1;
else
    BeatTemplate = cl_template_out2;
    
    cl_template_out2 = cl_template_out1;
    cl_template_out1 = BeatTemplate;
    
    tmp = cl_size2;
    cl_size2 = cl_size1;
    cl_size1 = tmp;
end

SParameter.Template.SampleFreq = SParameter.SampleFreq;
SParameter.Template.Template = BeatTemplate';
SParameter.Template.RRmedian = RRmedian;
SParameter.BeatTemplate = BeatTemplate';
SParameter.BeatTemplate1 = cl_template_out1';
SParameter.BeatTemplate2 = cl_template_out2';
SParameter.clSize1 = cl_size1;
SParameter.clSize2 = cl_size2;
SParameter.clDiff = cl_diff;
    
end


