function QTseries = calcWarp(AParameter,SParameter)

scaleFak = NaN + ones(size(SParameter.BeatArray,1),1);

for i = 1:size(SParameter.BeatArray,1)
    
    SParameter.Signal = [1:length(SParameter.Template.Template);SParameter.Template.Template'];
    SParameter.SignalBeat = [1:size(SParameter.BeatArray{i},1);SParameter.BeatArray{i}'];
    
    % --- Grobverschiebung mittels Korrelation
    [xc,lags] = xcorr(SParameter.SignalBeat(2,:)-mean(SParameter.SignalBeat(2,:)),SParameter.Signal(2,:)-mean(SParameter.Signal(2,:)));
    SParameter.xShift = lags(find(xc == max(xc)));
    SParameter.xShiftXCorr = max(xc);
    SParameter.Signal(1,:) = SParameter.Signal(1,:) + SParameter.xShift;
    
    % --- Grobeverschiebung Höhe
    SParameter.yShift = median(SParameter.SignalBeat(2,:)) - median(SParameter.Signal(2,:));
    SParameter.Signal(2,:) = SParameter.Signal(2,:) + SParameter.yShift;
    
    QTSegment = SParameter.Signal(:,SParameter.Template.Refs1(5)+round(50/1000*SParameter.SampleFreq):SParameter.Template.Refs1(9));

    % --- QT Scaling
    scaleFactors = linspace(0.8,1.2,2001);
    dSignal = NaN*ones(2001,1);
    
    for j=1:200:2001
        QTSegmentS = (QTSegment(1,:) - QTSegment(1,1))*scaleFactors(j) + QTSegment(1,1);
        
        SignalZVEnd = floor(max(QTSegmentS));
        SignalZVBegin = ceil(min(QTSegmentS));
        SignalZV = interp1qr(QTSegmentS,QTSegment(2,:),SignalZVBegin:SignalZVEnd);
        dSignal(j) = calcGuete(SignalZV, SignalZVBegin, SignalZVEnd, SParameter.SignalBeat(2,:), AParameter, 1);
    end
    
    % dirty speed up code
    [val_sort,idx_sort] = sort(dSignal);
    
    for j=min(idx_sort(1:5)):100:max(idx_sort(1:5))
        QTSegmentS = (QTSegment(1,:) - QTSegment(1,1))*scaleFactors(j) + QTSegment(1,1);
        
        SignalZVEnd = floor(max(QTSegmentS));
        SignalZVBegin = ceil(min(QTSegmentS));
        SignalZV = interp1qr(QTSegmentS,QTSegment(2,:),SignalZVBegin:SignalZVEnd);
        dSignal(j) = calcGuete(SignalZV, SignalZVBegin, SignalZVEnd, SParameter.SignalBeat(2,:), AParameter, 1);
    end

    [val_sort,idx_sort] = sort(dSignal);
    
    for j=min(idx_sort(1:3)):50:max(idx_sort(1:3))
        QTSegmentS = (QTSegment(1,:) - QTSegment(1,1))*scaleFactors(j) + QTSegment(1,1);
        
        SignalZVEnd = floor(max(QTSegmentS));
        SignalZVBegin = ceil(min(QTSegmentS));
        SignalZV = interp1qr(QTSegmentS,QTSegment(2,:),SignalZVBegin:SignalZVEnd);
        dSignal(j) = calcGuete(SignalZV, SignalZVBegin, SignalZVEnd, SParameter.SignalBeat(2,:), AParameter, 1);
    end

   [val_sort,idx_sort] = sort(dSignal);
    
    for j=min(idx_sort(1:3)):20:max(idx_sort(1:3))
        QTSegmentS = (QTSegment(1,:) - QTSegment(1,1))*scaleFactors(j) + QTSegment(1,1);
        
        SignalZVEnd = floor(max(QTSegmentS));
        SignalZVBegin = ceil(min(QTSegmentS));
        SignalZV = interp1qr(QTSegmentS,QTSegment(2,:),SignalZVBegin:SignalZVEnd);
        dSignal(j) = calcGuete(SignalZV, SignalZVBegin, SignalZVEnd, SParameter.SignalBeat(2,:), AParameter, 1);
    end  
    
   [val_sort,idx_sort] = sort(dSignal);
    
    for j=min(idx_sort(1:3)):10:max(idx_sort(1:3))
        QTSegmentS = (QTSegment(1,:) - QTSegment(1,1))*scaleFactors(j) + QTSegment(1,1);
        
        SignalZVEnd = floor(max(QTSegmentS));
        SignalZVBegin = ceil(min(QTSegmentS));
        SignalZV = interp1qr(QTSegmentS,QTSegment(2,:),SignalZVBegin:SignalZVEnd);
        dSignal(j) = calcGuete(SignalZV, SignalZVBegin, SignalZVEnd, SParameter.SignalBeat(2,:), AParameter, 1);
    end 
    
   [val_sort,idx_sort] = sort(dSignal);
    
    for j=min(idx_sort(1:2)):5:max(idx_sort(1:2))
        QTSegmentS = (QTSegment(1,:) - QTSegment(1,1))*scaleFactors(j) + QTSegment(1,1);
        
        SignalZVEnd = floor(max(QTSegmentS));
        SignalZVBegin = ceil(min(QTSegmentS));
        SignalZV = interp1qr(QTSegmentS,QTSegment(2,:),SignalZVBegin:SignalZVEnd);
        dSignal(j) = calcGuete(SignalZV, SignalZVBegin, SignalZVEnd, SParameter.SignalBeat(2,:), AParameter, 1);
    end  
        
    [val_sort,idx_sort] = sort(dSignal);
    
    for j=min(idx_sort(1:2)):max(idx_sort(1:2))
        QTSegmentS = (QTSegment(1,:) - QTSegment(1,1))*scaleFactors(j) + QTSegment(1,1);
        
        SignalZVEnd = floor(max(QTSegmentS));
        SignalZVBegin = ceil(min(QTSegmentS));
        SignalZV = interp1qr(QTSegmentS,QTSegment(2,:),SignalZVBegin:SignalZVEnd);
        dSignal(j) = calcGuete(SignalZV, SignalZVBegin, SignalZVEnd, SParameter.SignalBeat(2,:), AParameter, 1);
    end    
    
    [val_min,loc_min] = min(dSignal);
    scaleFak(i) = scaleFactors(loc_min);
    
    
%     QTSegmentS = (QTSegment(1,:) - QTSegment(1,1) + 1)*scaleFak(i) + QTSegment(1,1);
% 
%     close all
%     figure
%     hold on
%     plot(SParameter.Signal(1,:),SParameter.Signal(2,:))
%     plot(SParameter.SignalBeat(1,:),SParameter.SignalBeat(2,:))
%     plot(QTSegment(1,:),QTSegment(2,:))
%     plot(QTSegmentS,QTSegment(2,:))
    
end
      
QTstat = (SParameter.Template.Refs1(5)+round(50/1000*SParameter.SampleFreq)-SParameter.Template.Refs1(4));
QTdyn = SParameter.Template.Refs1(9)-SParameter.Template.Refs1(5)-round(50/1000*SParameter.SampleFreq);

QTseries = QTstat+QTdyn*scaleFak;
        
end

