function [ isolevel ] = calcIsoLevel( template, refs, sfreq )

SignalZV = template(refs(2):refs(4));

diff = NaN * ones(size(SignalZV,2)-floor(sfreq/1000*20),1);

if size(SignalZV,2)-floor(sfreq/1000*20) >=1
    
    for j=1:(size(SignalZV,2)-floor(sfreq/1000*20))
        diff(j) = sum(abs(SignalZV(j:j+floor(sfreq/1000*20)-1)-mean(SignalZV(j:j+floor(sfreq/1000*20)-1))));
    end
    
    [min_val,min_idx] = min(diff);
    isolevel = mean(SignalZV(min_idx:min_idx+floor(sfreq/1000*20)-1));
else
    isolevel = mean(SignalZV);
end
% isolevels(i) = mean(y_values);

end
